/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.security.LoginContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.servlet.Servlet;
import org.apache.catalina.Context;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;

public final class J2EEInstanceListener
implements InstanceListener {
    private InvocationManager im = Switch.getSwitch().getInvocationManager();
    private J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
    private LoginContext lc = new LoginContext();
    private static boolean debug = false;

    public void instanceEvent(InstanceEvent event) {
        String eventType = event.getType();
        if (debug) {
            System.err.println("*** InstanceEvent: " + eventType);
        }
        if (eventType.equals("beforeService") || eventType.equals("beforeFilter") || eventType.equals("beforeInit") || eventType.equals("beforeDestroy")) {
            this.handleBeforeEvent(event, eventType);
        } else if (eventType.equals("afterService")) {
            this.handleAfterServiceEvent(event);
        } else if (eventType.equals("afterFilter") || eventType.equals("afterInit") || eventType.equals("afterDestroy")) {
            this.handleAfterEvent(event, eventType);
        } else {
            throw new IllegalStateException("Invalid event type: " + eventType);
        }
    }

    private void handleBeforeEvent(InstanceEvent event, String eventType) {
        Object instance = null;
        instance = eventType.equals("beforeFilter") ? event.getFilter() : event.getServlet();
        Context context = (Context)event.getWrapper().getParent();
        final ClassLoader cl2 = context.getLoader().getClassLoader();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(cl2);
                return null;
            }
        });
        ComponentInvocation inv = new ComponentInvocation(instance, context);
        try {
            this.im.preInvoke(inv);
            if (eventType.equals("beforeService")) {
                this.tm.enlistComponentResources();
            }
        }
        catch (Exception ex2) {
            Log.err.println(ex2);
            ex2.printStackTrace();
        }
    }

    /*
     * Loose catch block
     */
    private void handleAfterServiceEvent(InstanceEvent event) {
        block15: {
            Servlet servlet = event.getServlet();
            Context context = (Context)event.getWrapper().getParent();
            ComponentInvocation inv = new ComponentInvocation(servlet, context);
            this.im.postInvoke(inv);
            Object var7_5 = null;
            try {
                this.im.getCurrentInvocation();
            }
            catch (InvocationException iex) {
                try {
                    if (this.tm.getTransaction() != null) {
                        this.tm.rollback();
                    }
                    break block15;
                }
                catch (Exception ex2) {}
            }
            break block15;
            {
                catch (Exception ex3) {
                    Log.err.println(ex3);
                    ex3.printStackTrace();
                    Object var7_6 = null;
                    try {
                        this.im.getCurrentInvocation();
                    }
                    catch (InvocationException iex) {
                        try {
                            if (this.tm.getTransaction() != null) {
                                this.tm.rollback();
                            }
                            break block15;
                        }
                        catch (Exception ex2) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    this.im.getCurrentInvocation();
                }
                catch (InvocationException iex) {
                    try {
                        if (this.tm.getTransaction() != null) {
                            this.tm.rollback();
                        }
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private void handleAfterEvent(InstanceEvent event, String eventType) {
        Object instance = null;
        instance = eventType.equals("afterFilter") ? event.getFilter() : event.getServlet();
        Context context = (Context)event.getWrapper().getParent();
        ComponentInvocation inv = new ComponentInvocation(instance, context);
        try {
            try {
                this.im.postInvoke(inv);
            }
            catch (Exception ex2) {
                Log.err.println(ex2);
                ex2.printStackTrace();
                Object var8_7 = null;
                if (eventType.equals("afterDestroy")) {
                    this.tm.componentDestroyed(instance);
                }
            }
            Object var8_6 = null;
            if (eventType.equals("afterDestroy")) {
                this.tm.componentDestroyed(instance);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (eventType.equals("afterDestroy")) {
                this.tm.componentDestroyed(instance);
            }
            throw throwable;
        }
    }
}

