/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.web.server.WebContainerListener;
import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.logger.SystemOutLogger;
import org.apache.catalina.startup.Embedded;

public class EmbeddedWebService
extends Embedded {
    public Context createContext(String path, String docBase) {
        Context context = super.createContext(path, docBase);
        context.addInstanceListener("com.sun.web.server.J2EEInstanceListener");
        context.addContainerListener(new WebContainerListener());
        return context;
    }

    public static void main(String[] args) {
        System.out.println("Setting up background objects ...");
        String home = System.getProperty("catalina.home");
        if (home == null) {
            home = "/work/CATALINA/j2ee13/build/unix";
        }
        SystemOutLogger logger = new SystemOutLogger();
        EmbeddedWebService server = new EmbeddedWebService();
        server.setDebug(999);
        server.setLogger(logger);
        System.out.println("Create engine, host, and root context ...");
        Engine engine = server.createEngine();
        if (engine instanceof StandardEngine) {
            ((StandardEngine)engine).setDefaultHost("localhost");
        }
        Host host = server.createHost("localhost", home + "/webapps");
        engine.addChild(host);
        Context root = ((Embedded)server).createContext("", home + "/webapps/ROOT");
        host.addChild(root);
        server.addEngine(engine);
        System.out.println("Create connector ...");
        Connector connector = server.createConnector(null, 8000, false);
        server.addConnector(connector);
        System.out.println("Start the entire server and pause 60 seconds ...");
        try {
            server.start();
        }
        catch (LifecycleException e10) {
            e10.printStackTrace(System.out);
            System.exit(1);
        }
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException e11) {
            // empty catch block
        }
        System.out.println("Add examples context and pause 60 seconds ...");
        Context examples = ((Embedded)server).createContext("/examples", home + "/webapps/examples");
        host.addChild(examples);
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException e12) {
            // empty catch block
        }
        System.out.println("Shut down gracefully ...");
        try {
            server.stop();
        }
        catch (LifecycleException e13) {
            e13.printStackTrace(System.out);
            System.exit(1);
        }
    }
}

