/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.CoordinatorImpl;
import java.util.Vector;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.Coordinator;

class NestingInfo {
    CoordinatorImpl[] ancestorSeq = null;
    Vector childSet = new Vector();
    boolean removed = false;

    NestingInfo() {
    }

    NestingInfo(CoordinatorImpl[] ancestors) {
        this.ancestorSeq = (CoordinatorImpl[])ancestors.clone();
        this.removed = ancestors.length == 0;
    }

    public void finalize() {
        if (this.childSet != null) {
            this.childSet.removeAllElements();
        }
        this.childSet = null;
        if (this.ancestorSeq != null) {
            int i2 = 0;
            while (i2 < this.ancestorSeq.length) {
                this.ancestorSeq[i2] = null;
                ++i2;
            }
            this.ancestorSeq = null;
        }
    }

    boolean addChild(CoordinatorImpl child) {
        boolean result;
        boolean bl2 = result = !this.childSet.contains(child);
        if (result) {
            this.childSet.addElement(child);
        }
        return result;
    }

    boolean removeChild(CoordinatorImpl child) {
        boolean result = this.childSet.removeElement(child);
        return result;
    }

    void empty() {
        this.childSet.removeAllElements();
    }

    boolean removeFromParent(CoordinatorImpl child) {
        boolean result = true;
        if (!this.removed) {
            CoordinatorImpl parent = this.ancestorSeq[0];
            result = parent.removeChild(child);
            this.removed = true;
        }
        return result;
    }

    CoordinatorImpl getParent(boolean forgetting) {
        CoordinatorImpl result = null;
        if (this.ancestorSeq.length != 0) {
            result = this.ancestorSeq[0];
        }
        if (forgetting) {
            this.removed = true;
        }
        return result;
    }

    CoordinatorImpl getTopLevel() {
        CoordinatorImpl result = null;
        if (this.ancestorSeq.length != 0) {
            result = this.ancestorSeq[this.ancestorSeq.length - 1];
        }
        return result;
    }

    CoordinatorImpl[] getAncestors() {
        CoordinatorImpl[] result = null;
        result = (CoordinatorImpl[])this.ancestorSeq.clone();
        return result;
    }

    int numChildren() {
        return this.childSet.size();
    }

    boolean replyCheck() {
        boolean result = false;
        int i2 = 0;
        while (i2 < this.childSet.size() && !result) {
            CoordinatorImpl child = (CoordinatorImpl)this.childSet.elementAt(i2);
            result = child.isActive();
            ++i2;
        }
        return result;
    }

    boolean isDescendant(Coordinator other) {
        boolean result = false;
        try {
            int i2 = 0;
            while (i2 < this.ancestorSeq.length && !result) {
                result = this.ancestorSeq[i2].is_same_transaction(other);
                ++i2;
            }
        }
        catch (SystemException exc) {
            result = false;
        }
        return result;
    }

    void rollbackFamily() {
        while (this.childSet.size() > 0) {
            CoordinatorImpl child = (CoordinatorImpl)this.childSet.elementAt(0);
            try {
                child.rollback(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

