/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.util;

import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import com.sun.jms.util.WaiterManager;
import com.sun.jms.util.WorkerThread;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class Waiter {
    static Logger logger = Log.getLogger(3);
    private final WaiterManager manager;
    WorkerThread worker = null;
    private ThreadGroup threadGroup = null;
    private String threadName = null;
    public static final int INDEFINITE = 0;
    private int waitTimeout = 0;
    private volatile boolean activityDetected = false;
    private volatile int state = 0;
    public static final int WAITER_NOT_STARTED = 0;
    public static final int WAITER_RUNNING = 1;
    public static final int WAITER_SUSPENDED = 2;
    public static final int WAITER_STOPPED = 3;
    private static int waiters = 0;

    public Waiter(ThreadGroup threadGroup, WaiterManager manager, String threadName, int waitTimeout) {
        this.threadGroup = threadGroup;
        this.threadName = threadName;
        this.waitTimeout = waitTimeout;
        this.manager = manager;
        this.state = 1;
        this.activityDetected = false;
        ++waiters;
    }

    public Waiter(ThreadGroup threadGroup, WaiterManager manager, String threadName) {
        this(threadGroup, manager, threadName, 0);
    }

    public synchronized void stopRunning() {
        if (this.isStopped()) {
            return;
        }
        if (logger.isLogging(7)) {
            logger.finest("Waiter " + this.getName() + " stopRunning entered. state: " + this.state);
        }
        this.checkActivityDetected();
        this.state = 3;
        this.worker.stopWorking();
        --waiters;
    }

    public synchronized void suspendRunning() {
        if (this.isStopped()) {
            logger.info("Ignoring attempt to suspendRunning stopped Waiter " + this.getName());
            return;
        }
        if (logger.isLogging(7)) {
            logger.finest("Waiter " + this.getName() + " suspendRunning entered. state: " + this.state);
        }
        this.checkActivityDetected();
        this.state = 2;
    }

    public synchronized int getState() {
        return this.state;
    }

    public synchronized void resumeRunning() {
        if (this.isStopped()) {
            logger.info("Ignoring attempt to resumeRunning stopped Waiter " + this.getName());
            return;
        }
        if (logger.isLogging(7)) {
            logger.finest("Waiter " + this.getName() + " resumeRunning entered. state: " + this.state);
        }
        this.state = 1;
        this.wakeup();
    }

    public synchronized boolean isRunning() {
        return this.state <= 1;
    }

    public synchronized boolean isSuspended() {
        return this.state == 2;
    }

    public synchronized boolean isStopped() {
        return this.state == 3;
    }

    private void checkActivityDetected() {
        Waiter waiter = this;
        synchronized (waiter) {
            if (this.activityDetected && this.isRunning()) {
                this.activityDetected = false;
                if (logger.isLogging(7)) {
                    logger.finest("Waiter " + this.getName() + " activityDetected: state = " + this.state);
                }
                try {
                    if (this.worker == null) {
                        this.startNewWorkerThread();
                    } else {
                        if (logger.isLogging(7)) {
                            logger.finest("Waiter " + this.getName() + " calling wakeup() on existing worker...");
                        }
                        this.worker.wakeup();
                    }
                }
                catch (Throwable t2) {
                    logger.warning(t2);
                }
            }
        }
    }

    public void wakeup() {
        Waiter waiter = this;
        synchronized (waiter) {
            if (logger.isLogging(7)) {
                logger.finest("Waiter " + this.getName() + " wakeup entered. state = " + this.state);
            }
            this.activityDetected = true;
            this.waiterNotify();
        }
    }

    private void waiterNotify() {
        Waiter waiter = this;
        synchronized (waiter) {
            if (logger.isLogging(7)) {
                logger.finest("Waiter " + this.getName() + " waiterNotify(). state = " + this.state);
            }
            if (this.activityDetected && this.isRunning()) {
                if (this.worker == null) {
                    this.startNewWorkerThread();
                } else {
                    if (logger.isLogging(7)) {
                        logger.finest("Waiter " + this.getName() + " calling wakeup() on existing worker...");
                    }
                    this.worker.wakeup();
                }
            }
        }
    }

    private void startNewWorkerThread() {
        if (logger.isLogging(7)) {
            logger.finest("Waiter " + this.getName() + " creating new worker thread...");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Waiter.this.worker = new WorkerThread(Waiter.this.threadGroup, Waiter.this.threadName, Waiter.this, Waiter.this.manager, Waiter.this.waitTimeout);
                Waiter.this.worker.start();
                return null;
            }
        });
    }

    public String getName() {
        return this.threadName;
    }

    public static void printDebugInfo() {
        logger.debugInfo("Number of Waiter objects: " + waiters);
        logger.debugInfo("\tNumber of active WorkerThreads: " + WorkerThread.getActiveWorkers());
    }
}

