/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.util;

import com.sun.jms.util.JmsResourceBundleManager;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class JmsResourceBundle {
    private static JmsResourceBundleManager bundleManager = JmsResourceBundleManager.getInstance();
    private String resourceName = null;
    private ResourceBundle resource = null;

    JmsResourceBundle(String resourceName) {
        try {
            this.resourceName = resourceName;
            this.resource = ResourceBundle.getBundle(resourceName);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public static JmsResourceBundle getBundle(String resourceName) {
        return bundleManager.getBundle(resourceName);
    }

    public String getString(String key, String defaultValue) {
        String returnValue = null;
        if (this.resource == null) {
            returnValue = "unable to locate resource bundle: " + this.resourceName;
        } else {
            try {
                returnValue = this.resource.getString(key);
            }
            catch (MissingResourceException mre) {
                returnValue = defaultValue;
            }
        }
        return returnValue;
    }

    public String getString(String key) {
        return this.getString(key, "unable to find localized string for key: " + key);
    }
}

