/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.util;

import java.io.FileInputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

public class JMSProperties {
    private static final String JMS_PROPERTY_NAME = "jms.properties";
    private static final String DEFAULT_USER_PROPERTY_FILETAIL = "/.jms.properties";
    private static final String DEFAULT_JMS_SYSTEM_PROPERTY_FILE = "com/sun/jms/util/jms.properties";
    public static final String CLIENT_TRANSPORT_PREFERENCE = "com.sun.jms.client.transport_preference";
    public static final String CLIENT_APP_NAME = "com.sun.jms.client.AppName";
    public static final String JRMP_TRANSPORT = "JRMP";
    public static final String IIOP_TRANSPORT = "IIOP";
    public static final String CLIENT_REAPER_INTERVAL = "com.sun.jms.service.client_reaper_interval";
    public static final String MAX_REDELIVERY_ATTEMPTS = "com.sun.jms.service.max_redelivery_attempts";
    public static final String WAITER_TIMEOUT_INTERVAL = "com.sun.jms.service.waiter_timeout_interval";
    private static JMSProperties instance = null;
    private Properties props;

    private JMSProperties() {
        String propertyFileName = System.getProperty("user.home") + DEFAULT_USER_PROPERTY_FILETAIL;
        Properties tempProps = new Properties(this.defaultProperties());
        try {
            propertyFileName = System.getProperty(JMS_PROPERTY_NAME, propertyFileName);
            FileInputStream is = new FileInputStream(propertyFileName);
            tempProps.load(is);
            ((InputStream)is).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.props = new Properties(tempProps);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Properties sysProps = JMSProperties.this.systemProperties();
                Enumeration keys = ((Hashtable)sysProps).keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    ((Hashtable)JMSProperties.this.props).put(key, sysProps.getProperty(key));
                }
                return null;
            }
        });
    }

    public static JMSProperties getInstance() {
        if (instance == null) {
            instance = new JMSProperties();
        }
        return instance;
    }

    public String getProperty(String propertyName) {
        return this.props.getProperty(propertyName);
    }

    public String getProperty(String propertyName, String def) {
        return this.props.getProperty(propertyName, def);
    }

    private Properties defaultProperties() {
        Properties defaultProps = new Properties();
        try {
            InputStream is = ClassLoader.getSystemResourceAsStream(DEFAULT_JMS_SYSTEM_PROPERTY_FILE);
            defaultProps.load(is);
            is.close();
        }
        catch (Exception e10) {
            System.err.println("Ignoring com/sun/jms/util/jms.properties due to exception " + e10.toString());
        }
        return defaultProps;
    }

    private Properties systemProperties() {
        return (Properties)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperties();
            }
        });
    }

    public Iterator getPropertyNamesStartingWith(String prefix) {
        LinkedList<String> lst = new LinkedList<String>();
        Enumeration<?> e10 = this.props.propertyNames();
        while (e10.hasMoreElements()) {
            String propertyName = (String)e10.nextElement();
            if (!propertyName.startsWith(prefix)) continue;
            lst.add(propertyName);
        }
        return lst.iterator();
    }

    public int getWaiterTimeoutInterval() {
        int timeoutInterval = 0;
        String timeoutProp = this.getProperty(WAITER_TIMEOUT_INTERVAL);
        if (timeoutProp != null) {
            try {
                timeoutInterval = 60000 * Integer.valueOf(timeoutProp);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return timeoutInterval;
    }
}

