/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.service.ConnectionImpl;
import com.sun.jms.service.DestinationImpl;
import com.sun.jms.service.QueueImpl;
import com.sun.jms.service.SessionImpl;
import com.sun.jms.service.TopicImpl;
import com.sun.jms.service.TopicSubscriberImpl;
import com.sun.jms.util.JmsResourceBundle;
import java.text.MessageFormat;
import javax.jms.JMSException;

public class TopicSessionImpl
extends SessionImpl {
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.service.LocalStrings");

    TopicSessionImpl(ConnectionImpl parentConnection) {
        super(parentConnection);
    }

    TopicSessionImpl(ConnectionImpl parentConnection, boolean isTransacted, int acknowledgeMode) {
        super(parentConnection, isTransacted, acknowledgeMode);
    }

    public QueueImpl createQueue(String queueName, boolean isTemporary) throws JMSException {
        throw new JMSException(resource.getString("topicsessionimpl.cannot_create_queue"));
    }

    TopicSubscriberImpl createTopicSubscriber(int consumerId, String destinationName, String messageSelector, String subscriptionName, boolean noLocal) throws JMSException {
        this.createMessageConsumer(consumerId, destinationName);
        DestinationImpl dest = SessionImpl.service.getDestination(destinationName);
        if (dest == null || !(dest instanceof TopicImpl)) {
            throw new JMSException(MessageFormat.format(resource.getString("topicsessionimpl.invalid_destination"), destinationName));
        }
        TopicSubscriberImpl consumer = null;
        if (subscriptionName == null) {
            consumer = new TopicSubscriberImpl(dest, this, consumerId, messageSelector, subscriptionName, noLocal);
            dest.register(consumer);
        } else {
            consumer = new TopicSubscriberImpl(dest, this, consumerId, messageSelector, subscriptionName, noLocal);
            consumer.initializeDurableSubscription();
            boolean returningDurableSubscriber = ((TopicImpl)dest).registerDurableSubscriber(consumer, this.parentConnection.getClientID(), subscriptionName);
            if (returningDurableSubscriber) {
                if (SessionImpl.logger.isLogging(5)) {
                    SessionImpl.logger.fine("<<<<<<<<< activating existing DurableSubscriber " + subscriptionName + ", recovering missed messages >>>>>>>>>");
                }
                consumer.sendLoggedMessages();
            }
        }
        return consumer;
    }
}

