/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.service.ConnectionImpl;
import com.sun.jms.service.DestinationImpl;
import com.sun.jms.service.QueueConnectionConsumerImpl;
import com.sun.jms.service.QueueSessionImpl;
import com.sun.jms.service.TopicSessionImpl;
import com.sun.jms.util.JmsResourceBundle;
import java.text.MessageFormat;
import javax.jms.JMSException;

public class QueueConnectionImpl
extends ConnectionImpl {
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.service.LocalStrings");

    QueueConnectionImpl(String pclientId, int connectionId) {
        super(pclientId, connectionId);
    }

    public QueueSessionImpl createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        QueueSessionImpl session = new QueueSessionImpl(this, transacted, acknowledgeMode);
        return session;
    }

    public TopicSessionImpl createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        throw new JMSException(resource.getString("queueconnectionimpl.cannot_create_topic_session"));
    }

    int getConnectionType() {
        return 0;
    }

    void createConnectionConsumer(int connectionConsumerID, String destinationName, String messageSelector, int maxMessages, String subscriptionName) throws JMSException {
        QueueConnectionConsumerImpl connectionConsumer = null;
        DestinationImpl destination = ConnectionImpl.service.getDestination(destinationName);
        if (destination == null) {
            throw new JMSException(MessageFormat.format(resource.getString("queueconnectionimpl.invalid_destination"), destinationName));
        }
        if (subscriptionName != null) {
            throw new JMSException(MessageFormat.format(resource.getString("queueconnectionimpl.no_subscription_name"), subscriptionName));
        }
        connectionConsumer = new QueueConnectionConsumerImpl(connectionConsumerID, destination, messageSelector, maxMessages, this);
        destination.register(connectionConsumer);
    }
}

