/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.Acknowledgement;
import com.sun.jms.ConnectionFactoryImpl;
import com.sun.jms.DestinationImpl;
import com.sun.jms.DurableSubscriptionDescriptor;
import com.sun.jms.JMSClient;
import com.sun.jms.JMSService;
import com.sun.jms.MessageImpl;
import com.sun.jms.XidImpl;
import com.sun.jms.service.ConnectionConsumerImpl;
import com.sun.jms.service.ConnectionImpl;
import com.sun.jms.service.ConsumerImpl;
import com.sun.jms.service.DBManager;
import com.sun.jms.service.DurableSubscription;
import com.sun.jms.service.InitialServiceContext;
import com.sun.jms.service.MessageConsumerImpl;
import com.sun.jms.service.QueueConnectionImpl;
import com.sun.jms.service.QueueImpl;
import com.sun.jms.service.QueueReceiverImpl;
import com.sun.jms.service.QueueSessionImpl;
import com.sun.jms.service.ReaperThread;
import com.sun.jms.service.SecurityManager;
import com.sun.jms.service.ServiceRecoveryManager;
import com.sun.jms.service.SessionImpl;
import com.sun.jms.service.TopicConnectionImpl;
import com.sun.jms.service.TopicImpl;
import com.sun.jms.service.TopicSessionImpl;
import com.sun.jms.service.TxnContextManager;
import com.sun.jms.spi.ExternalManager;
import com.sun.jms.util.JMSProperties;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import com.sun.jms.util.Statistician;
import com.sun.jms.util.Statistics;
import com.sun.jms.util.Waiter;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import javax.jms.ConnectionMetaData;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.ResourceAllocationException;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import javax.transaction.xa.XAException;

public class JMSServiceImpl
implements JMSService {
    private boolean isStopped = false;
    public static final Logger logger = Log.getLogger(1);
    public static final Logger rmiLogger = Log.getLogger(6);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.service.LocalStrings");
    static long idCount = 0L;
    static JMSServiceImpl instance = null;
    static ExternalManager externalManager = null;
    ConnectionFactoryImpl connectionFactory;
    private HashMap clientIdToConnectionsMap = new HashMap();
    private HashMap clientIdToJMSClientMap = new HashMap();
    private HashMap destinationNameToDestinationMap = new HashMap();
    private Statistician msgStatistician = new Statistician();
    private HashMap messages = new HashMap();
    InitialServiceContext context = null;
    DBManager dbManager = null;
    String xaResourceMgrId = null;
    TxnContextManager txnManager = null;
    boolean initializationComplete = false;
    static int service_registry_port = 1099;
    static final String METHOD_NAME_PROP = "SUN_MethodNameProp";
    boolean started = false;
    public static final String THREADGROUPNAME = "jms.service";
    public static ThreadGroup serviceThreadGroup = new ThreadGroup("jms.service");
    ReaperThread clientReaperThread = null;
    static final int REPORT_AWOL_CLIENTS = 1;
    static final int REMOVE_AWOL_CLIENTS = 2;
    static final int SILENT_REMOVE_AWOL_CLIENTS = 3;
    static final int SILENT_VALIDATE_AWOL_CLIENTS = 4;

    public JMSServiceImpl() {
        String serviceName;
        instance = this;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    instance.stop();
                }
                catch (Throwable t2) {
                    t2.printStackTrace();
                }
            }
        });
        this.txnManager = TxnContextManager.getInstance();
        this.xaResourceMgrId = serviceName = this.getServiceName();
        boolean JRMPSupported = this.rmiRegistryNeeded();
        if (JRMPSupported) {
            this.startRMIRegistry();
        }
        this.context = InitialServiceContext.getInstance();
        try {
            this.txnManager.initializeRecovery();
        }
        catch (Throwable t2) {
            logger.severe(MessageFormat.format(resource.getString("jmsserviceimpl.could_not_recover_transaction"), t2.getMessage()));
            logger.severe(t2);
        }
        try {
            if (externalManager == null || externalManager.getAutoRecover()) {
                this.txnManager.rollbackAll();
            }
        }
        catch (Throwable t3) {
            this.txnManager.rollbackAll();
            logger.severe(MessageFormat.format(resource.getString("jmsserviceimpl.externalmanager.getautorecover_not_implemented_yet"), t3.getMessage()));
        }
        if (JRMPSupported) {
            this.exportJrmpInterface(serviceName);
        }
        this.exportIIOPInterface(serviceName);
        this.initializeClientReaperThread();
        this.initializationCheck();
        if (!this.initializationComplete) {
            System.err.println(resource.getString("jmsserviceimpl.recovery_phase"));
        }
    }

    private void initializeClientReaperThread() {
        String reaperProp = JMSProperties.getInstance().getProperty("com.sun.jms.service.client_reaper_interval");
        if (reaperProp != null) {
            try {
                int reaperInterval = Integer.valueOf(reaperProp);
                this.clientReaperThread = new ReaperThread(serviceThreadGroup, "jms.service clientReaperThread", this.clientIdToJMSClientMap, reaperInterval, this);
                this.clientReaperThread.start();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private String getServiceName() {
        String serviceName = null;
        try {
            String hostName = null;
            serviceName = hostName = InetAddress.getLocalHost().getHostName();
            serviceName = serviceName + ".com.sun.jms.service.JMSService";
        }
        catch (UnknownHostException e10) {
            logger.severe(MessageFormat.format(resource.getString("jmsserviceimpl.failed_to_get_service_name"), e10.getMessage()));
            System.exit(-1);
        }
        return serviceName;
    }

    private void exportJrmpInterface(String serviceName) {
        try {
            UnicastRemoteObject.exportObject(this);
            InitialContext initialNamingContext = this.context.getExternalContext();
            String jrmpServiceName = serviceName + "." + "JRMP";
            initialNamingContext.rebind(jrmpServiceName, (Object)this);
            if (logger.isLogging(5)) {
                logger.fine("Done binding JRMP interface to '" + jrmpServiceName + "'");
            }
        }
        catch (Exception e10) {
            logger.severe(MessageFormat.format(resource.getString("jmsserviceimpl.failed_to_create_rmijrmp_server"), e10.getMessage()));
            logger.severe(e10);
            System.exit(-1);
        }
    }

    private boolean rmiRegistryNeeded() {
        ClassLoader cl2 = this.getClass().getClassLoader();
        InputStream inputstream = cl2.getResourceAsStream("jndi.properties");
        if (inputstream != null) {
            try {
                Properties p2 = new Properties();
                p2.load(inputstream);
                String initialFactory = p2.getProperty("java.naming.factory.initial");
                if (initialFactory == null) {
                    if (logger.isLogging(7)) {
                        logger.finest("java.naming.factory.initial not found");
                    }
                    return false;
                }
                if (initialFactory.equals("com.sun.jndi.rmi.registry.RegistryContextFactory")) {
                    logger.finest("found it, starting rmiregistry");
                    return true;
                }
                if (logger.isLogging(7)) {
                    logger.finest("found the prop, but it was: " + initialFactory + "\n\t" + cl2.getResource("jndi.properties"));
                }
                return false;
            }
            catch (IOException ioe) {
                logger.warning(resource.getString("jmsserviceimpl.error_loading_props"));
                logger.warning(ioe);
                return false;
            }
        }
        logger.finest("inputSteam was null....");
        return false;
    }

    private void startRMIRegistry() {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
            try {
                Registry rmireg = LocateRegistry.getRegistry(service_registry_port);
                rmireg.list();
                try {
                    ((JMSService)rmireg.lookup(this.getServiceName() + ".JRMP")).ping();
                    logger.severe(resource.getString("jmsserviceimpl.service_is_already_active_on_this_host"));
                    System.exit(-1);
                }
                catch (Throwable t2) {}
            }
            catch (RemoteException re) {
                try {
                    LocateRegistry.createRegistry(service_registry_port);
                }
                catch (RemoteException re2) {
                    logger.severe(MessageFormat.format(resource.getString("jmsserviceimpl.unable_to_locate_or_create_an_rmiregistry"), new Integer(service_registry_port)));
                    System.exit(-1);
                }
            }
        }
    }

    private void exportIIOPInterface(String serviceName) {
        try {
            PortableRemoteObject.exportObject((Remote)this);
            InitialContext initialNamingContext = this.context.getInternalContext();
            String iiopServicename = serviceName + "." + "IIOP";
            initialNamingContext.rebind(iiopServicename, (Object)this);
            if (logger.isLogging(5)) {
                logger.fine("Done binding IIOP interface to '" + iiopServicename + "'");
            }
        }
        catch (Exception e10) {
            logger.severe(MessageFormat.format(resource.getString("jmsserviceimpl.failed_to_created_rmiiiop_server"), e10.getMessage()));
            System.exit(-1);
        }
    }

    public static JMSServiceImpl getInstance() {
        if (instance == null) {
            new JMSServiceImpl();
        }
        return instance;
    }

    public ExternalManager getExternalManager() {
        return externalManager;
    }

    public static void setExternalManager(ExternalManager mgr) {
        externalManager = mgr;
    }

    public static void main(String[] args) {
        int i2 = 0;
        while (i2 < args.length) {
            if (args[i2].charAt(0) == '-') {
                System.err.println(MessageFormat.format(resource.getString("jmsserviceimpl.illegal_argument"), args[i2]));
                System.err.println(resource.getString("jmsserviceimpl.usage"));
                System.exit(-1);
            }
            ++i2;
        }
        JMSServiceImpl jMSServiceImpl = JMSServiceImpl.getInstance();
    }

    public String registerClient(String appName, JMSClient client) throws JMSException {
        Object[] params = null;
        if (rmiLogger.isLogging(6)) {
            params = new Object[]{"appName=" + appName};
            rmiLogger.entering(params);
        } else if (logger.isLogging(6)) {
            logger.finer("appname: " + appName + ",  client: " + client);
        }
        String pclientId = this.generateId(appName);
        this.addClient(pclientId, client);
        if (rmiLogger.isLogging(6)) {
            rmiLogger.exiting(params, pclientId);
        }
        return pclientId;
    }

    public void deregisterClient(String pclientId) throws JMSException {
        Object[] params = null;
        if (rmiLogger.isLogging(6)) {
            params = new Object[]{pclientId};
            rmiLogger.entering(params);
        } else if (logger.isLogging(6)) {
            logger.finer("pclientId: " + pclientId);
        }
        this.removeClient(pclientId);
        Collection connections = this.getConnections(pclientId);
        if (connections != null) {
            Iterator iter = connections.iterator();
            while (iter.hasNext()) {
                ConnectionImpl connection = (ConnectionImpl)iter.next();
                connection.close(false);
                this.removeConnection(pclientId, connection.getId());
            }
        }
        HashMap hashMap = this.clientIdToConnectionsMap;
        synchronized (hashMap) {
            this.clientIdToConnectionsMap.remove(pclientId);
        }
        if (rmiLogger.isLogging(6)) {
            rmiLogger.exiting(params);
        }
    }

    public void createConnection(String pclientId, int connectionId, String userName, String password, int connectionType, ConnectionMetaData clientMetaData, String defaultClientID) throws JMSSecurityException, ResourceAllocationException, JMSException {
        try {
            Object[] params = null;
            if (rmiLogger.isLogging(6)) {
                params = new Object[]{pclientId, new Integer(connectionId), userName, new Integer(connectionType), defaultClientID};
                rmiLogger.entering(params);
            } else if (logger.isLogging(6)) {
                logger.finer("   pclientId: " + pclientId + ",  connectionId: " + connectionId + ",  userName: " + userName + ",  password " + password + ",  connectionType: " + connectionType + ",  clientMetaData: " + clientMetaData);
            }
            SecurityManager.getInstance().validateUser(userName, password);
            ConnectionImpl connection = null;
            switch (connectionType) {
                case 0: {
                    connection = new QueueConnectionImpl(pclientId, connectionId);
                    break;
                }
                case 1: {
                    connection = new TopicConnectionImpl(pclientId, connectionId);
                }
            }
            this.addConnection(pclientId, connectionId, connection);
            connection.setClientID(defaultClientID);
            if (rmiLogger.isLogging(6)) {
                rmiLogger.exiting(params);
            }
        }
        catch (OutOfMemoryError e10) {
            throw new ResourceAllocationException(resource.getString("jmsserviceimpl.out_of_memory_in_createconnection"));
        }
    }

    public void setClientID(String pclientId, int connectionId, String logicalClientId) throws JMSException {
        ConnectionImpl connection;
        Object[] params = null;
        if (rmiLogger.isLogging(6)) {
            params = new Object[]{pclientId, new Integer(connectionId), logicalClientId};
            rmiLogger.entering(params);
        }
        ConnectionImpl connectionImpl = connection = this.getConnection(pclientId, connectionId);
        synchronized (connectionImpl) {
            if (connection.getClientID() != null) {
                throw new IllegalStateException(resource.getString("jmsserviceimpl.clientid_already_set"));
            }
            connection.setClientID(logicalClientId);
        }
        if (rmiLogger.isLogging(6)) {
            rmiLogger.exiting(params);
        }
    }

    public void createSession(String pclientId, int connectionId, int sessionId, boolean transacted, int ackMode) throws ResourceAllocationException, JMSException {
        try {
            Object[] params = null;
            if (rmiLogger.isLogging(6)) {
                params = new Object[]{pclientId, "connectionId=" + connectionId, "sessionId=" + sessionId, "transacted=" + transacted, "ackMode=" + ackMode};
                rmiLogger.entering(params);
            } else if (logger.isLogging(6)) {
                logger.finer("   pclientid: " + pclientId + ",  connectionId: " + connectionId + ",  sessionId: " + sessionId + ",  transacted: " + transacted + ",  ackMode: " + ackMode);
            }
            ConnectionImpl connection = this.getConnection(pclientId, connectionId);
            SessionImpl session = connection.createSession(sessionId, transacted, ackMode);
            if (rmiLogger.isLogging(6)) {
                rmiLogger.exiting(params);
            }
        }
        catch (OutOfMemoryError e10) {
            throw new ResourceAllocationException(resource.getString("jmsserviceimpl.out_of_memory_in_createsession"));
        }
    }

    public void createQueue(String pclientId, int connectionId, String name, boolean isTemporary, boolean overwrite) throws JMSException, ResourceAllocationException {
        try {
            Object[] params = null;
            if (rmiLogger.isLogging(6)) {
                params = new Object[]{pclientId, "connectionId=" + connectionId, "name=" + name, "isTemp=" + isTemporary, "overwrite=" + overwrite};
                rmiLogger.entering(params);
            } else if (logger.isLogging(6)) {
                logger.finer("   pclientid: " + pclientId + ",  connectionId: " + connectionId + ",  name: \"" + name + "\"" + ",  isTemporary: " + isTemporary + ",  overwrite: " + overwrite);
            }
            if (this.destinationExists(name)) {
                if (!overwrite) {
                    throw new InvalidDestinationException(MessageFormat.format(resource.getString("jmsserviceimpl.destination_already_exists"), name), "destinationAlreadyExists");
                }
                this.deleteDestination(pclientId, connectionId, name);
            }
            ConnectionImpl con = this.getConnection(pclientId, connectionId);
            QueueImpl queue = con.createQueue(name, isTemporary);
            this.addDestination(name, queue);
            if (rmiLogger.isLogging(6)) {
                rmiLogger.exiting(params);
            }
        }
        catch (OutOfMemoryError e10) {
            throw new ResourceAllocationException(resource.getString("jmsserviceimpl.out_of_memory_in_createqueue"));
        }
    }

    public void createTopic(String pclientId, int connectionId, String name, boolean isTemporary, boolean overwrite) throws JMSException, ResourceAllocationException {
        try {
            Object[] params = null;
            if (rmiLogger.isLogging(6)) {
                params = new Object[]{pclientId, "connectionId=" + connectionId, "name=" + name, "isTemp=" + isTemporary, "overwrite=" + overwrite};
                rmiLogger.entering(params);
            } else if (logger.isLogging(6)) {
                logger.finer("   pclientid: " + pclientId + ",  connectionId: " + connectionId + ",  name: \"" + name + "\"" + ",  isTemporary: " + isTemporary + ",  overwrite: " + overwrite);
            }
            if (this.destinationExists(name)) {
                if (!overwrite) {
                    throw new InvalidDestinationException(MessageFormat.format(resource.getString("jmsserviceimpl.destination_already_exists"), name), "destinationAlreadyExists");
                }
                this.deleteDestination(pclientId, connectionId, name);
            }
            ConnectionImpl con = this.getConnection(pclientId, connectionId);
            TopicImpl topic = con.createTopic(name, isTemporary);
            this.addDestination(name, topic);
            if (rmiLogger.isLogging(6)) {
                rmiLogger.exiting(params);
            }
        }
        catch (OutOfMemoryError e10) {
            throw new ResourceAllocationException(resource.getString("jmsserviceimpl.out_of_memory_in_createtopic"));
        }
    }

    public void deleteDestination(String pclientId, int connectionId, String name) throws JMSException {
        Object[] params = null;
        try {
            if (rmiLogger.isLogging(6)) {
                params = new Object[]{pclientId, "connectionId=" + connectionId, "name=" + name};
                rmiLogger.entering(params);
            } else if (logger.isLogging(6)) {
                logger.finer("   pclientid: " + pclientId + ",  connectionId: " + connectionId + ",  name: \"" + name + "\"");
            }
            com.sun.jms.service.DestinationImpl dest = this.getDestination(name);
            dest.delete();
            this.removeDestination(name);
            dest = null;
            if (rmiLogger.isLogging(6)) {
                rmiLogger.exiting(params);
            }
        }
        catch (NullPointerException npe) {
            logger.warning(npe);
        }
    }

    public void createMessageProducer(String pclientId, int connectionId, int sessionId, int producerId, String destinationName) throws JMSException, ResourceAllocationException {
        try {
            if (logger.isLogging(6)) {
                logger.finer("   pclientid: " + pclientId + ",  connectionId: " + connectionId + ",  sessionId: " + sessionId + ",  producerId: " + producerId + ",  destinationName: \"" + destinationName + "\"");
            }
            SessionImpl session = this.getSession(pclientId, connectionId, sessionId);
            session.createMessageProducer(producerId, destinationName);
        }
        catch (OutOfMemoryError e10) {
            throw new ResourceAllocationException(resource.getString("jmsserviceimpl.out_of_memory_in_createmessageproducer"));
        }
    }

    public void createMessageConsumer(String pclientId, int connectionId, int sessionId, int consumerId, String destinationName, String messageSelector, String subscriptionName, boolean noLocal) throws JMSException, ResourceAllocationException {
        try {
            Object[] params = null;
            if (rmiLogger.isLogging(6)) {
                params = new Object[]{pclientId, "connectionId=" + connectionId, "sessionId=" + sessionId, "consumerId=" + consumerId, "destination=" + destinationName, "selector=" + messageSelector, "subName=" + subscriptionName, "noLocal=" + noLocal};
                rmiLogger.entering(params);
            } else if (logger.isLogging(6)) {
                logger.finer("pclientid: " + pclientId + ",  connectionId: " + connectionId + ",  sessionId: " + sessionId + ",  consumerId: " + consumerId + ",  destinationName: \"" + destinationName + "\"" + ",  msg selector: \"" + messageSelector + "\" " + ",  subscriptionName: \"" + subscriptionName + "\"" + ",  noLocal:" + noLocal);
            }
            this.validateMessageDestination(destinationName);
            SessionImpl session = this.getSession(pclientId, connectionId, sessionId);
            MessageConsumerImpl consumer = null;
            if (session instanceof QueueSessionImpl) {
                consumer = ((QueueSessionImpl)session).createQueueReceiver(consumerId, destinationName, messageSelector);
            } else if (session instanceof TopicSessionImpl) {
                consumer = ((TopicSessionImpl)session).createTopicSubscriber(consumerId, destinationName, messageSelector, subscriptionName, noLocal);
            }
            if (rmiLogger.isLogging(6)) {
                rmiLogger.exiting(params);
            } else if (logger.isLogging(6)) {
                logger.finer("Done creating consumer.");
            }
        }
        catch (OutOfMemoryError e10) {
            throw new ResourceAllocationException(resource.getString("jmsserviceimpl.out_of_memory_in_createmessageconsumer"));
        }
    }

    public void sendMessage(String pclientId, int connectionId, int sessionId, int messageProducerId, Message msg) throws JMSException {
        Object[] params = null;
        if (rmiLogger.isLogging(6)) {
            params = new Object[]{pclientId, "connectionId=" + connectionId, "sessionId=" + sessionId, "producerId=" + messageProducerId, "msg=" + msg};
            rmiLogger.entering(params);
        } else if (logger.isLogging(6)) {
            logger.finer("pclientid: " + pclientId + ",  connectionId: " + connectionId + ",  sessionId: " + sessionId + ",  messageProducerId: " + messageProducerId + ",  msg: \"" + msg + "\" ");
        }
        ((MessageImpl)msg).setFactoryID(pclientId);
        ((MessageImpl)msg).setConnectionID(connectionId);
        ((MessageImpl)msg).setSessionID(sessionId);
        ((MessageImpl)msg).setProducerID(messageProducerId);
        this.validateMessageDestination((MessageImpl)msg);
        ConnectionImpl connection = this.getConnection(pclientId, connectionId);
        connection.addIncomingMessage((MessageImpl)msg);
        this.msgStatistician.start();
        this.addMessage((MessageImpl)msg);
        if (rmiLogger.isLogging(6)) {
            rmiLogger.exiting(params);
        }
    }

    public MessageImpl receive(String pclientId, int connectionId, int sessionId, int messageConsumerId, long timeout) throws JMSException, RemoteException {
        Object[] params = null;
        if (rmiLogger.isLogging(6)) {
            params = new Object[]{pclientId, "connectionId=" + connectionId, "sessionId=" + sessionId, "consumerId=" + messageConsumerId, "timeout=" + timeout};
            rmiLogger.entering(params);
        } else if (logger.isLogging(6)) {
            logger.finer("pclientid: " + pclientId + ",  connectionId: " + connectionId + ",  sessionId: " + sessionId + ",  messageConsumerId: " + messageConsumerId + ",  timeout: " + timeout);
        }
        SessionImpl session = this.getSession(pclientId, connectionId, sessionId);
        MessageImpl msg = session.receive(messageConsumerId, timeout);
        if (rmiLogger.isLogging(6)) {
            rmiLogger.exiting(params, msg);
        }
        return msg;
    }

    public boolean setHasMessageListener(String pclientId, int connectionId, int sessionId, int messageConsumerId, boolean hasMessageListener) throws JMSException, RemoteException {
        Object[] params = null;
        if (rmiLogger.isLogging(6)) {
            params = new Object[]{pclientId, "connectionId=" + connectionId, "sessionId=" + sessionId, "consumerId=" + messageConsumerId, "hasMsgListener=" + hasMessageListener};
            rmiLogger.entering(params);
        } else if (logger.isLogging(6)) {
            logger.finer("pclientid: " + pclientId + ",  connectionId: " + connectionId + ",  sessionId: " + sessionId + ",  messageConsumerId: " + messageConsumerId + ",  hasMsgListener: " + hasMessageListener);
        }
        QueueReceiverImpl qr = (QueueReceiverImpl)this.getConsumer(pclientId, connectionId, sessionId, messageConsumerId);
        boolean result = qr.setHasMessageListener(hasMessageListener);
        if (rmiLogger.isLogging(6)) {
            rmiLogger.exiting(params, new Boolean(result));
        }
        return result;
    }

    boolean pingClient(String pclientId, JMSClient client, int mode) throws JMSException {
        boolean isAlive = false;
        try {
            if (mode == 2) {
                logger.debugInfo("...pinging client " + pclientId);
            }
            if (client != null) {
                client.ping();
                isAlive = true;
            } else {
                switch (mode) {
                    case 3: {
                        this.deregisterClient(pclientId);
                        break;
                    }
                    case 2: {
                        logger.debugInfo("REMOVE_AWOL_CLIENT: deregistering AWOL client " + pclientId);
                        this.deregisterClient(pclientId);
                        break;
                    }
                    case 1: {
                        logger.debugInfo("detected client with no client implementation" + pclientId);
                        break;
                    }
                }
            }
        }
        catch (RemoteException e10) {
            switch (mode) {
                case 3: {
                    this.deregisterClient(pclientId);
                    break;
                }
                case 1: {
                    logger.debugInfo("detected AWOL client " + pclientId);
                    break;
                }
                case 2: {
                    logger.debugInfo("REMOVE_AWOL_CLIENT: deregistering AWOL client " + pclientId);
                    this.deregisterClient(pclientId);
                }
            }
        }
        return isAlive;
    }

    private void pingAllClients(int mode) throws JMSException {
        String pclientId = null;
        try {
            HashMap idToClientMap = null;
            HashMap hashMap = this.clientIdToJMSClientMap;
            synchronized (hashMap) {
                idToClientMap = (HashMap)this.clientIdToJMSClientMap.clone();
            }
            if (mode == 1) {
                logger.debugInfo("Number of connections: " + idToClientMap.size());
            }
            Iterator iter = idToClientMap.keySet().iterator();
            while (iter.hasNext()) {
                pclientId = (String)iter.next();
                JMSClient client = (JMSClient)idToClientMap.get(pclientId);
                this.pingClient(pclientId, client, mode);
            }
        }
        catch (Throwable t2) {
            logger.severe(t2);
        }
    }

    public void pingAllClients() throws JMSException, RemoteException {
        this.pingAllClients(2);
    }

    public void printDebugInfo() throws JMSException, RemoteException {
        JMSServiceImpl svc = JMSServiceImpl.getInstance();
        logger.debugInfo("\nMap Sizes\nclientIdToConnectionsMap=" + svc.clientIdToConnectionsMap.size() + "\nclientIdToJMSClientMap=" + svc.clientIdToJMSClientMap.size() + "\ndestinationNameToDestinationMap=" + svc.destinationNameToDestinationMap.size() + "\nmessages = " + this.messages.size());
        Waiter.printDebugInfo();
        logger.debugInfo("\nDestination List:");
        Iterator destIter = this.destinationNameToDestinationMap.values().iterator();
        while (destIter.hasNext()) {
            ((com.sun.jms.service.DestinationImpl)destIter.next()).printDebugInfo();
            logger.debugInfo("=========");
        }
        DurableSubscription.printDebugInfo();
        this.pingAllClients(1);
        logger.debugInfo("\nDump of Maps\nclientIdToConnectionsMap=" + svc.clientIdToConnectionsMap + "\nclientIdToJMSClientMap=" + svc.clientIdToJMSClientMap + "\ndestinationNameToDestinationMap=" + svc.destinationNameToDestinationMap + "\nmessages = " + this.messages + "\n\n\n\nDataBase Tables\n===============\n");
        DBManager.printDebugInfo();
        TxnContextManager.printDebugInfo();
    }

    public MessageImpl getMessage(String messageId) throws JMSException {
        Object[] params = null;
        if (rmiLogger.isLogging(6)) {
            params = new Object[]{messageId};
            rmiLogger.entering(params);
        }
        MessageImpl msg = (MessageImpl)this.messages.get(messageId);
        if (rmiLogger.isLogging(6)) {
            rmiLogger.exiting(params, msg);
        }
        return msg;
    }

    public String[] getMessageIds(String qName, String selector) throws JMSException {
        Object[] params = null;
        if (rmiLogger.isLogging(6)) {
            params = new Object[]{"queue=" + qName, "selector=" + selector};
            rmiLogger.entering(params);
        }
        try {
            String[] result = this.getDestination(qName).getMessageIds(selector);
            if (rmiLogger.isLogging(6)) {
                rmiLogger.exiting(params, result);
            }
            return result;
        }
        catch (Exception e10) {
            throw new JMSException(e10.toString());
        }
    }

    public void addMessage(MessageImpl msg) throws JMSException {
        if (msg.hasTopicDestination()) {
            return;
        }
        String messageId = msg.getJMSMessageID();
        MessageImpl oldMsg = (MessageImpl)this.messages.get(messageId);
        if (oldMsg == null) {
            msg.resetRefCount();
            this.messages.put(messageId, msg);
            oldMsg = msg;
        } else {
            oldMsg.incrementRefCount();
        }
        if (logger.isLogging(6)) {
            logger.finer("added \"" + oldMsg + "\",  oldMsg.getRefCount=" + oldMsg.getRefCount());
        }
    }

    public void removeMessage(MessageImpl msg) throws JMSException {
        if (msg.hasTopicDestination()) {
            return;
        }
        this.messages.remove(msg.getJMSMessageID());
    }

    public void acknowledgeMessage(String pclientId, int connectionId, int sessionId, Acknowledgement ack) throws JMSException, RemoteException {
        Object[] params = null;
        try {
            if (rmiLogger.isLogging(6)) {
                params = new Object[]{pclientId, "connectionId=" + connectionId, "sessionId=" + sessionId, "ack=" + ack};
                rmiLogger.entering(params);
            } else if (logger.isLogging(6)) {
                logger.finer("pclientId: " + pclientId + ",  connectionId: " + connectionId + ",  sessionId: " + sessionId + ",  ack:" + ack.toString());
            }
            SessionImpl session = this.getSession(pclientId, connectionId, sessionId);
            if (!session.getTransacted()) {
                session.acknowledgeMessage(ack);
            }
            if (rmiLogger.isLogging(6)) {
                rmiLogger.exiting(params);
            }
        }
        catch (NullPointerException e10) {
            RemoteException re = new RemoteException(resource.getString("jmsserviceimpl.acknowledge_failed_with_nullpointer"), e10);
            throw re;
        }
        catch (SQLException se) {
            JMSException je = new JMSException(MessageFormat.format(resource.getString("jmsserviceimpl.acknowledge_failed_with_sqlexception"), se.getMessage()));
            je.setLinkedException(se);
            RemoteException re = new RemoteException(resource.getString("jmsserviceimpl.acknowledge_failed"), je);
            throw re;
        }
    }

    public void acknowledgeMessages(String pclientId, int connectionId, int sessionId, Acknowledgement[] acks) throws JMSException, RemoteException {
        try {
            Object[] params = null;
            if (rmiLogger.isLogging(6)) {
                params = new Object[]{pclientId, "connectionId=" + connectionId, "sessionId=" + sessionId, "acks=" + acks};
                rmiLogger.entering(params);
            } else if (logger.isLogging(6)) {
                logger.finer("pclientId: " + pclientId + ",  connectionId: " + connectionId + ",  sessionId: " + sessionId + ",  msgCount:" + acks.length);
            }
            SessionImpl session = this.getSession(pclientId, connectionId, sessionId);
            session.acknowledgeMessages(Arrays.asList(acks));
            if (rmiLogger.isLogging(6)) {
                rmiLogger.exiting(params);
            }
        }
        catch (NullPointerException e10) {
            RemoteException re = new RemoteException(resource.getString("jmsserviceimpl.acknowledge_failed_with_nullpointer"), e10);
            throw re;
        }
        catch (SQLException se) {
            JMSException je = new JMSException(MessageFormat.format(resource.getString("jmsserviceimpl.acknowledge_failed_with_sqlexception"), se.getMessage()));
            je.setLinkedException(se);
            RemoteException re = new RemoteException(resource.getString("jmsserviceimpl.acknowledge_failed"), je);
            throw re;
        }
    }

    public void setMessageDelivery(String pclientId, int connectionId, int sessionId, boolean okToDeliverMessages) throws ResourceAllocationException, JMSException {
        Object[] params = null;
        if (rmiLogger.isLogging(6)) {
            params = new Object[]{pclientId, "connectionId=" + connectionId, "sessionId=" + sessionId, "deliverMsgs=" + okToDeliverMessages};
            rmiLogger.entering(params);
        } else if (logger.isLogging(6)) {
            logger.finer("pclientId: " + pclientId + ",  connectionId: " + connectionId + ",  sessionId: " + sessionId + ",  okToDeliverMessages: " + okToDeliverMessages);
        }
        ConnectionImpl connection = this.getConnection(pclientId, connectionId);
        if (sessionId == -1) {
            if (okToDeliverMessages) {
                connection.start();
            } else {
                connection.stop();
            }
        } else {
            SessionImpl session = this.getSession(pclientId, connectionId, sessionId);
            if (okToDeliverMessages) {
                session.start();
            } else {
                session.stop();
            }
        }
        if (rmiLogger.isLogging(6)) {
            rmiLogger.exiting(params);
        }
    }

    public void close(String pclientId, int connectionId, int sessionId, int producerId, int consumerId) throws JMSException {
        Object[] params = null;
        if (rmiLogger.isLogging(6)) {
            params = new Object[]{pclientId, "connectionId=" + connectionId, "sessionId=" + sessionId, "producerId=" + producerId, "consumerId=" + consumerId};
            rmiLogger.entering(params);
        } else if (logger.isLogging(6)) {
            logger.finer("pclientId: " + pclientId + ",  connectionId: " + connectionId + ",  sessionId: " + sessionId + ",  producerId: " + producerId + ",  consumerId: " + consumerId);
        }
        ConnectionImpl connection = this.getConnection(pclientId, connectionId);
        ConnectionConsumerImpl connectionConsumer = connection.getConnectionConsumer(consumerId);
        if (connectionConsumer != null) {
            connectionConsumer.close(true);
        } else if (sessionId == -1) {
            connection.close(true);
            connection = null;
        } else {
            SessionImpl session = this.getSession(pclientId, connectionId, sessionId);
            if (producerId == -1 && consumerId == -1) {
                session.close(true);
                session = null;
            } else {
                if (producerId != -1) {
                    session.closeProducer(producerId);
                }
                if (consumerId != -1) {
                    session.closeConsumer(consumerId);
                }
            }
        }
        if (rmiLogger.isLogging(6)) {
            rmiLogger.exiting(params);
        }
    }

    public void stop() throws JMSException {
        this.stop(false);
    }

    public void stop(boolean exitVM) throws JMSException {
        if (this.isStopped) {
            return;
        }
        if (exitVM) {
            this.isStopped = true;
        }
        if (logger.isLogging(7)) {
            logger.finest(this.msgStatistician.toString());
        }
        logger.warning(resource.getString("jmsserviceimpl.shutting_down_service"));
        DBManager.shutdown();
        if (exitVM) {
            logger.info("Exiting VM....");
            System.exit(0);
        }
    }

    public void recover(String pclientId, int connectionId, int sessionId) throws JMSException {
        Object[] params = null;
        if (rmiLogger.isLogging(6)) {
            params = new Object[]{pclientId, "connectionId=" + connectionId, "sessionId=" + sessionId};
            rmiLogger.entering(params);
        }
        SessionImpl session = this.getSession(pclientId, connectionId, sessionId);
        session.recover();
        if (rmiLogger.isLogging(6)) {
            rmiLogger.exiting(params);
        }
    }

    public void commit(String pclientId, int connectionId, int sessionId, Acknowledgement[] acks) throws JMSException {
        Object[] params = null;
        if (rmiLogger.isLogging(6)) {
            params = new Object[]{pclientId, "connectionId=" + connectionId, "sessionId=" + sessionId, "acks=" + acks};
            rmiLogger.entering(params);
        } else if (logger.isLogging(6)) {
            logger.finer("pclientId: " + pclientId + ",  connectionId: " + connectionId + ",  sessionId: " + sessionId + ",  ackCount:  " + acks.length);
        }
        SessionImpl session = this.getSession(pclientId, connectionId, sessionId);
        session.commit(Arrays.asList(acks));
        if (rmiLogger.isLogging(6)) {
            rmiLogger.exiting(params);
        }
    }

    public void rollback(String pclientId, int connectionId, int sessionId, Acknowledgement[] acks) throws JMSException {
        Object[] params = null;
        if (rmiLogger.isLogging(6)) {
            params = new Object[]{pclientId, "connectionId=" + connectionId, "sessionId=" + sessionId, "acks=" + acks};
            rmiLogger.entering(params);
        } else if (logger.isLogging(6)) {
            logger.finer("pclientId: " + pclientId + ",  connectionId: " + connectionId + ",  sessionId: " + sessionId);
        }
        SessionImpl session = this.getSession(pclientId, connectionId, sessionId);
        session.rollback(Arrays.asList(acks));
        if (rmiLogger.isLogging(6)) {
            rmiLogger.exiting(params);
        }
    }

    public void xaStart(String pclientId, int connectionId, int sessionId, XidImpl xid, int flag) throws JMSException, XAException {
        Object[] params = null;
        if (rmiLogger.isLogging(6)) {
            params = new Object[]{pclientId, "connectionId=" + connectionId, "sessionId=" + sessionId, "xid=" + xid, "flag=" + flag};
            rmiLogger.entering(params);
        }
        this.txnRecoveryCheck("xaStart");
        SessionImpl session = this.getSession(pclientId, connectionId, sessionId);
        this.txnManager.start(xid, flag, session);
        if (rmiLogger.isLogging(6)) {
            rmiLogger.exiting(params);
        }
    }

    public void xaEnd(String pclientId, int connectionId, int sessionId, XidImpl xid, int flag, Acknowledgement[] acks) throws JMSException, XAException {
        Object[] params = null;
        if (rmiLogger.isLogging(6)) {
            params = new Object[]{pclientId, "connectionId=" + connectionId, "sessionId=" + sessionId, "xid=" + xid, "flag=" + flag, "acks=" + acks};
            rmiLogger.entering(params);
        }
        this.txnRecoveryCheck("xaEnd");
        SessionImpl session = this.getSession(pclientId, connectionId, sessionId);
        this.txnManager.end(xid, flag, session, Arrays.asList(acks));
        if (rmiLogger.isLogging(6)) {
            rmiLogger.exiting(params);
        }
    }

    public void xaCommit(XidImpl xid, boolean onePhase) throws JMSException, XAException, RemoteException {
        Object[] params = null;
        if (rmiLogger.isLogging(6)) {
            params = new Object[]{"xid=" + xid, onePhase ? "1PC" : "2PC"};
            rmiLogger.entering(params);
        }
        try {
            this.txnManager.commit(xid, onePhase);
            Object var5_4 = null;
            this.initializationCheck();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.initializationCheck();
            throw throwable;
        }
        if (rmiLogger.isLogging(6)) {
            rmiLogger.exiting(params);
        }
    }

    public int xaPrepare(XidImpl xid) throws JMSException, XAException, RemoteException {
        Object[] params = null;
        if (rmiLogger.isLogging(6)) {
            params = new Object[]{"xid=" + xid};
            rmiLogger.entering(params);
        }
        try {
            int vote = this.txnManager.prepare(xid);
            if (rmiLogger.isLogging(6)) {
                rmiLogger.exiting(params, new Integer(vote));
            }
            int n2 = vote;
            Object var6_5 = null;
            this.initializationCheck();
            return n2;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.initializationCheck();
            throw throwable;
        }
    }

    public void xaRollback(XidImpl xid) throws JMSException, XAException, RemoteException {
        Object[] params = null;
        if (rmiLogger.isLogging(6)) {
            params = new Object[]{"xid=" + xid};
            rmiLogger.entering(params);
        }
        try {
            this.txnManager.rollback(xid);
            Object var4_3 = null;
            this.initializationCheck();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.initializationCheck();
            throw throwable;
        }
        if (rmiLogger.isLogging(6)) {
            rmiLogger.exiting(params);
        }
    }

    public XidImpl[] xaRecover(int flags) throws JMSException, XAException, RemoteException {
        Object[] params = null;
        if (rmiLogger.isLogging(6)) {
            params = new Object[]{"flags=" + flags};
            rmiLogger.entering(params);
        }
        XidImpl[] result = this.txnManager.recover(flags);
        if (rmiLogger.isLogging(6)) {
            rmiLogger.exiting(params, result);
        }
        return result;
    }

    String generateId(String seed) {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e10) {
            // empty catch block
        }
        long now = System.currentTimeMillis();
        String id = seed + "_" + hostName + "_" + now + "_" + ++idCount;
        return id;
    }

    void addClient(String pclientId, JMSClient client) throws JMSException {
        if (logger.isLogging(7)) {
            logger.finest("(pclientId = " + pclientId + " )");
        }
        HashMap hashMap = this.clientIdToJMSClientMap;
        synchronized (hashMap) {
            if (this.clientIdToJMSClientMap.containsKey(pclientId)) {
                throw new JMSException(MessageFormat.format(resource.getString("jmsserviceimpl.client_already_exists"), pclientId));
            }
            this.clientIdToJMSClientMap.put(pclientId, client);
        }
    }

    public JMSClient getJMSClient(String pclientId) throws JMSException {
        HashMap hashMap = this.clientIdToJMSClientMap;
        synchronized (hashMap) {
            JMSClient client = (JMSClient)this.clientIdToJMSClientMap.get(pclientId);
            if (client == null) {
                throw new JMSException(MessageFormat.format(resource.getString("jmsserviceimpl.no_client_found_for_pclientid"), pclientId));
            }
            JMSClient jMSClient = client;
            return jMSClient;
        }
    }

    void removeClient(String pclientId) {
        if (logger.isLogging(7)) {
            logger.finest("pclientId: " + pclientId);
        }
        HashMap hashMap = this.clientIdToJMSClientMap;
        synchronized (hashMap) {
            this.clientIdToJMSClientMap.remove(pclientId);
        }
    }

    void addConnection(String pclientId, int connectionId, ConnectionImpl connection) {
        if (logger.isLogging(6)) {
            logger.finer("pclientId: " + pclientId + ",  connectionId: " + connectionId);
        }
        HashMap hashMap = this.clientIdToConnectionsMap;
        synchronized (hashMap) {
            HashMap<Integer, ConnectionImpl> connectionIdToConnectionMap = (HashMap<Integer, ConnectionImpl>)this.clientIdToConnectionsMap.get(pclientId);
            if (connectionIdToConnectionMap == null) {
                connectionIdToConnectionMap = new HashMap<Integer, ConnectionImpl>();
                this.clientIdToConnectionsMap.put(pclientId, connectionIdToConnectionMap);
            }
            connectionIdToConnectionMap.put(new Integer(connectionId), connection);
        }
    }

    void removeConnection(String pclientId, int connectionId) throws JMSException {
        if (logger.isLogging(6)) {
            logger.finer("pclientId: " + pclientId + ",  connectionId: " + connectionId);
        }
        HashMap hashMap = this.clientIdToConnectionsMap;
        synchronized (hashMap) {
            ConnectionImpl connection = this.getConnection(pclientId, connectionId);
            HashMap connectionIdToConnectionMap = (HashMap)this.clientIdToConnectionsMap.get(pclientId);
            if (connectionIdToConnectionMap != null) {
                connectionIdToConnectionMap.remove(new Integer(connectionId));
            }
        }
    }

    ConnectionImpl getConnection(String pclientId, int connectionId) throws JMSException {
        HashMap hashMap = this.clientIdToConnectionsMap;
        synchronized (hashMap) {
            ConnectionImpl connection = null;
            HashMap connectionIdToConnectionMap = (HashMap)this.clientIdToConnectionsMap.get(pclientId);
            if (connectionIdToConnectionMap != null) {
                connection = (ConnectionImpl)connectionIdToConnectionMap.get(new Integer(connectionId));
            }
            if (connection == null) {
                throw new JMSException(MessageFormat.format(resource.getString("jmsserviceimpl.no_connection_found_for_pclientid"), pclientId, new Integer(connectionId)));
            }
            ConnectionImpl connectionImpl = connection;
            return connectionImpl;
        }
    }

    Collection getConnections(String pclientId) {
        HashMap hashMap = this.clientIdToConnectionsMap;
        synchronized (hashMap) {
            Collection connections = null;
            HashMap connectionIdToConnectionMap = (HashMap)this.clientIdToConnectionsMap.get(pclientId);
            if (connectionIdToConnectionMap != null) {
                connections = connectionIdToConnectionMap.values();
            }
            ArrayList arrayList = connections != null ? new ArrayList(connections) : null;
            return arrayList;
        }
    }

    SessionImpl getSession(String pclientId, int connectionId, int sessionId) throws JMSException {
        ConnectionImpl connection = this.getConnection(pclientId, connectionId);
        SessionImpl session = connection.getSession(sessionId);
        if (session == null) {
            throw new JMSException(MessageFormat.format(resource.getString("jmsserviceimpl.no_session_found_for_pclientid"), pclientId, new Integer(connectionId), new Integer(sessionId)));
        }
        return session;
    }

    ConsumerImpl getConsumer(String pclientId, int connectionId, int sessionId, int msgConsumerId) throws JMSException {
        ConnectionImpl connection = this.getConnection(pclientId, connectionId);
        SessionImpl session = connection.getSession(sessionId);
        if (session == null) {
            throw new JMSException(MessageFormat.format(resource.getString("jmsserviceimpl.no_session_found_for_pclientid"), pclientId, new Integer(connectionId), new Integer(sessionId)));
        }
        ConsumerImpl consumer = session.getConsumer(msgConsumerId);
        if (consumer == null) {
            throw new JMSException(MessageFormat.format(resource.getString("jmsserviceimpl.no_messageconsumer_found_for_pclientid"), pclientId, new Integer(connectionId), new Integer(sessionId), new Integer(msgConsumerId)));
        }
        return consumer;
    }

    void addDestination(String name, com.sun.jms.service.DestinationImpl dest) {
        HashMap hashMap = this.destinationNameToDestinationMap;
        synchronized (hashMap) {
            this.destinationNameToDestinationMap.put(name, dest);
        }
    }

    void removeDestination(String name) {
        HashMap hashMap = this.destinationNameToDestinationMap;
        synchronized (hashMap) {
            this.destinationNameToDestinationMap.remove(name);
        }
    }

    com.sun.jms.service.DestinationImpl getDestination(MessageImpl msg) throws JMSException, InvalidDestinationException {
        if (msg == null) {
            throw new JMSException(resource.getString("jmsserviceimpl.message_was_null"));
        }
        String destName = msg.getDestinationName();
        com.sun.jms.service.DestinationImpl destImpl = this.getDestination(destName);
        return destImpl;
    }

    com.sun.jms.service.DestinationImpl getDestination(String name) throws JMSException {
        com.sun.jms.service.DestinationImpl dest = (com.sun.jms.service.DestinationImpl)this.destinationNameToDestinationMap.get(name);
        if (dest == null) {
            throw new InvalidDestinationException(MessageFormat.format(resource.getString("jmsserviceimpl.no_destination_found_for_name"), name));
        }
        return dest;
    }

    private void validateMessageDestination(MessageImpl msg) throws JMSException, InvalidDestinationException {
        this.getDestination(msg);
    }

    private void validateMessageDestination(String destinationName) throws JMSException, InvalidDestinationException {
        this.getDestination(destinationName);
    }

    public DurableSubscriptionDescriptor getDurableSubscription(String clientID, String subscriptionName) throws JMSException {
        Object[] params = null;
        if (rmiLogger.isLogging(6)) {
            params = new Object[]{"clientID=" + clientID, "subscription=" + subscriptionName};
            rmiLogger.entering(params);
        }
        DurableSubscriptionDescriptor subscription = null;
        ConsumerImpl subscriber = DurableSubscription.getDurableSubscriber(clientID, subscriptionName);
        if (subscriber != null) {
            boolean isActive = subscriber.isActive();
            if (isActive) {
                ConnectionImpl con = subscriber.getConnection();
                isActive = con != null && con.ping();
            }
            subscription = new DurableSubscriptionDescriptor(clientID, subscriptionName, subscriber.getSelectPattern(), subscriber.getDestination().getName(), isActive);
        }
        if (rmiLogger.isLogging(6)) {
            rmiLogger.exiting(params, subscription);
        }
        return subscription;
    }

    public void deleteDurableSubscription(String clientId, String subscriptionName) throws JMSException {
        Object[] params = null;
        if (rmiLogger.isLogging(6)) {
            params = new Object[]{"clientID=" + clientId, "subscription=" + subscriptionName};
            rmiLogger.entering(params);
        } else if (logger.isLogging(6)) {
            logger.finer("clientId: " + clientId + ",  subscriptionName" + subscriptionName);
        }
        ConsumerImpl consumer = DurableSubscription.getDurableSubscriber(clientId, subscriptionName);
        if (consumer != null) {
            consumer.deleteDurableSubscription();
        }
        if (rmiLogger.isLogging(6)) {
            rmiLogger.exiting(params);
        }
    }

    boolean destinationExists(String name) {
        boolean found = false;
        try {
            com.sun.jms.service.DestinationImpl dest = this.getDestination(name);
            found = true;
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return found;
    }

    boolean isPersistentMessage(MessageImpl msg) throws JMSException {
        if (!msg.isPersistent()) {
            return false;
        }
        com.sun.jms.service.DestinationImpl dest = this.getDestination(msg);
        return dest != null && !dest.isTemporary;
    }

    public Object[] getDestinations() {
        HashMap hashMap = this.destinationNameToDestinationMap;
        synchronized (hashMap) {
            HashSet<DestinationImpl> dests = new HashSet<DestinationImpl>();
            if (this.destinationNameToDestinationMap != null) {
                Iterator iter = this.destinationNameToDestinationMap.values().iterator();
                while (iter.hasNext()) {
                    com.sun.jms.service.DestinationImpl dest = (com.sun.jms.service.DestinationImpl)iter.next();
                    dests.add(dest.getDestinationWrapper());
                }
            }
            Object[] objectArray = dests.toArray();
            return objectArray;
        }
    }

    void updateStatistics(MessageImpl msg) {
        try {
            if (!msg.getJMSRedelivered()) {
                long latency = msg.getTimeSinceReceivedByServer();
                this.msgStatistician.addSample(latency);
            }
        }
        catch (JMSException e10) {
            logger.log(1, e10);
        }
    }

    public Statistics getStatistics() {
        Statistics stats = this.msgStatistician.getStatistics();
        return stats;
    }

    public void ping() throws RemoteException {
    }

    public void createConnectionConsumer(String pclientId, int connectionId, int connectionConsumerId, String destinationName, String messageSelector, int maxMessages, String subscriptionName) throws JMSException, RemoteException {
        try {
            Object[] params = null;
            if (rmiLogger.isLogging(6)) {
                params = new Object[]{pclientId, "connectionId=" + connectionId, "consumerId=" + connectionConsumerId, "destination=" + destinationName, "selector=" + messageSelector, "maxMsg=" + maxMessages, "subscription=" + subscriptionName};
                rmiLogger.entering(params);
            }
            ConnectionImpl connection = this.getConnection(pclientId, connectionId);
            connection.createConnectionConsumer(connectionConsumerId, destinationName, messageSelector, maxMessages, subscriptionName);
            if (rmiLogger.isLogging(6)) {
                rmiLogger.exiting(params);
            }
        }
        catch (OutOfMemoryError e10) {
            throw new ResourceAllocationException(resource.getString("jmsserviceimpl.out_of_memory_in_createconnectionconsumer"));
        }
    }

    public String getXaResourceMgrId() throws JMSException, RemoteException {
        return this.xaResourceMgrId;
    }

    private void txnRecoveryCheck(String text) throws XAException {
        if (!this.txnManager.isRecoveryComplete()) {
            logger.severe(MessageFormat.format(resource.getString("jmsserviceimpl.xa_operation_attempted_before_recovery"), text));
            XAException ex2 = new XAException(MessageFormat.format(resource.getString("jmsserviceimpl.xa_operation_attempted_before_recovery"), text));
            ex2.errorCode = -6;
            throw ex2;
        }
    }

    private void initializationCheck() {
        if (!this.initializationComplete && this.txnManager.isRecoveryComplete()) {
            ServiceRecoveryManager.getInstance().recover();
            this.initializationComplete = true;
            System.err.println(resource.getString("jmsserviceimpl.initialization_complete"));
        }
    }
}

