/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.client;

import com.sun.jms.client.MessageProducerImpl;
import com.sun.jms.client.QueueBrowserImpl;
import com.sun.jms.client.QueueConnectionImpl;
import com.sun.jms.client.QueueSenderImpl;
import com.sun.jms.client.SessionImpl;
import com.sun.jms.util.JmsResourceBundle;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;

public class QueueSessionImpl
extends SessionImpl
implements QueueSession {
    QueueConnectionImpl qConnection;
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.client.LocalStrings");

    QueueSessionImpl(boolean isTransacted, int acknowledgeMode, QueueConnectionImpl qConnection) {
        super(isTransacted, acknowledgeMode, qConnection);
        this.qConnection = qConnection;
    }

    public Queue createQueue(String queueName) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("queuesessionimpl.createqueue_on_closed_qs"));
        }
        return (Queue)this.createDestination(0, queueName);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("queuesessionimpl.createreceiver_on_closed_qs"));
        }
        QueueReceiver receiver = this.createReceiver(queue, null);
        return receiver;
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("queuesessionimpl.createreceiver()_on_closed_qs"));
        }
        if (SessionImpl.logger.isLogging(7)) {
            SessionImpl.logger.finest("create for queue " + queue);
        }
        QueueReceiver receiver = (QueueReceiver)this.createConsumer(queue, messageSelector, null, false, this);
        return receiver;
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("queuesessionimpl.createsender_on_closed_qs"));
        }
        if (SessionImpl.logger.isLogging(7)) {
            SessionImpl.logger.finest("create for queue " + queue);
        }
        QueueSender sender = (QueueSender)this.createProducer(queue, this);
        return sender;
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("queuesessionimpl.createbrowser_on_closed_qs"));
        }
        if (SessionImpl.logger.isLogging(7)) {
            SessionImpl.logger.finest("creating browser for queue " + queue);
        }
        QueueBrowser browser = this.createBrowser(queue, null);
        return browser;
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("queuesessionimpl.createbrowser_on_closed_qs"));
        }
        if (SessionImpl.logger.isLogging(7)) {
            SessionImpl.logger.finest("create for queue " + queue);
        }
        if (queue == null) {
            throw new InvalidDestinationException(resource.getString("queuesessionimpl.queue_is_null"));
        }
        QueueBrowserImpl browser = new QueueBrowserImpl(queue, messageSelector, this);
        return browser;
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("queuesessionimpl.createtemporaryqueue_on_closed_qs"));
        }
        TemporaryQueue tempQueue = (TemporaryQueue)this.createTemporaryDestination(0);
        return tempQueue;
    }

    protected MessageProducerImpl createMessageProducer(Destination d10, SessionImpl s2) {
        return new QueueSenderImpl((Queue)d10, (QueueSessionImpl)s2);
    }
}

