/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.client;

import com.sun.jms.JMSService;
import com.sun.jms.MessageImpl;
import com.sun.jms.client.SessionImpl;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Topic;

public class MessageProducerImpl
implements MessageProducer {
    protected JMSService service;
    protected String factoryID;
    boolean disableMessageID = false;
    boolean disableMessageTimestamp = false;
    int deliveryMode = 2;
    int priority = 4;
    long timeToLive = 0L;
    SessionImpl parentSession;
    static int producerNumber = 0;
    int myProducerID;
    boolean createdWithDestination;
    Destination destination;
    boolean isClosed = false;
    static Logger logger = Log.getLogger(2);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.client.LocalStrings");

    MessageProducerImpl(Destination dest, SessionImpl parent) {
        this.destination = dest;
        this.parentSession = parent;
        this.myProducerID = ++producerNumber;
        this.service = this.parentSession.getJMSService();
        this.factoryID = this.parentSession.getFactoryID();
    }

    public void invokeRemoteCreateMessageProducer() throws JMSException {
        try {
            if (logger.isLogging(6)) {
                logger.finer("calling service.createMessageProducer()");
            }
            if (this.destination == null) {
                this.createdWithDestination = false;
                this.service.createMessageProducer(this.factoryID, this.parentSession.getParentConnectionID(), this.parentSession.getSessionID(), this.getProducerID(), null);
            } else if (this.destination instanceof Queue) {
                this.createdWithDestination = true;
                this.service.createMessageProducer(this.factoryID, this.parentSession.getParentConnectionID(), this.parentSession.getSessionID(), this.getProducerID(), ((Queue)this.destination).getQueueName());
            } else if (this.destination instanceof Topic) {
                this.createdWithDestination = true;
                this.service.createMessageProducer(this.factoryID, this.parentSession.getParentConnectionID(), this.parentSession.getSessionID(), this.getProducerID(), ((Topic)this.destination).getTopicName());
            }
        }
        catch (RemoteException e10) {
            if (e10.detail instanceof JMSException) {
                throw (JMSException)e10.detail;
            }
            if (e10.detail instanceof RuntimeException) {
                throw (RuntimeException)e10.detail;
            }
            logger.info(e10);
        }
    }

    public void send(Message message) throws JMSException {
        this.send(message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (!this.createdWithDestination) {
            throw new UnsupportedOperationException(resource.getString("messageproducerimpl.not_created_with_a_destination"));
        }
        this.setMessageProperties(message, this.destination, deliveryMode, priority, timeToLive);
        this.parentSession.sendMessage(this.myProducerID, message);
    }

    public void send(Destination dest, Message message) throws JMSException {
        this.send(dest, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Destination dest, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (this.createdWithDestination) {
            throw new UnsupportedOperationException(resource.getString("messageproducerimpl.producer_was_created_with_a_destination"));
        }
        this.setMessageProperties(message, dest, deliveryMode, priority, timeToLive);
        this.parentSession.sendMessage(this.myProducerID, message);
    }

    private void setMessageProperties(Message message, Destination destination, int deliveryMode, int priority, long timeToLive) throws JMSException {
        message.setJMSDestination(destination);
        message.setJMSDeliveryMode(deliveryMode);
        message.setJMSPriority(priority);
        long currentTime = System.currentTimeMillis();
        if (this.disableMessageTimestamp) {
            message.setJMSTimestamp(0L);
        } else {
            message.setJMSTimestamp(currentTime);
        }
        if (timeToLive == 0L) {
            message.setJMSExpiration(0L);
        } else {
            message.setJMSExpiration(currentTime + timeToLive);
        }
        int JMSSunMessageID = this.parentSession.getNextMessageID();
        String msgID = MessageImpl.makeJMSMessageID(this.factoryID, this.parentSession.getConnection().getConnectionID(), this.parentSession.getSessionID(), JMSSunMessageID);
        message.setJMSMessageID(msgID);
        if (logger.isLogging(7)) {
            logger.finest("myProducerID = " + this.myProducerID + " dest = " + destination + " deliverymode = " + deliveryMode + " priority = " + priority + " timestamp = " + currentTime + " expiration = " + message.getJMSExpiration());
        }
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("messageproducerimpl.setdisablemessageid_on_closed_mp"));
        }
        this.disableMessageID = value;
    }

    public boolean getDisableMessageID() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("messageproducerimpl.getdisablemessageid_on_closed_mp"));
        }
        return this.disableMessageID;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("messageproducerimpl.setdisablemessagetimestamp_on_closed_mp"));
        }
        this.disableMessageTimestamp = value;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("messageproducerimpl.getdisablemessagetimestamp_on_closed_mp"));
        }
        return this.disableMessageTimestamp;
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("messageproducerimpl.setdeliverymode_on_closed_mp"));
        }
        this.deliveryMode = deliveryMode;
    }

    public int getDeliveryMode() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("messageproducerimpl.getdeliverymode_on_closed_mp"));
        }
        return this.deliveryMode;
    }

    public void setPriority(int priority) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("messageproducerimpl.setpriority_on_closed_mp"));
        }
        this.priority = priority;
    }

    public int getPriority() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("messageproducerimpl.getpriority_on_closed_mp"));
        }
        return this.priority;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("messageproducerimpl.settimetolive_on_closed_mp"));
        }
        this.timeToLive = timeToLive;
    }

    public long getTimeToLive() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("messageproducerimpl.gettimetolive_on_closed_mp"));
        }
        return this.timeToLive;
    }

    public void internalClose() throws JMSException {
        MessageProducerImpl messageProducerImpl = this;
        synchronized (messageProducerImpl) {
            this.isClosed = true;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void close() throws JMSException {
        if (this.isClosed()) {
            return;
        }
        this.internalClose();
        MessageProducerImpl messageProducerImpl = this;
        synchronized (messageProducerImpl) {
            block8: {
                try {
                    this.service.close(this.factoryID, this.parentSession.getParentConnectionID(), this.parentSession.getSessionID(), this.myProducerID, -1);
                }
                catch (RemoteException re) {
                    if (logger.isLogging(2)) {
                        logger.warning(MessageFormat.format(resource.getString("messageproducerimpl.ignoring_exception"), re.getMessage()));
                    }
                }
                catch (JMSException je) {
                    if (!logger.isLogging(2)) break block8;
                    logger.warning(MessageFormat.format(resource.getString("messageproducerimpl.ignoring_exception"), je.getMessage()));
                }
            }
            this.parentSession.removeMessageProducer(this.myProducerID);
        }
    }

    public int getProducerID() {
        return this.myProducerID;
    }
}

