/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms;

import com.sun.jms.QueueImpl;
import com.sun.jms.TopicImpl;
import com.sun.jms.util.JmsResourceBundle;
import java.io.Serializable;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;

public class DestinationImpl
implements Destination,
Serializable,
Comparable {
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.LocalStrings");
    private String destName;

    DestinationImpl() {
        this(null);
    }

    DestinationImpl(String name) {
        this.destName = name;
    }

    public static final DestinationImpl createNativeDestination(Destination dest) throws JMSException {
        if (dest != null && !(dest instanceof DestinationImpl)) {
            if (dest instanceof Queue) {
                dest = new QueueImpl(((Queue)dest).getQueueName());
            } else if (dest instanceof Topic) {
                dest = new TopicImpl(((Topic)dest).getTopicName());
            } else {
                throw new JMSException(resource.getString("destinationimpl.unknown_dest_type"));
            }
        }
        return (DestinationImpl)dest;
    }

    public String getName() {
        return this.destName;
    }

    public String toString() {
        return "com.sun.jms.Destination: name = " + this.destName;
    }

    public static String getName(Destination dest) throws JMSException {
        String destName;
        if (dest == null) {
            throw new InvalidDestinationException(resource.getString("destinationimpl.missing_destination"));
        }
        if (dest instanceof Queue) {
            destName = ((Queue)dest).getQueueName();
        } else if (dest instanceof Topic) {
            destName = ((Topic)dest).getTopicName();
        } else {
            throw new InvalidDestinationException(resource.getString("destinationimpl.unknown_dest_type"));
        }
        return destName;
    }

    public int compareTo(Object o2) {
        DestinationImpl d10 = (DestinationImpl)o2;
        return d10.getName().compareTo(this.getName());
    }

    public boolean isQueue() {
        return false;
    }

    public boolean isTopic() {
        return false;
    }
}

