/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class WelcomeFile
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor.getWelcomeFiles().hasMoreElements()) {
            boolean oneFailed = false;
            boolean foundIt = false;
            Enumeration e10 = descriptor.getWelcomeFiles();
            while (e10.hasMoreElements()) {
                String welcomefile;
                block10: {
                    foundIt = false;
                    welcomefile = (String)e10.nextElement();
                    if (welcomefile.startsWith("/") || welcomefile.endsWith("/")) {
                        result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed1", "Error : Servlet 2.3 Spec 9.9 Welcome file URL [ {0} ] must be partial URLs with no trailing or leading /", new Object[]{welcomefile, descriptor.getName()}));
                    }
                    try {
                        JarFile jar = new JarFile(Verifier.getArchiveFile(((WebBundleArchivist)descriptor.getArchivist()).getWebJarFile().getName()));
                        ZipEntry ze = jar.getEntry(welcomefile);
                        foundIt = ze != null;
                        jar.close();
                    }
                    catch (Exception ex2) {
                        if (oneFailed) break block10;
                        oneFailed = true;
                    }
                }
                if (foundIt) {
                    result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "Welcome file [ {0} ] contains the file name to use as a default welcome file within web application [ {1} ]", new Object[]{welcomefile, descriptor.getName()}));
                    continue;
                }
                if (!oneFailed) {
                    oneFailed = true;
                }
                result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: Welcome file [ {0} ] is not found within [ {1} ] or does not contain the file name to use as a default welcome file within web application [ {2} ]", new Object[]{welcomefile, Verifier.getArchiveFile(((WebBundleArchivist)descriptor.getArchivist()).getWebJarFile().getName()), descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no welcome files within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

