/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebResourceCollectionImpl;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.Enumeration;

public class WebResourceHTTPMethod
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor.getSecurityConstraints().hasMoreElements()) {
            boolean oneFailed = false;
            boolean foundIt = false;
            int na = 0;
            int noSc = 0;
            int naWRC = 0;
            int noWRC = 0;
            Enumeration e10 = descriptor.getSecurityConstraints();
            while (e10.hasMoreElements()) {
                foundIt = false;
                ++noSc;
                SecurityConstraintImpl securityConstraintImpl = (SecurityConstraintImpl)e10.nextElement();
                if (securityConstraintImpl.getWebResourceCollections().hasMoreElements()) {
                    Enumeration ee2 = securityConstraintImpl.getWebResourceCollections();
                    while (ee2.hasMoreElements()) {
                        ++noWRC;
                        WebResourceCollectionImpl webResourceCollection = (WebResourceCollectionImpl)ee2.nextElement();
                        if (webResourceCollection.getHttpMethods().hasMoreElements()) {
                            Enumeration eee = webResourceCollection.getHttpMethods();
                            while (eee.hasMoreElements()) {
                                String webRCHTTPMethod = (String)eee.nextElement();
                                foundIt = webRCHTTPMethod.equals("OPTIONS") || webRCHTTPMethod.equals("GET") || webRCHTTPMethod.equals("HEAD") || webRCHTTPMethod.equals("POST") || webRCHTTPMethod.equals("PUT") || webRCHTTPMethod.equals("DELETE") || webRCHTTPMethod.equals("TRACE") || webRCHTTPMethod.equals("CONNECT");
                                if (foundIt) {
                                    result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "http-method [ {0} ] is valid HTTP method name within web resource collection [ {1} ] in web application [ {2} ]", new Object[]{webRCHTTPMethod, webResourceCollection.getName(), descriptor.getName()}));
                                    continue;
                                }
                                if (!oneFailed) {
                                    oneFailed = true;
                                }
                                result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: http-method [ {0} ] is not valid HTTP method name within web resource collection [ {1} ] in web application [ {2} ]", new Object[]{webRCHTTPMethod, webResourceCollection.getName(), descriptor.getName()}));
                            }
                            continue;
                        }
                        result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable1", "There are no web http-methods in the web resource collection [ {0} ] within [ {1} ]", new Object[]{webResourceCollection.getName(), descriptor.getName()}));
                        ++naWRC;
                    }
                    continue;
                }
                result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable2", "There are no web web resource collections in the web security constraint within [ {0} ]", new Object[]{descriptor.getName()}));
                ++na;
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (na == noSc || naWRC == noWRC) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no http-method elements within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

