/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebResourceCollectionImpl;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.Enumeration;

public class URLPattern
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor.getSecurityConstraints().hasMoreElements()) {
            boolean oneFailed = false;
            int na = 0;
            int noSc = 0;
            int naWRC = 0;
            int noWRC = 0;
            Enumeration e10 = descriptor.getSecurityConstraints();
            while (e10.hasMoreElements()) {
                ++noSc;
                SecurityConstraintImpl securityConstraintImpl = (SecurityConstraintImpl)e10.nextElement();
                if (securityConstraintImpl.getWebResourceCollections().hasMoreElements()) {
                    Enumeration ee2 = securityConstraintImpl.getWebResourceCollections();
                    while (ee2.hasMoreElements()) {
                        ++noWRC;
                        WebResourceCollectionImpl webResourceCollection = (WebResourceCollectionImpl)ee2.nextElement();
                        if (webResourceCollection.getUrlPatterns().hasMoreElements()) {
                            Enumeration eee = webResourceCollection.getUrlPatterns();
                            while (eee.hasMoreElements()) {
                                String nextUrlPattern = (String)eee.nextElement();
                                if (nextUrlPattern != null) {
                                    if (nextUrlPattern.startsWith("/") || nextUrlPattern.startsWith("/") && nextUrlPattern.endsWith("/*") || nextUrlPattern.startsWith("*.")) {
                                        result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "Content of the url-pattern element [ {0} ] follows the rules specified in section 10 of the servlet specification within [ {1} ]", new Object[]{nextUrlPattern, descriptor.getName()}));
                                        continue;
                                    }
                                    if (!oneFailed) {
                                        oneFailed = true;
                                    }
                                    result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: Content of the url-pattern element [ {0} ] does not follow the rules specified in section 10 of the servlet specification within [ {1} ]", new Object[]{nextUrlPattern, descriptor.getName()}));
                                    continue;
                                }
                                if (!oneFailed) {
                                    oneFailed = true;
                                }
                                result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed1", "Error: Content of the url-pattern element is null and does not follow the rules specified in section 10 of the servlet specification within [ {0} ]", new Object[]{descriptor.getName()}));
                            }
                            continue;
                        }
                        result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable1", "There are no web url-patterns in the web resource collection [ {0} ] within [ {1} ]", new Object[]{webResourceCollection.getName(), descriptor.getName()}));
                        ++naWRC;
                    }
                    continue;
                }
                result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable2", "There are no web web resource collections in the web security constraint within [ {0} ]", new Object[]{descriptor.getName()}));
                ++na;
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (na == noSc || naWRC == noWRC) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no web components within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

