/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.ServletDescriptorImpl;
import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import com.sun.enterprise.util.FileClassLoader;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;

public class ServletClass
extends WebTest
implements WebCheck {
    final String servletClassPath = "WEB-INF/classes";

    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (!descriptor.getServletDescriptors().isEmpty()) {
            boolean oneFailed = false;
            boolean foundIt = false;
            Set servlets = descriptor.getServletDescriptors();
            Iterator itr = servlets.iterator();
            while (itr.hasNext()) {
                foundIt = false;
                ServletDescriptorImpl servlet = (ServletDescriptorImpl)itr.next();
                String servletClassName = servlet.getClassName();
                try {
                    File warfile = new File(System.getProperty("java.io.tmpdir"));
                    warfile = new File(warfile, "wartmp");
                    Archivist.extractJarFile(Verifier.getArchiveFile(((WebBundleArchivist)descriptor.getArchivist()).getWebJarFile().getName()), warfile);
                    File warclasses = new File(warfile, "WEB-INF/classes");
                    FileClassLoader cl2 = new FileClassLoader(warclasses.getAbsolutePath());
                    Verifier.debug("servlet classpath: " + warclasses.getAbsolutePath());
                    Class<?> c10 = cl2.loadClass(servletClassName);
                    foundIt = true;
                }
                catch (ClassNotFoundException e10) {
                    if (!oneFailed) {
                        oneFailed = true;
                    }
                    result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".ClassNotFoundException", "Error: [ {0} ] class not found.", new Object[]{servletClassName}));
                }
                catch (IOException e11) {
                    if (!oneFailed) {
                        oneFailed = true;
                    }
                    Verifier.debug(e11);
                    result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".IOException", "Error: IOError trying to open [ {0} ], {1}", new Object[]{Verifier.getArchiveFile(((WebBundleArchivist)descriptor.getArchivist()).getWebJarFile().getName()), e11.getMessage()}));
                }
                if (foundIt) {
                    result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "Servlet class [ {0} ] resides in the WEB-INF/classes directory.", new Object[]{servletClassName}));
                    continue;
                }
                if (!oneFailed) {
                    oneFailed = true;
                }
                result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: Servlet class [ {0} ] does not reside in the WEB-INF/classes directory.", new Object[]{servletClassName}));
            }
            File wartmp = new File(System.getProperty("java.io.tmpdir"));
            wartmp = new File(wartmp, "wartmp");
            wartmp.delete();
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no servlet components within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

