/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session.stateless;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.util.JarClassLoader;
import java.lang.reflect.Method;

public class StatelessCreateReturn
extends EjbTest
implements EjbCheck {
    Result result = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        if (descriptor instanceof EjbSessionDescriptor) {
            String stateType = ((EjbSessionDescriptor)descriptor).getSessionTypeString();
            if (EjbSessionDescriptor.STATELESS.equals(stateType)) {
                if (descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName()) && descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName())) {
                    this.commonToBothInterfaces(descriptor.getHomeClassName(), descriptor.getRemoteClassName(), (EjbSessionDescriptor)descriptor);
                }
                if (descriptor.getLocalHomeClassName() != null && !"".equals(descriptor.getLocalHomeClassName()) && descriptor.getLocalClassName() != null && !"".equals(descriptor.getLocalClassName())) {
                    this.commonToBothInterfaces(descriptor.getLocalHomeClassName(), descriptor.getLocalClassName(), (EjbSessionDescriptor)descriptor);
                }
                return this.result;
            }
            if (EjbSessionDescriptor.STATEFUL.equals(stateType)) {
                this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable1", "[ {0} ] expected {1} Session bean, but called with {2} Session bean.", new Object[]{this.getClass(), EjbSessionDescriptor.STATELESS, stateType}));
                return this.result;
            }
            this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed2", "Error: [ {0} ] is not valid stateType within bean [ {1} ].", new Object[]{stateType, descriptor.getName()}));
            return this.result;
        }
        this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Session", "Entity"}));
        return this.result;
    }

    private void commonToBothInterfaces(String home, String component, EjbSessionDescriptor descriptor) {
        try {
            Context context = this.getVerifierContext();
            JarClassLoader jcl = context.getClassLoader();
            Class<?> c10 = jcl.loadClass(home);
            Class<?> rc = jcl.loadClass(component);
            Method[] methods = c10.getDeclaredMethods();
            Method m2 = null;
            int i2 = 0;
            while (i2 < methods.length) {
                if (methods[i2].getName().equals("create")) {
                    m2 = methods[i2];
                    break;
                }
                ++i2;
            }
            if (m2 != null) {
                Class<?> rt = m2.getReturnType();
                if (!rc.getName().equals(rt.getName())) {
                    this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: The create methods return type [ {0} ] is not \n equal to remote interface [ {1} ]", new Object[]{rt.getName(), rc.getName()}));
                } else {
                    this.result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "Valid: The create methods return type [ {0} ] is \n equal to remote interface [ {1} ]", new Object[]{rt.getName(), rc.getName()}));
                }
            } else {
                this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed1", "Error: No Create method exists within bean [ {0} ]", new Object[]{home}));
            }
        }
        catch (ClassNotFoundException e10) {
            Verifier.debug(e10);
            this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Class [ {0} ] not found within bean [ {1} ]", new Object[]{home, descriptor.getName()}));
        }
    }
}

