/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session;

import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.util.JarClassLoader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class TransientFieldsSerialization
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor instanceof EjbSessionDescriptor) {
            try {
                Context context = this.getVerifierContext();
                JarClassLoader jcl = context.getClassLoader();
                Class<?> c10 = jcl.loadClass(((EjbSessionDescriptor)descriptor).getEjbClassName());
                boolean oneFailed = false;
                boolean badField = false;
                Field[] fields = c10.getDeclaredFields();
                int i2 = 0;
                while (i2 < fields.length) {
                    badField = false;
                    int modifiers = fields[i2].getModifiers();
                    if (Modifier.isTransient(modifiers)) {
                        Class<?> fc2 = fields[i2].getType();
                        if (fc2.getName().equals("javax.ejb.SessionContext") || fc2.getName().equals("javax.transaction.UserTransaction") || fc2.getName().equals(descriptor.getRemoteClassName()) || fc2.getName().equals(descriptor.getHomeClassName()) || fc2.getName().equals(descriptor.getLocalClassName()) || fc2.getName().equals(descriptor.getLocalHomeClassName())) {
                            if (!oneFailed) {
                                oneFailed = true;
                            }
                            badField = true;
                        }
                        if (badField) {
                            result.warning(VerifierTest.smh.getLocalString(this.getClass().getName() + ".warning", "Warning: Field [ {0} ] defined within session bean class [ {1} ] is defined as transient.  Session bean fields should not store in a transient field a reference to any of the following objects: SessionContext object; environment JNDI naming context and any its subcontexts; home and remote interfaces; and the UserTransaction interface.", new Object[]{fields[i2].getName(), ((EjbSessionDescriptor)descriptor).getEjbClassName()}));
                        }
                    }
                    ++i2;
                }
                if (!oneFailed) {
                    result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "This session bean class [ {0} ] has not stored in a transient field a reference to any of the following objects: SessionContext object; environment JNDI naming context and any its subcontexts; home and remote interfaces; and the UserTransaction interface.", new Object[]{((EjbSessionDescriptor)descriptor).getEjbClassName()}));
                }
            }
            catch (ClassNotFoundException e10) {
                Verifier.debug(e10);
                result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: [ {0} ] class not found.", new Object[]{((EjbSessionDescriptor)descriptor).getEjbClassName()}));
            }
            catch (Throwable t2) {
                result.warning(VerifierTest.smh.getLocalString(this.getClass().getName() + ".warningException", "Warning: [ {0} ] class encountered [ {1} ]. Cannot access fields of class [ {2} ] which is external to [ {3} ].", new Object[]{descriptor.getEjbClassName(), t2.toString(), t2.getMessage(), Verifier.getJarFile(((EjbBundleArchivist)descriptor.getEjbBundleDescriptor().getArchivist()).getEjbJarFile().getName()).getName()}));
            }
            return result;
        }
        result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "{0} expected {1} bean, but called with {2}.", new Object[]{this.getClass(), "Session", "Entity"}));
        return result;
    }
}

