/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.intf.remoteintf;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import com.sun.enterprise.util.JarClassLoader;

public class RemoteInterfaceSuperInterface
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (!(descriptor instanceof EjbSessionDescriptor) && !(descriptor instanceof EjbEntityDescriptor)) {
            result.notApplicable(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.homeintf.HomeMethodTest.notApplicable1", "Test apply only to session or entity beans."));
            return result;
        }
        if (descriptor.getRemoteClassName() == null || "".equals(descriptor.getRemoteClassName())) {
            return result;
        }
        boolean oneFailed = false;
        try {
            Context context = this.getVerifierContext();
            JarClassLoader jcl = context.getClassLoader();
            Class<?> c10 = jcl.loadClass(descriptor.getRemoteClassName());
            boolean validRemoteInterface = false;
            block2: do {
                Class<?>[] interfaces = c10.getInterfaces();
                int i2 = 0;
                while (i2 < interfaces.length) {
                    if (this.debug) {
                        System.out.println(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "Interface [ {0} ]", new Object[]{interfaces[i2].getName()}));
                    }
                    if (RmiIIOPUtils.isValidRmiIIOPInterface(interfaces[i2])) {
                        if (interfaces[i2].getName().equals("javax.ejb.EJBObject")) {
                            validRemoteInterface = true;
                            continue block2;
                        }
                    } else {
                        oneFailed = true;
                        result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] does not properly conform to rules of RMI-IIOP for superinterfaces.  All enterprise beans remote interfaces are allowed to have superinterfaces that conform to the rules of RMI-IIOP for superinterfaces .  [ {1} ] is not a valid remote interface.", new Object[]{interfaces[i2].getName(), descriptor.getRemoteClassName()}));
                    }
                    ++i2;
                }
            } while ((c10 = c10.getSuperclass()) != null && !validRemoteInterface);
            if (validRemoteInterface) {
                result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] properly conforms to rules of RMI-IIOP for superinterfaces.", new Object[]{descriptor.getRemoteClassName()}));
            }
        }
        catch (ClassNotFoundException e10) {
            Verifier.debug(e10);
            result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Remote interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{descriptor.getRemoteClassName(), descriptor.getName()}));
            oneFailed = true;
        }
        if (oneFailed) {
            result.setStatus(1);
        } else {
            result.setStatus(0);
        }
        return result;
    }
}

