/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.ejbfindbyprimarykey;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.util.JarClassLoader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class EjbFindByPrimaryKeyFinal
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor instanceof EjbEntityDescriptor) {
            String persistentType = ((EjbEntityDescriptor)descriptor).getPersistenceType();
            if (EjbEntityDescriptor.BEAN_PERSISTENCE.equals(persistentType)) {
                boolean ejbFindByPrimaryKeyMethodFound = false;
                boolean isFinal = false;
                boolean oneFailed = false;
                int findMethodModifiers = 0;
                try {
                    Context context = this.getVerifierContext();
                    JarClassLoader jcl = context.getClassLoader();
                    Class<?> EJBClass = jcl.loadClass(descriptor.getEjbClassName());
                    block2: do {
                        Method[] ejbFinderMethods = EJBClass.getDeclaredMethods();
                        int j2 = 0;
                        while (j2 < ejbFinderMethods.length) {
                            if (ejbFinderMethods[j2].getName().equals("ejbFindByPrimaryKey")) {
                                ejbFindByPrimaryKeyMethodFound = true;
                                findMethodModifiers = ejbFinderMethods[j2].getModifiers();
                                if (Modifier.isFinal(findMethodModifiers)) {
                                    isFinal = true;
                                }
                                if (ejbFindByPrimaryKeyMethodFound && !isFinal) {
                                    result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] Finder method [ {1} ]", new Object[]{EJBClass.getName(), ejbFinderMethods[j2].getName()}));
                                    result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "A non-final [ {0} ] method was found.", new Object[]{ejbFinderMethods[j2].getName()}));
                                    result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                                    continue block2;
                                }
                                if (!ejbFindByPrimaryKeyMethodFound || !isFinal) continue block2;
                                oneFailed = true;
                                result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] Finder method [ {1} ]", new Object[]{EJBClass.getName(), ejbFinderMethods[j2].getName()}));
                                result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: A final [ {0} ] method was found, but [ {1} ] cannot be declared as final.", new Object[]{ejbFinderMethods[j2].getName(), ejbFinderMethods[j2].getName()}));
                                result.addErrorDetails("==============================");
                                continue block2;
                            }
                            ++j2;
                        }
                    } while ((EJBClass = EJBClass.getSuperclass()) != null && !ejbFindByPrimaryKeyMethodFound);
                    if (!ejbFindByPrimaryKeyMethodFound) {
                        oneFailed = true;
                        result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug3", "For EJB Class [ {0} ]", new Object[]{descriptor.getEjbClassName()}));
                        result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed1", "Error: No ejbFindByPrimaryKey method was found in bean class."));
                        result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                    }
                }
                catch (ClassNotFoundException e10) {
                    Verifier.debug(e10);
                    result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: EJB Class [ {0} ] does not exist or is not loadable.", new Object[]{descriptor.getEjbClassName()}));
                    oneFailed = true;
                }
                if (oneFailed) {
                    result.setStatus(1);
                } else {
                    result.setStatus(0);
                }
            } else {
                result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Expected persistence type [ {0} ], but bean [ {1} ] has persistence type [ {2} ]", new Object[]{EjbEntityDescriptor.BEAN_PERSISTENCE, descriptor.getName(), persistentType}));
            }
            return result;
        }
        result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }
}

