/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.util.JarClassLoader;

public class EjbClassImplementsComponentInterface
extends EjbTest
implements EjbCheck {
    Result result = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        if (descriptor instanceof EjbEntityDescriptor) {
            if (descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName())) {
                this.commonToBothInterfaces(descriptor.getRemoteClassName(), (EjbEntityDescriptor)descriptor);
            }
            if (descriptor.getLocalClassName() != null && !"".equals(descriptor.getLocalClassName())) {
                this.commonToBothInterfaces(descriptor.getLocalClassName(), (EjbEntityDescriptor)descriptor);
            }
            return this.result;
        }
        this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return this.result;
    }

    private void commonToBothInterfaces(String component, EjbDescriptor descriptor) {
        try {
            Context context = this.getVerifierContext();
            JarClassLoader jcl = context.getClassLoader();
            Class<?> c10 = jcl.loadClass(descriptor.getEjbClassName());
            Class<?> rc = jcl.loadClass(component);
            boolean foundOne = false;
            block2: do {
                Class<?>[] interfaces = c10.getInterfaces();
                int i2 = 0;
                while (i2 < interfaces.length) {
                    if (this.debug) {
                        System.out.println(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "Interface [ {0} ]", new Object[]{interfaces[i2].getName()}));
                    }
                    if (interfaces[i2].getName().equals(rc.getName()) && descriptor instanceof EjbEntityDescriptor) {
                        this.result.warning(VerifierTest.smh.getLocalString(this.getClass().getName() + ".warning", "Warning: [ {0} ] class implments the enterprise Bean's remote interface [ {1} ].  It is recommended that the enterprise bean class not implement the remote interface to prevent inadvertent passing of this as a method argument or result.  The class must provide no-op implementations of the methods defined in the javax.ejb.EJBObject interface.", new Object[]{descriptor.getEjbClassName(), rc.getName()}));
                        foundOne = true;
                        continue block2;
                    }
                    ++i2;
                }
            } while ((c10 = c10.getSuperclass()) != null);
            if (!foundOne) {
                this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable2", "[ {0} ] does not optionally implement bean class remote interface  [ {1} ]", new Object[]{descriptor.getEjbClassName(), rc.getName()}));
            }
        }
        catch (ClassNotFoundException e10) {
            Verifier.debug(e10);
            this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: [ {0} ] class not found.", new Object[]{descriptor.getEjbClassName()}));
        }
    }
}

