/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.beanclass;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.util.JarClassLoader;
import java.lang.reflect.Method;

public class EjbClassExposed
extends EjbTest {
    Result result = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        boolean oneFailed = false;
        if (!(descriptor instanceof EjbSessionDescriptor) && !(descriptor instanceof EjbEntityDescriptor)) {
            this.result.notApplicable(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.homeintf.HomeMethodTest.notApplicable1", "Test apply only to session or entity beans."));
            return this.result;
        }
        if (descriptor.getRemoteClassName() != null && !descriptor.getRemoteClassName().equals("")) {
            oneFailed = this.commonToBothInterfaces(descriptor.getRemoteClassName(), descriptor);
        }
        if (!oneFailed && descriptor.getLocalClassName() != null && !descriptor.getLocalClassName().equals("")) {
            oneFailed = this.commonToBothInterfaces(descriptor.getLocalClassName(), descriptor);
        }
        if (oneFailed) {
            this.result.setStatus(1);
        } else {
            this.result.setStatus(0);
        }
        return this.result;
    }

    private boolean commonToBothInterfaces(String remote, EjbDescriptor descriptor) {
        Context context = this.getVerifierContext();
        JarClassLoader jcl = context.getClassLoader();
        try {
            Class<?> c10 = jcl.loadClass(remote);
            Method[] methods = c10.getDeclaredMethods();
            int i2 = 0;
            while (i2 < methods.length) {
                if (methods[i2].getReturnType().getName().equals(descriptor.getEjbClassName())) {
                    this.result.failed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.beanclass.EjbClassExposed.failed", "Error: Ejb Bean Class [{0}] is exposed through interface [{1}]", new Object[]{descriptor.getEjbClassName(), remote}));
                    return true;
                }
                ++i2;
            }
            this.result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "Ejb Bean Class [{0}] is not exposed through interface [{1}]", new Object[]{descriptor.getEjbClassName(), remote}));
            return false;
        }
        catch (ClassNotFoundException e10) {
            this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: interface class [{0}] not found", new Object[]{remote}));
            return true;
        }
    }
}

