/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.appclient.elements;

import com.sun.enterprise.deployment.ApplicationClientArchivist;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.EjbAbstractDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbExternalDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.appclient.AppClientCheck;
import com.sun.enterprise.tools.verifier.tests.appclient.AppClientTest;
import com.sun.enterprise.util.JarClassLoader;
import java.util.Iterator;
import java.util.Set;

public class AppClientEjbReferencesElement
extends AppClientTest
implements AppClientCheck {
    public Result check(ApplicationClientDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor instanceof ApplicationClientDescriptor) {
            Set references = descriptor.getEjbReferenceDescriptors();
            Iterator iterator = references.iterator();
            if (iterator.hasNext()) {
                boolean oneFailed = false;
                boolean foundBeanClassName = false;
                boolean foundHomeClassName = false;
                boolean foundRemoteClassName = false;
                while (iterator.hasNext()) {
                    EjbReferenceDescriptor ejbReference = (EjbReferenceDescriptor)iterator.next();
                    EjbAbstractDescriptor ejbDescriptor = ejbReference.getEjbDescriptor();
                    if (ejbDescriptor instanceof EjbDescriptor) {
                        foundBeanClassName = false;
                        foundHomeClassName = false;
                        foundRemoteClassName = false;
                        try {
                            Context context = this.getVerifierContext();
                            JarClassLoader jcl = context.getClassLoader();
                            Class<?> c10 = jcl.loadClass(((EjbDescriptor)ejbDescriptor).getEjbClassName());
                            foundBeanClassName = true;
                            result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed1", "The referenced bean [ {0} ] exists and is loadable within [ {1} ].", new Object[]{((EjbDescriptor)ejbDescriptor).getEjbClassName(), Verifier.getAppClientJarFile(((ApplicationClientArchivist)descriptor.getArchivist()).getApplicationClientJarFile().getName()).getName()}));
                            c10 = jcl.loadClass(ejbDescriptor.getHomeClassName());
                            foundHomeClassName = true;
                            result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed2", "The referenced bean's home interface [ {0} ] exists and is loadable within [ {1} ].", new Object[]{((EjbDescriptor)ejbDescriptor).getHomeClassName(), Verifier.getAppClientJarFile(((ApplicationClientArchivist)descriptor.getArchivist()).getApplicationClientJarFile().getName()).getName()}));
                            c10 = jcl.loadClass(ejbDescriptor.getRemoteClassName());
                            foundRemoteClassName = true;
                            result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed3", "The referenced bean's remote interface [ {0} ] exists and is loadable within [ {1} ].", new Object[]{((EjbDescriptor)ejbDescriptor).getRemoteClassName(), Verifier.getAppClientJarFile(((ApplicationClientArchivist)descriptor.getArchivist()).getApplicationClientJarFile().getName()).getName()}));
                        }
                        catch (ClassNotFoundException e10) {
                            Verifier.debug(e10);
                            if (!oneFailed) {
                                oneFailed = true;
                            }
                            String classStr = "";
                            if (!foundBeanClassName) {
                                classStr = ((EjbDescriptor)ejbDescriptor).getEjbClassName();
                            } else if (!foundHomeClassName) {
                                classStr = ((EjbDescriptor)ejbDescriptor).getHomeClassName();
                            } else if (!foundRemoteClassName) {
                                classStr = ((EjbDescriptor)ejbDescriptor).getRemoteClassName();
                            }
                            result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] class [ {1} ] cannot be found within this jar [ {2} ].", new Object[]{ejbReference.getName(), classStr, Verifier.getAppClientJarFile(((ApplicationClientArchivist)descriptor.getArchivist()).getApplicationClientJarFile().getName()).getName()}));
                        }
                        continue;
                    }
                    if (!(ejbDescriptor instanceof EjbExternalDescriptor)) continue;
                    result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Not Applicable: [ {0} ] must be external reference to bean outside of [ {1} ].", new Object[]{ejbReference.getName(), Verifier.getAppClientJarFile(((ApplicationClientArchivist)descriptor.getArchivist()).getApplicationClientJarFile().getName()).getName()}));
                }
                if (oneFailed) {
                    result.setStatus(1);
                } else {
                    result.setStatus(0);
                }
            } else {
                result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable1", "There are no ejb references to other beans within this application client [ {0} ]", new Object[]{descriptor.getName()}));
            }
            return result;
        }
        result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] not called with a application client.", new Object[]{this.getClass()}));
        return result;
    }
}

