/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.appclient;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.appclient.AppClientCheck;
import com.sun.enterprise.tools.verifier.tests.appclient.AppClientTest;
import java.util.Iterator;

public class AppClientEjbRefNamePrefixed
extends AppClientTest
implements AppClientCheck {
    public Result check(ApplicationClientDescriptor descriptor) {
        Result result = this.getInitializedResult();
        boolean oneWarning = false;
        if (!descriptor.getEjbReferenceDescriptors().isEmpty()) {
            Iterator itr = descriptor.getEjbReferenceDescriptors().iterator();
            while (itr.hasNext()) {
                EjbReferenceDescriptor nextEjbReference = (EjbReferenceDescriptor)itr.next();
                String ejbRefName = nextEjbReference.getName();
                if (ejbRefName.startsWith("ejb/")) {
                    result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] is prefixed with recommended string \"ejb/\" within application client [ {1} ]", new Object[]{ejbRefName, descriptor.getName()}));
                    continue;
                }
                if (!oneWarning) {
                    oneWarning = true;
                }
                result.addWarningDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".warning", "Warning: [ {0} ] is not prefixed with recommended string \"ejb/\" within application client [ {1} ]", new Object[]{ejbRefName, descriptor.getName()}));
            }
            if (oneWarning) {
                result.setStatus(2);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no ejb references to other beans within this application client [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

