/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.app;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.app.AppCheck;
import com.sun.enterprise.tools.verifier.tests.app.ApplicationTest;
import java.util.Iterator;

public class EjbURI
extends ApplicationTest
implements AppCheck {
    public Result check(Application descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor.getEjbBundleDescriptors().size() > 0) {
            boolean oneFailed = false;
            Iterator itr = descriptor.getEjbBundleDescriptors().iterator();
            while (itr.hasNext()) {
                EjbBundleDescriptor ejbd = (EjbBundleDescriptor)itr.next();
                if (ejbd.getArchivist().getArchiveUri().endsWith(".jar")) {
                    result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] specifies the URI [ {1} ] of an ejb-jar, relative to the top level of the application package [ {2} ].", new Object[]{ejbd.getName(), ejbd.getArchivist().getArchiveUri(), descriptor.getName()}));
                    continue;
                }
                if (!oneFailed) {
                    oneFailed = true;
                }
                result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] does not specify the URI [ {1} ] of an ejb-jar, relative to the top level of the application package [ {2} ], or does not end with \".jar\"", new Object[]{ejbd.getName(), ejbd.getArchivist().getArchiveUri(), descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no ejb components in application [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

