/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.app;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.app.AppCheck;
import com.sun.enterprise.tools.verifier.tests.app.ApplicationTest;
import java.util.Iterator;
import java.util.Set;

public class AppSecurityRole
extends ApplicationTest
implements AppCheck {
    public Result check(Application descriptor) {
        Result result = this.getInitializedResult();
        if (!descriptor.getRoles().isEmpty()) {
            boolean oneFailed = false;
            boolean foundIt = false;
            Set sc = descriptor.getRoles();
            Iterator itr = sc.iterator();
            while (itr.hasNext()) {
                foundIt = false;
                Role role = (Role)itr.next();
                String roleName = role.getName();
                foundIt = roleName.length() > 0;
                if (foundIt) {
                    result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "The security role name [ {0} ] found within application [ {1} ]", new Object[]{roleName, descriptor.getName()}));
                    continue;
                }
                if (!oneFailed) {
                    oneFailed = true;
                }
                result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: The security role name [ {0} ] not found within application [ {1} ]", new Object[]{roleName, descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no role-name elements within the application [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

