/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.JarCheck;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.app.AppCheckMgrImpl;
import com.sun.enterprise.tools.verifier.appclient.AppClientCheckMgrImpl;
import com.sun.enterprise.tools.verifier.connector.ConnectorCheckMgrImpl;
import com.sun.enterprise.tools.verifier.ejb.EjbCheckMgrImpl;
import com.sun.enterprise.tools.verifier.web.WebCheckMgrImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Iterator;

public class JarCheckImpl {
    private static final EjbCheckMgrImpl ejbCheckMgr = new EjbCheckMgrImpl();
    private static final WebCheckMgrImpl webCheckMgr = new WebCheckMgrImpl();
    private static final AppCheckMgrImpl appCheckMgr = new AppCheckMgrImpl();
    private static final AppClientCheckMgrImpl appClientCheckMgr = new AppClientCheckMgrImpl();
    private static final ConnectorCheckMgrImpl connectorCheckMgr = new ConnectorCheckMgrImpl();
    private static final JarCheck[] checkMgrs = new JarCheck[]{connectorCheckMgr, webCheckMgr, appClientCheckMgr, appCheckMgr, ejbCheckMgr};
    private static final boolean debug = Verifier.getDebug();
    private Context context = null;

    public static JarCheck[] getCheckMgrs() {
        return checkMgrs;
    }

    public static void clearAllResults() {
        int i2 = 0;
        while (i2 < checkMgrs.length) {
            checkMgrs[i2].clearAllResults();
            ++i2;
        }
    }

    public void setVerifierContext(Context context) {
        this.context = context;
    }

    public Context getVerifierContext() {
        return this.context;
    }

    public void setContextForCheckMgrs() {
        int i2 = 0;
        while (i2 < checkMgrs.length) {
            checkMgrs[i2].setVerifierContext(this.context);
            ++i2;
        }
    }

    public static boolean check(Descriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        boolean allIsWell = true;
        int i2 = 0;
        while (i2 < checkMgrs.length) {
            if (checkMgrs[i2].handleDescriptor(descriptor)) {
                if (debug) {
                    System.out.println(smh.getLocalString("com.sun.enterprise.tools.verifier.JarCheckImpl.debug.Bundle", "-instance of {0}: [ {1} ]", new Object[]{descriptor.getClass(), descriptor}));
                }
                if (!checkMgrs[i2].check(descriptor)) {
                    allIsWell = false;
                }
            }
            ++i2;
        }
        return allIsWell;
    }

    public static boolean check(Iterator iterator) {
        if (iterator == null) {
            return true;
        }
        boolean passed = true;
        while (iterator.hasNext()) {
            if (JarCheckImpl.check((Descriptor)iterator.next())) continue;
            passed = false;
        }
        return passed;
    }
}

