/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class UITitledTextArea
extends UITitledBox {
    private PrivateTextArea textArea = new PrivateTextArea();
    private String lastEnabledText = null;

    public UITitledTextArea(String title, boolean showBorder) {
        super(title, showBorder);
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        this.add((Component)scrollPane, this.getGBConstraints());
        this.textArea.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe2) {
                UITitledTextArea.this.updateComponent();
            }
        });
        this.textArea.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    UITitledTextArea.this.updateComponent();
                }
            }
        });
    }

    public UITitledTextArea(String title) {
        this(title, false);
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public boolean getLineWrap() {
        return this.textArea.getLineWrap();
    }

    public void setLineWrap(boolean state) {
        this.textArea.setLineWrap(state);
        this.textArea.setWrapStyleWord(state);
    }

    public void setReadOnly(boolean state) {
        this.textArea.setReadOnly(state);
        super.setReadOnly(state);
    }

    public void setEditable(boolean state) {
        this.textArea.setEditable(state);
        super.setReadOnly(!state);
    }

    public void setEnabled(boolean state) {
        this.textArea.setEnabled(state && !this.isReadOnly());
        super.setEnabled(state);
        if (this.clearWhenDisabled) {
            if (!this.isEnabled() && this.lastEnabledText == null) {
                this.lastEnabledText = this.getText();
                this._setText("");
            } else if (this.isEnabled() && this.lastEnabledText != null) {
                this._setText(this.lastEnabledText);
                this.lastEnabledText = null;
            }
        }
    }

    public void setText(String text) {
        if (this.clearWhenDisabled) {
            if (!this.isEnabled()) {
                this.lastEnabledText = text;
            } else {
                this._setText(text);
            }
        } else {
            this._setText(text);
        }
    }

    protected void _setText(String text) {
        if (text == null) {
            text = "";
        }
        this.textArea.setText(text);
    }

    public String getText() {
        return this.textArea.getText();
    }

    public String toString() {
        return this.textArea.toString();
    }

    class PrivateTextArea
    extends JTextArea {
        private Color savedBackground = super.getBackground();

        public PrivateTextArea() {
            super.setDisabledTextColor(UITitledBox.DisabledTextColor);
            super.setLineWrap(true);
            super.setWrapStyleWord(true);
            if (UITitledBox.DefaultTextBorder != null) {
                super.setBorder(UITitledBox.DefaultTextBorder);
            }
            Insets textMargin = this.getMargin();
            if (textMargin.left < 3) {
                textMargin.left = 3;
                super.setMargin(textMargin);
            }
        }

        public void setEnabled(boolean state) {
            super.setEnabled(state);
            this.setBackground(state ? this.savedBackground : UITitledBox.DisabledBackgroundColor);
        }

        public void setReadOnly(boolean state) {
            this.setEnabled(!state);
            super.setEditable(!state);
        }

        public void setEditable(boolean state) {
            this.setEnabled(true);
            super.setEditable(state);
        }
    }
}

