/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class UIProgressBar
extends UITitledBox {
    private PrivateProgressBar progressBar = null;

    public UIProgressBar(ImageIcon iconTitle, boolean vert, int max, Color color) {
        super((String)null, false);
        GridBagConstraints gbc;
        this.getGBConstraints().gridx = vert ? 0 : -1;
        int n2 = this.getGBConstraints().gridy = !vert ? 0 : -1;
        if (iconTitle != null) {
            gbc = this.getGBConstraintsCopy();
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            this.add((Component)new JLabel(iconTitle), gbc);
        }
        this.progressBar = new PrivateProgressBar(vert, max, color);
        gbc = this.getGBConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 0.5;
        gbc.fill = 3;
        this.addWithGBConstraints(this.progressBar);
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setBarWidth(int w2) {
        Dimension d10 = this.progressBar.getPreferredSize();
        Dimension pref = this.progressBar.getOrientation() == 1 ? new Dimension(w2, d10.height) : new Dimension(d10.width, w2);
        this.progressBar.setMinimumSize(pref);
        this.progressBar.setPreferredSize(pref);
    }

    public int getMaximum() {
        return this.progressBar.getMaximum();
    }

    public int getValue() {
        return this.progressBar.getValue();
    }

    public void setValue(int val) {
        this.progressBar.setValue(val);
    }

    public void increment(int val) {
        this.progressBar.increment(val);
    }

    public void increment() {
        this.progressBar.increment();
    }

    class PrivateProgressBar
    extends JProgressBar {
        public PrivateProgressBar(boolean vertical, int max, Color color) {
            super(vertical ? 1 : 0, 0, max);
            if (color != null) {
                this.setForeground(color);
            }
            this.setBorderPainted(true);
            this.setValue(0);
        }

        public void increment(int val) {
            this.setValue(this.getValue() + val);
        }

        public void increment() {
            this.increment(1);
        }
    }
}

