/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.AppListenerDescriptorImpl;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptorImpl;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellEditor;

public class WebEventListenerInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$WebEventListenerInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$WebEventListenerInspector = WebEventListenerInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.WebEventListenerInspector")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$WebEventListenerInspector);
    private static final String EVENT_TABLE_TITLE = localStrings.getLocalString("ui.webeventlistenerinspector.table_title", "Event Listeners");
    private static final String MOVE_UP = localStrings.getLocalString("ui.webeventlistenerinspector.move_up", "Move Up");
    private static final String MOVE_DOWN = localStrings.getLocalString("ui.webeventlistenerinspector.move_down", "Move Down");
    private static final String EVENT_LISTENER_CLASSES = localStrings.getLocalString("ui.webeventlistenerinspector.event_listener_classes", "Event Listener Classes");
    private static final String ADD_EVENT_LISTENER = localStrings.getLocalString("ui.webeventlistenerinspector.add_event_listener", "Add Event Listener to WAR File ...");
    private static final String TABNAME = localStrings.getLocalString("ui.webeventlistenerinspector.tabname", "Event Listeners");
    private static String wizardHelpID = "AppListener";
    private static String deployHelpID = "AppListener";
    private WebBundleDescriptor descriptor = null;
    private UITitledTable listenerPanel = null;
    private ListenerTable listenerTable = null;
    private ListenerTableModel listenerTableModel = null;
    private static final Class[] listenerClasses = new Class[]{class$javax$servlet$ServletContextListener == null ? (class$javax$servlet$ServletContextListener = WebEventListenerInspector.class$("javax.servlet.ServletContextListener")) : class$javax$servlet$ServletContextListener, class$javax$servlet$ServletContextAttributeListener == null ? (class$javax$servlet$ServletContextAttributeListener = WebEventListenerInspector.class$("javax.servlet.ServletContextAttributeListener")) : class$javax$servlet$ServletContextAttributeListener};
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$WebEventListenerInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$WebBundleDescriptor;
    static /* synthetic */ Class class$javax$servlet$ServletContextListener;
    static /* synthetic */ Class class$javax$servlet$ServletContextAttributeListener;

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new WebEventListenerInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isWizardMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$deployment$WebBundleDescriptor == null ? (class$com$sun$enterprise$deployment$WebBundleDescriptor = WebEventListenerInspector.class$("com.sun.enterprise.deployment.WebBundleDescriptor")) : class$com$sun$enterprise$deployment$WebBundleDescriptor;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WebBundleDescriptor ? (WebBundleDescriptor)desc : (desc instanceof WebComponentDescriptorImpl ? ((WebComponentDescriptorImpl)desc).getWebBundleDescriptor() : null);
            this.listenerTable.clearTableData();
        }
    }

    private WebEventListenerInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c10 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.listenerPanel = new UITitledTable(EVENT_TABLE_TITLE, true);
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        this.add((Component)this.listenerPanel, c10);
        this.listenerTableModel = new ListenerTableModel();
        this.listenerTable = new ListenerTable(this.listenerTableModel);
        this.listenerPanel.setTableView(this.listenerTable);
        UIButton addButton = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebEventListenerInspector.this.addAction();
            }
        });
        this.listenerPanel.addControlButton(addButton);
        UIButton delButton = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebEventListenerInspector.this.deleteAction();
            }
        }, true);
        this.listenerPanel.addSelectionEnabledButton(delButton);
        UIButton mvUpBtn = new UIButton(MOVE_UP, null, new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebEventListenerInspector.this.moveUpAction();
            }
        });
        this.listenerPanel.addSelectionEnabledButton(mvUpBtn);
        UIButton mvDnBtn = new UIButton(MOVE_DOWN, null, new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebEventListenerInspector.this.moveDownAction();
            }
        });
        this.listenerPanel.addSelectionEnabledButton(mvDnBtn);
    }

    public void refresh() {
        this.listenerTable.updateTableData(this.descriptor.getAppListenerDescriptors());
        Vector eventListenerList = this.getListeners();
        this.listenerTable.resetEditors(eventListenerList);
    }

    private AppListenerDescriptorImpl getSelectedListener() {
        return (AppListenerDescriptorImpl)this.listenerTable.getSelectedRowObject();
    }

    private Vector getListeners() {
        Vector<String> v2 = new Vector<String>();
        Vector el2 = this.getArchiveClassNames(listenerClasses);
        if (el2 != null) {
            v2.addAll(el2);
        } else {
            UIUtils.debugPrintln("WebEventListenerInspector.getListeners", "Unabled to obtain a list of Listener classes");
        }
        if (UIUtils.debugMode() && v2.size() == 0) {
            v2.add("test1Listener");
            v2.add("test2Listener");
            v2.add("test3Listener");
        }
        return v2;
    }

    private void addAction() {
        if (this.listenerTable.getRowWithValue(0, "") == null) {
            this.descriptor.addAppListenerDescriptor(new AppListenerDescriptorImpl(""));
        }
        this.listenerTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    private void deleteAction() {
        Object[] list = this.listenerTable.confirmDeleteSelection(null, null);
        if (list != null) {
            int i2 = 0;
            while (i2 < list.length) {
                AppListenerDescriptorImpl ref = (AppListenerDescriptorImpl)list[i2];
                this.descriptor.removeAppListenerDescriptor(ref);
                ++i2;
            }
            this.invokeRefresh();
        }
    }

    private void moveUpAction() {
        AppListenerDescriptorImpl ref = this.getSelectedListener();
        if (ref != null) {
            this.descriptor.moveAppListenerDescriptor(ref, -1);
            this.invokeRefresh();
        }
    }

    private void moveDownAction() {
        AppListenerDescriptorImpl ref = this.getSelectedListener();
        if (ref != null) {
            this.descriptor.moveAppListenerDescriptor(ref, 1);
            this.invokeRefresh();
        }
    }

    private void addListenerDialog() {
        JOptionPane.showConfirmDialog(this, "Dialog for adding Event Listeners", "Add Event Listener", 0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$600(WebEventListenerInspector x0) {
        x0.addListenerDialog();
    }

    private class ListenerTableModel
    extends InspectorTableModel {
        Thread addListener_deferred = null;

        public ListenerTableModel() {
            super(new String[]{EVENT_LISTENER_CLASSES});
            this.setDataOrdering(2);
            this.addListener_deferred = new Thread(this){
                private final /* synthetic */ ListenerTableModel this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    WebEventListenerInspector.access$600(ListenerTableModel.access$500(this.this$1));
                }
            };
        }

        public AppListenerDescriptorImpl getRow(int index) {
            return (AppListenerDescriptorImpl)this.getRowObject(index);
        }

        public Object getObjectValue(Object obj, int col) {
            AppListenerDescriptorImpl ref = (AppListenerDescriptorImpl)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getListener();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            AppListenerDescriptorImpl ref = (AppListenerDescriptorImpl)obj;
            if (ref == null) {
                return;
            }
            switch (col) {
                case 0: {
                    String val = value.toString();
                    if (val.equals(ADD_EVENT_LISTENER)) {
                        EventQueue.invokeLater(this.addListener_deferred);
                        break;
                    }
                    ref.setListener(val);
                }
            }
        }

        static /* synthetic */ WebEventListenerInspector access$500(ListenerTableModel x0) {
            return x0.WebEventListenerInspector.this;
        }
    }

    private class ListenerTable
    extends InspectorTable {
        DefaultCellEditor eventListeners = null;

        public ListenerTable(ListenerTableModel model) {
            super(model);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
        }

        public void resetEditors(Vector evl) {
            this.eventListeners = new DefaultCellEditor(new JComboBox(evl));
        }

        public TableCellEditor getCellEditor(int row, int col) {
            TableCellEditor rtn = null;
            switch (col) {
                case 0: {
                    rtn = this.eventListeners;
                    break;
                }
                default: {
                    rtn = super.getCellEditor(row, col);
                }
            }
            return rtn;
        }
    }
}

