/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.AuthorizationConstraintImpl;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.web.AuthorizationConstraint;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIListSelector;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledControlButtonBox;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.help.CSH;
import javax.swing.JButton;

class WebAppRolePicker
extends UIDialog
implements ActionListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppRolePicker == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppRolePicker = WebAppRolePicker.class$("com.sun.enterprise.tools.deployment.ui.descriptor.WebAppRolePicker")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppRolePicker);
    private static final String AUTHORIZED_ROLES = localStrings.getLocalString("ui.webapprolepicker.authorized_roles", "Authorized Roles:");
    private static String helpSetMapID = "RolePicker";
    private UIListSelector listPanel = null;
    private Descriptor availRolesDescriptor = null;
    private SecurityConstraintImpl authRolesDescriptor = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppRolePicker;

    private static String ROLES_IN(String v0) {
        return localStrings.getLocalString("ui.webapprolepicker.available_roles_title", "Roles in {0}:", new Object[]{v0});
    }

    private static String DIALOG_TITLE_FOR(String v0) {
        return localStrings.getLocalString("ui.webapprolepicker.authorized_roles_for", "Authorized Roles for {0}", new Object[]{v0});
    }

    public WebAppRolePicker(Frame owner) {
        super(owner, true);
        this.initDialog();
    }

    public WebAppRolePicker(Dialog owner) {
        super(owner, true);
        this.initDialog();
    }

    private void initDialog() {
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.doNothingOnClose();
        UITitledControlButtonBox windowPanel = new UITitledControlButtonBox(null, false);
        windowPanel.setControlButtonLocation(101);
        this.setContentPane(windowPanel);
        this.listPanel = new UIListSelector("<>", AUTHORIZED_ROLES);
        this.listPanel.setDescriptorCellRenderer();
        GridBagConstraints wgbc = windowPanel.getViewContainerGBConstraints();
        wgbc.insets = new Insets(5, 5, 5, 5);
        windowPanel.setView(this.listPanel);
        UIButton okBtn = UIButton.createOkButton(this);
        windowPanel.addControlButton(okBtn);
        UIButton cancelBtn = UIButton.createCancelButton(this);
        windowPanel.addControlButton(cancelBtn);
        UIHelpButton helpBtn = new UIHelpButton(helpSetMapID);
        windowPanel.addControlButton(helpBtn);
        this.resetBounds();
    }

    public void setLocationRelativeTo(Component comp) {
        this.resetBounds();
        super.setLocationRelativeTo(comp);
    }

    private void resetBounds() {
        Window win = this.getOwner();
        if (win != null) {
            Rectangle b10 = win.getBounds();
            b10.x += 20;
            b10.y += 20;
            b10.width = 525;
            b10.height = 250;
            ((Component)this).setBounds(b10);
        } else {
            ((Component)this).setSize(525, 250);
            this.centerOnScreen();
        }
    }

    public void _showDialog() {
        this.resetBounds();
        super._showDialog();
    }

    public void setSecurityConstraintDescriptors(Descriptor availRoles, SecurityConstraintImpl authRoles) {
        this.setTitle(WebAppRolePicker.DIALOG_TITLE_FOR(authRoles.getName()));
        this.listPanel.setTitleLeft(WebAppRolePicker.ROLES_IN(availRoles.getName()));
        this.availRolesDescriptor = availRoles;
        Enumeration availEnum = null;
        if (availRoles instanceof WebBundleDescriptor) {
            availEnum = ((WebBundleDescriptor)availRoles).getSecurityRoles();
        }
        this.listPanel.setListContentsLeft(availEnum);
        this.authRolesDescriptor = authRoles;
        AuthorizationConstraint aci = authRoles.getAuthorizationConstraint();
        Enumeration authEnum = aci != null ? aci.getSecurityRoles() : null;
        this.listPanel.setListContentsRight(authEnum);
    }

    public AuthorizationConstraintImpl getAuthorizedRoles() {
        AuthorizationConstraintImpl aci = new AuthorizationConstraintImpl();
        Enumeration e10 = this.listPanel.getListContentsRight().elements();
        while (e10.hasMoreElements()) {
            aci.addSecurityRole((SecurityRoleDescriptor)e10.nextElement());
        }
        return aci;
    }

    public void actionPerformed(ActionEvent ae2) {
        String cmd = ((JButton)ae2.getSource()).getActionCommand();
        if (cmd.equals("ok")) {
            if (this.authRolesDescriptor != null) {
                AuthorizationConstraintImpl aci = this.getAuthorizedRoles();
                this.authRolesDescriptor.setAuthorizationConstraint(aci);
            }
            this.hide();
        } else if (cmd.equals("cancel")) {
            this.hide();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

