/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.tools.deployment.ui.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIRadioButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextArea;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.ejb.EJBException;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FinderSelectDialog {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$FinderSelectDialog == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$FinderSelectDialog = FinderSelectDialog.class$("com.sun.enterprise.tools.deployment.ui.descriptor.FinderSelectDialog")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$FinderSelectDialog);
    private static final String FIND_SELECT_METHODS = localStrings.getLocalString("ui.finderselectdialog.dialog_title", "Finder/Select Methods");
    private static final String IMPL_QUERIES = localStrings.getLocalString("ui.finderselectdialog.ejb_ql_queries_title", "EJB-QL Queries for Finder/Select Methods");
    private static final String SHOW_FINDERS = localStrings.getLocalString("ui.finderselectdialog.show_finders", "Show:");
    private static final String SHOW_LOCAL_FINDERS = localStrings.getLocalString("ui.finderselectdialog.show_local_finders", "Local Finders");
    private static final String SHOW_REMOTE_FINDERS = localStrings.getLocalString("ui.finderselectdialog.show_remote_finders", "Remote Finders");
    private static final String SHOW_SELECT_METHODS = localStrings.getLocalString("ui.finderselectdialog.show_select_methods", "Select Methods");
    private static final String FINDER_QUERY = localStrings.getLocalString("ui.finderselectdialog.ejbql_query", "EJB-QL Query");
    private static final String RETURN_TYPE = localStrings.getLocalString("ui.finderselectdialog.return.type", "Return EJBs Of Type:");
    private static final String RETURN_LOCAL = localStrings.getLocalString("ui.finderselectdialog.return.local", "Local");
    private static final String RETURN_REMOTE = localStrings.getLocalString("ui.finderselectdialog.return.remote", "Remote");
    private static final String RETURN_NONE = localStrings.getLocalString("ui.finderselectdialog.return.none", "None");
    private static final String FINDER_TABLE_METHOD = localStrings.getLocalString("ui.finderselectdialog.findertablemethod", "Method");
    private static final String helpID = "FinderSelectMethods";
    private static Object[] FINDER_OPTIONS = new Object[]{SHOW_LOCAL_FINDERS, SHOW_REMOTE_FINDERS, SHOW_SELECT_METHODS};
    private UIRadioButtonBox showFinders = null;
    private DescriptionInspector.DescriptionManagerDialog finderSelectDialog = null;
    private FinderSelectTable finderTable = null;
    private UITitledTextArea finderQueryText = null;
    private Hashtable tableDataCache = new Hashtable();
    private UITitledComboBox rtnTypeCB = null;
    private EjbCMPEntityDescriptor descriptor = null;
    private PersistenceDescriptor persDescriptor = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$FinderSelectDialog;

    private static String FIND_SELECT_METHODS_FOR(String v0) {
        return localStrings.getLocalString("ui.finderselectdialog.dialog_title_for", "Finder/Select Methods for {0}", new Object[]{v0});
    }

    private static final String FINDER_QUERY_FOR(String v0) {
        return localStrings.getLocalString("ui.finderselectdialog.ejbql_query_for", "EJB-QL Query for {0}", new Object[]{v0});
    }

    private static String ERROR_GETTING_QUERY_METHODS(String v0) {
        return localStrings.getLocalString("ui.finderselectdialog.error_getting_query_methods", "Error encountered while trying to obtain query methods\n {0}", new Object[]{v0});
    }

    public FinderSelectDialog(Component owner) {
        this.finderSelectDialog = DescriptionInspector.DescriptionManagerDialog.newDialog(owner);
        this.finderSelectDialog.setModal(true);
        this.finderSelectDialog.doNothingOnClose();
        this.finderSelectDialog.setContentPane(this.getFinderSelectPane());
        ((Component)this.finderSelectDialog).setSize(550, 330);
        this.finderSelectDialog.setLocationRelativeToOwner(20, 20);
    }

    private JPanel getFinderSelectPane() {
        UITitledControlButtonBox panel = new UITitledControlButtonBox(null, false);
        panel.setControlButtonLocation(101);
        UITitledBox viewBox = new UITitledBox(IMPL_QUERIES, true);
        panel.setView(viewBox);
        GridBagConstraints c10 = viewBox.getGBConstraintsCopy();
        this.showFinders = new UIRadioButtonBox(SHOW_FINDERS, false);
        this.showFinders.setModel(FINDER_OPTIONS);
        this.showFinders.setClearWhenDisabled(true);
        this.showFinders.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                FinderSelectDialog.this.refreshDialog();
            }
        });
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 0);
        c10.fill = 0;
        c10.anchor = 11;
        viewBox.add((Component)this.showFinders, c10);
        UITitledTable tablePanel = new UITitledTable(null, false);
        this.finderTable = new FinderSelectTable(new FinderSelectTableModel());
        this.finderTable.setMinimumSize(new Dimension(150, 150));
        this.finderTable.getSelectionModel().addListSelectionListener(new FinderSelectionListener());
        tablePanel.setTableView(this.finderTable);
        c10.weightx = 0.45;
        c10.weighty = 0.5;
        c10.gridx = 1;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 0);
        c10.fill = 1;
        c10.anchor = 10;
        viewBox.add((Component)tablePanel, c10);
        UITitledBox queryBox = new UITitledBox(null, false);
        c10.weightx = 0.55;
        c10.weighty = 0.5;
        c10.gridx = 2;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        c10.anchor = 10;
        viewBox.add((Component)queryBox, c10);
        this.finderQueryText = new UITitledTextArea(FINDER_QUERY, false);
        this.finderQueryText.setClearWhenDisabled(true);
        this.finderQueryText.setEnabled(false);
        this.finderQueryText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                QueryItem q2 = (QueryItem)FinderSelectDialog.this.finderTable.getSelectedRowObject();
                if (q2 != null) {
                    q2.setEjbQL(FinderSelectDialog.this.finderQueryText.getText());
                }
            }
        });
        queryBox.addWithGBConstraints(this.finderQueryText);
        this.rtnTypeCB = new UITitledComboBox(RETURN_TYPE, false);
        this.rtnTypeCB.setClearWhenDisabled(true);
        this.rtnTypeCB.setEnabled(false);
        this.rtnTypeCB.setModel(new String[]{RETURN_LOCAL, RETURN_REMOTE, RETURN_NONE});
        this.rtnTypeCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                QueryItem q2 = (QueryItem)FinderSelectDialog.this.finderTable.getSelectedRowObject();
                if (q2 != null) {
                    q2.setReturn(FinderSelectDialog.this.rtnTypeCB.getText());
                }
            }
        });
        GridBagConstraints gbc = queryBox.getGBConstraintsCopy();
        gbc.weighty = 0.0;
        gbc.insets.top = 5;
        gbc.fill = 2;
        queryBox.add((Component)this.rtnTypeCB, gbc);
        UIButton okBtn = UIButton.createOkButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                FinderSelectDialog.this.okAction();
            }
        });
        panel.addControlButton(okBtn);
        UIButton cancelBtn = UIButton.createCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                FinderSelectDialog.this.finderSelectDialog.hide();
            }
        });
        panel.addControlButton(cancelBtn);
        panel.addControlButton(new UIHelpButton(helpID));
        return panel;
    }

    private void refreshDialog() {
        this.showFinders.setItemEnabled(SHOW_LOCAL_FINDERS, this.descriptor.getLocalHomeClassName() != null);
        this.showFinders.setItemEnabled(SHOW_REMOTE_FINDERS, this.descriptor.getHomeClassName() != null);
        String showMeth = (String)this.showFinders.getSelectedItem();
        if (showMeth == null) {
            if (this.showFinders.isItemEnabled(SHOW_LOCAL_FINDERS)) {
                this.showFinders.setSelectedItem(SHOW_LOCAL_FINDERS);
            } else if (this.showFinders.isItemEnabled(SHOW_REMOTE_FINDERS)) {
                this.showFinders.setSelectedItem(SHOW_REMOTE_FINDERS);
            } else {
                this.showFinders.setSelectedItem(SHOW_SELECT_METHODS);
            }
            showMeth = (String)this.showFinders.getSelectedItem();
        }
        Vector<QueryItem> queryList = new Vector<QueryItem>();
        Enumeration values = this.tableDataCache.elements();
        while (values.hasMoreElements()) {
            QueryItem q2 = (QueryItem)values.nextElement();
            if (!q2.getType().equals(showMeth)) continue;
            queryList.add(q2);
        }
        this.finderTable.clearTableData();
        this.finderTable.updateTableData(queryList);
        this.finderTable.clearSelection();
        this.finderQueryText.setEnabled(false);
        this.rtnTypeCB.setEnabled(false);
    }

    public void setDescriptor(Object d10) {
        this.descriptor = (EjbCMPEntityDescriptor)d10;
        this.persDescriptor = this.descriptor.getPersistenceDescriptor();
        this.finderSelectDialog.setTitle(FinderSelectDialog.FIND_SELECT_METHODS_FOR(this.descriptor.getName()));
        this.loadDataCache(true);
    }

    public void show() {
        this.refreshDialog();
        this.finderSelectDialog.show();
    }

    private void okAction() {
        Enumeration enumeration = this.tableDataCache.keys();
        while (enumeration.hasMoreElements()) {
            String methName = (String)enumeration.nextElement();
            QueryItem qi = (QueryItem)this.tableDataCache.get(methName);
            Method meth = qi.getMethod();
            QueryDescriptor qd = this.persDescriptor.getQueryFor(meth);
            if (qd == null) {
                qd = new QueryDescriptor();
                qd.setQueryMethod(meth);
                this.persDescriptor.setQueryFor(meth, qd);
            }
            qd.setQuery(qi.getEjbQL());
            qd.setDescription(qi.getDescription());
            String rt = qi.getReturn();
            if (rt.equals(RETURN_LOCAL)) {
                qd.setHasLocalReturnTypeMapping();
                continue;
            }
            if (rt.equals(RETURN_REMOTE)) {
                qd.setHasRemoteReturnTypeMapping();
                continue;
            }
            qd.setHasNoReturnTypeMapping();
        }
        this.finderSelectDialog.hide();
    }

    private Hashtable loadDataCache(boolean clear) {
        if (clear) {
            this.tableDataCache.clear();
        }
        try {
            String className = this.descriptor.getLocalHomeClassName();
            if (className != null) {
                this.addMethods(this.getEjbClass(className).getMethods(), SHOW_LOCAL_FINDERS, "find", this.tableDataCache);
            }
            if ((className = this.descriptor.getHomeClassName()) != null) {
                this.addMethods(this.getEjbClass(className).getMethods(), SHOW_REMOTE_FINDERS, "find", this.tableDataCache);
            }
            this.addMethods(this.persDescriptor.getPersistentClass().getMethods(), SHOW_SELECT_METHODS, "ejbSelect", this.tableDataCache);
        }
        catch (Exception ex2) {
            UIOptionPane.showErrorDialog(this.finderSelectDialog, FinderSelectDialog.ERROR_GETTING_QUERY_METHODS(ex2.toString()));
        }
        return this.tableDataCache;
    }

    private void addMethods(Method[] methods, String type, String mKey, Hashtable ht) {
        int i2 = 0;
        while (i2 < methods.length) {
            Method meth = methods[i2];
            String methName = new MethodDescriptor(meth).getFormattedString();
            if (methName.startsWith(mKey) && !methName.startsWith("findByPrimaryKey")) {
                QueryDescriptor qd;
                QueryItem qi = (QueryItem)ht.get(methName);
                if (qi == null) {
                    qi = new QueryItem(methName, meth, "", RETURN_LOCAL, "", type);
                    ht.put(methName, qi);
                }
                if ((qd = this.persDescriptor.getQueryFor(meth)) != null) {
                    qi.setEjbQL(qd.getIsEjbQl() ? qd.getQuery() : "");
                    qi.setDescription(qd.getDescription());
                    if (qd.getHasLocalReturnTypeMapping()) {
                        qi.setReturn(RETURN_LOCAL);
                    } else if (qd.getHasRemoteReturnTypeMapping()) {
                        qi.setReturn(RETURN_REMOTE);
                    } else {
                        qi.setReturn(RETURN_NONE);
                    }
                }
            }
            ++i2;
        }
    }

    private Class getEjbClass(String className) {
        try {
            EjbBundleArchivist arch = (EjbBundleArchivist)this.persDescriptor.getEjbBundleDescriptor().getArchivist();
            return arch.getClassLoader().loadClass(className);
        }
        catch (Exception ex2) {
            throw new EJBException(ex2);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FinderSelectTableModel
    extends InspectorTableModel {
        public FinderSelectTableModel() {
            super(new String[]{FINDER_TABLE_METHOD, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
            this.setDataOrdering(1);
        }

        public Descriptor getRowDescriptor(int index) {
            return (QueryDescriptor)this.getRowObject(index);
        }

        public boolean isCellEditable(int row, int col) {
            return col > 0;
        }

        public Object getObjectValue(Object obj, int col) {
            QueryItem q2 = (QueryItem)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = q2.getName();
                    break;
                }
                case 1: {
                    value = q2.getDescription();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            QueryItem q2 = (QueryItem)obj;
            switch (col) {
                case 0: {
                    break;
                }
                case 1: {
                    q2.setDescription(value.toString());
                }
            }
            FinderSelectDialog.this.descriptor.changed();
        }
    }

    private class FinderSelectTable
    extends InspectorTable {
        public FinderSelectTable(FinderSelectTableModel model) {
            super(model);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
            this.setHandleDescriptionUpdates(true);
        }
    }

    private class FinderSelectionListener
    implements ListSelectionListener {
        private FinderSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e10) {
            if (e10.getValueIsAdjusting()) {
                return;
            }
            QueryItem q2 = (QueryItem)FinderSelectDialog.this.finderTable.getSelectedRowObject();
            if (q2 == null) {
                FinderSelectDialog.this.finderQueryText.setTitle(FINDER_QUERY);
                FinderSelectDialog.this.finderQueryText.setEnabled(false);
                FinderSelectDialog.this.rtnTypeCB.setEnabled(false);
            } else {
                String qfn = q2.getName();
                int p2 = qfn.indexOf("(");
                String qmn = p2 > 0 ? qfn.substring(0, p2) : qfn;
                FinderSelectDialog.this.finderQueryText.setTitle(FinderSelectDialog.FINDER_QUERY_FOR(qmn));
                FinderSelectDialog.this.finderQueryText.setText(q2.getEjbQL());
                FinderSelectDialog.this.finderQueryText.setEnabled(true);
                if (FinderSelectDialog.this.showFinders.getSelectedItem().equals(SHOW_SELECT_METHODS)) {
                    FinderSelectDialog.this.rtnTypeCB.setSelectedItem(q2.getReturn());
                    FinderSelectDialog.this.rtnTypeCB.setEnabled(true);
                } else {
                    FinderSelectDialog.this.rtnTypeCB.setSelectedItem(null);
                    FinderSelectDialog.this.rtnTypeCB.setEnabled(false);
                }
            }
        }
    }

    private class QueryItem
    extends InspectorTableModel.InspectorDataWrapper {
        public QueryItem(String n2, Method m2, String e10, String r2, String d10, String t2) {
            super(new Object[]{n2, m2, e10, r2, d10, t2});
            this.setDefaultNullValue("");
        }

        public String getName() {
            return (String)this.getObject(0);
        }

        public Method getMethod() {
            return (Method)this.getObject(1);
        }

        public String getEjbQL() {
            return (String)this.getObject(2);
        }

        public String getReturn() {
            return (String)this.getObject(3);
        }

        public String getDescription() {
            return (String)this.getObject(4);
        }

        public String getType() {
            return (String)this.getObject(5);
        }

        public void setEjbQL(String v2) {
            this.setObject(2, v2);
        }

        public void setReturn(String v2) {
            this.setObject(3, v2);
        }

        public void setDescription(String v2) {
            this.setObject(4, v2);
        }
    }
}

