/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.deployment.xml.ConnectorNode;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.tools.deployment.ui.DeployToolActions;
import com.sun.enterprise.tools.deployment.ui.DescriptorInspector;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.Wizard;
import com.sun.enterprise.tools.deployment.ui.descriptor.ConnectorRARGeneralInspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.ResAdaptConnFactInspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.ResAdaptGeneralInspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.ResAdaptSecurityInspector;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.crimson.tree.XmlDocument;

public class NewResAdaptWizard
extends Wizard {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$NewResAdaptWizard == null ? (class$com$sun$enterprise$tools$deployment$ui$NewResAdaptWizard = NewResAdaptWizard.class$("com.sun.enterprise.tools.deployment.ui.NewResAdaptWizard")) : class$com$sun$enterprise$tools$deployment$ui$NewResAdaptWizard);
    private static final String HELP_TEXT = localStrings.getLocalString("ui.newresadaptwizard.help", "<HTML><BODY><P>This wizard will help you to create a new resource afapter.  You must begin with the set of interface and implementation classes for the resource adapter.<BR>The wizard will then package these classes into an archive file and will create the deployment descriptor required by the resource adapter.<P>Creating this resource adapter requires the following steps:<UL><LI>Identify the archive file that will contain the resource adapter.<LI>Identify the interface and implementation classes for the resource adapter.</UL><P>Optionally, you can also:<UL><LI>Define the level of transaction support for the resource adapter.<LI>Provide the default configuration parameters for its connection factories.<LI>Define a set of connection factories to be deployed with the resource adapter.<LI>Provide the security information for the resource adapter.</UL></BODY></HTML>");
    private static final String WIZARD_TITLE = localStrings.getLocalString("ui.newresadaptwizard.newwizardtitle", "New Resource Adapter Wizard");
    private ConnectorRARGeneralInspector connRarGeneralInspector;
    private ResAdaptGeneralInspector raGeneralInspector;
    private ResAdaptConnFactInspector connFactInspector;
    private ResAdaptSecurityInspector securityInspector;
    private JTextArea xmlTextArea = new JTextArea();
    private ConnectorDescriptor connectorDescriptor;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$NewResAdaptWizard;

    public String getHelpGroup() {
        return "RW";
    }

    public NewResAdaptWizard(Frame owner, JComponent targetChooser) {
        super(owner);
        this.createWands(targetChooser);
        super.setBounds(100, 100, 700, 580);
        super.setTitle(WIZARD_TITLE);
        super.show();
    }

    private void createWands(JComponent targetChooser) {
        String mode = "WizardMode";
        Vector inspectors = new Vector();
        super.addIntroPanel(HELP_TEXT);
        this.connRarGeneralInspector = (ConnectorRARGeneralInspector)ConnectorRARGeneralInspector.newInspectorPane(mode, targetChooser);
        this.addInspectorPane(this.connRarGeneralInspector, localStrings.getLocalString("ui.newresadaptwizard.rar_file", "RAR File"), localStrings.getLocalString("ui.newresadaptwizard.rar_file_help", "*see LocalStrings.properties*"));
        this.raGeneralInspector = (ResAdaptGeneralInspector)ResAdaptGeneralInspector.newInspectorPane(mode, null);
        this.addInspectorPane(this.raGeneralInspector, localStrings.getLocalString("ui.newresadaptwizard.general", "General"), localStrings.getLocalString("ui.newresadaptwizard.general_help", "*see LocalStrings.properties*"));
        this.connFactInspector = (ResAdaptConnFactInspector)ResAdaptConnFactInspector.newInspectorPane(mode, null);
        this.addInspectorPane(this.connFactInspector, localStrings.getLocalString("ui.newresadaptwizard.connectionfactories", "Connection Factories"), localStrings.getLocalString("ui.newresadaptwizard.connectionfactories_help", "*see LocalStrings.properties*"));
        this.securityInspector = (ResAdaptSecurityInspector)ResAdaptSecurityInspector.newInspectorPane(mode, null);
        this.addInspectorPane(this.securityInspector, localStrings.getLocalString("ui.newresadaptwizard.security", "Security"), localStrings.getLocalString("ui.newresadaptwizard.security_help", "*see LocalStrings.properties*"));
        XMLDisplay xmlDisp = new XMLDisplay(this.xmlTextArea);
        super.addComponent(xmlDisp, localStrings.getLocalString("ui.newresadaptwizard.review_settings", "Review Settings"), localStrings.getLocalString("ui.newresadaptwizard.inspect_xml", "Inspect XML descriptor"));
    }

    public ConnectorDescriptor getCurrentConnectorDescriptor() {
        if (this.connectorDescriptor == null) {
            this.connectorDescriptor = new ConnectorDescriptor();
            this.connectorDescriptor.setName("Rar1");
            this.addDescriptorListener(this.connectorDescriptor, new NotificationListener(){

                public void notification(NotificationEvent ae2) {
                    NewResAdaptWizard.this.descriptorChanged();
                }
            });
        }
        return this.connectorDescriptor;
    }

    public void setCurrentConnectorDescriptor(ConnectorDescriptor descriptor) {
        this.connectorDescriptor = descriptor;
    }

    public FileContentsDescriptor getFileContentsDescriptor() {
        return this.connRarGeneralInspector.getFileContentsDescriptor();
    }

    public String getStandAloneArchiveFileName() {
        return this.connRarGeneralInspector.getArchiveFileName();
    }

    protected void descriptorChanged() {
        this.delegateNotification(this.getCurrentComponent());
    }

    void delegateNotification(Object insp) {
        if (insp instanceof DescriptorInspector) {
            ConnectorDescriptor cd2 = this.getCurrentConnectorDescriptor();
            ((DescriptorInspector)insp).setDescriptor(cd2);
            if (insp instanceof InspectorPane) {
                ((InspectorPane)insp).invokeRefresh();
            }
        }
    }

    public void goForward() {
        JComponent currentComponent = super.getCurrentComponent();
        if (currentComponent == this.connRarGeneralInspector) {
            String archName;
            if (this.isStandAlone() && (archName = this.getStandAloneArchiveFileName()).equals("")) {
                JOptionPane.showMessageDialog(this, localStrings.getLocalString("ui.newresadaptwizard.archive_name_not_specified", "Please supply an archive filename"));
                if (!UIUtils.debugMode()) {
                    return;
                }
            }
            boolean hasJar = false;
            FileContentsDescriptor fcd = this.connRarGeneralInspector.getFileContentsDescriptor();
            Enumeration e10 = fcd.getFiles();
            while (e10.hasMoreElements()) {
                File f2 = (File)e10.nextElement();
                String fn = f2.getName();
                if (!fn.endsWith(".jar") && !fn.endsWith(".class")) continue;
                hasJar = true;
            }
            if (!hasJar) {
                JOptionPane.showMessageDialog(this, localStrings.getLocalString("ui.newresadaptwizard.content_not_added", "Please add .class or .jar files to the content."));
                if (!UIUtils.debugMode()) {
                    return;
                }
            }
        } else if (currentComponent == this.raGeneralInspector) {
            // empty if block
        }
        super.goForward();
        JComponent newCurrent = super.getCurrentComponent();
        DeployToolActions.enableHelpOnButton(this.helpButton, CSH.getHelpIDString((Component)newCurrent));
        if (newCurrent instanceof XMLDisplay) {
            this.refreshXmlDisplay();
        }
        this.delegateNotification(newCurrent);
    }

    public boolean isStandAlone() {
        return this.connRarGeneralInspector.isStandAlone();
    }

    public void goBackward() {
        super.goBackward();
        JComponent currentComponent = super.getCurrentComponent();
        DeployToolActions.enableHelpOnButton(this.helpButton, CSH.getHelpIDString((Component)currentComponent));
    }

    public void finishAction() {
        super.finishAction();
    }

    private void refreshXmlDisplay() {
        try {
            XmlDocument document = ConnectorNode.getDocument(this.connectorDescriptor);
            StringWriter sw = new StringWriter();
            XMLUtils.writeDocument(document, sw);
            this.xmlTextArea.setText(sw.toString());
        }
        catch (Throwable t2) {
            System.out.println(localStrings.getLocalString("ui.newresadaptwizard.error_forming_xml", "Warning: error forming XML"));
        }
    }

    public String toString() {
        return "Resource Adapter Wizard";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class XMLDisplay
    extends JPanel {
        public XMLDisplay(JTextArea ta) {
            CSH.setHelpIDString((Component)this, (String)(NewResAdaptWizard.this.getHelpGroup() + "Review"));
            this.setLayout(new BorderLayout());
            this.add(new JScrollPane(ta));
            ta.setEnabled(false);
        }
    }
}

