/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.xml.ApplicationClientNode;
import com.sun.enterprise.deployment.xml.ApplicationNode;
import com.sun.enterprise.deployment.xml.ConnectorNode;
import com.sun.enterprise.deployment.xml.EjbBundleNode;
import com.sun.enterprise.deployment.xml.WebBundleNode;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.tools.deployment.ui.DescriptorInspector;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIFileChooser;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextArea;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.crimson.tree.XmlDocument;

public class DescriptorViewer
extends UIDialog
implements DescriptorInspector,
NotificationListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$DescriptorViewer == null ? (class$com$sun$enterprise$tools$deployment$ui$DescriptorViewer = DescriptorViewer.class$("com.sun.enterprise.tools.deployment.ui.DescriptorViewer")) : class$com$sun$enterprise$tools$deployment$ui$DescriptorViewer);
    private Descriptor descriptor = null;
    private static String helpSetMapID = "DescriptorViewer";
    private UITitledTextArea descriptorText = null;
    private StringWriter sw = null;
    private JFileChooser jfc = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$DescriptorViewer;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$Descriptor;

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$deployment$Descriptor == null ? (class$com$sun$enterprise$deployment$Descriptor = DescriptorViewer.class$("com.sun.enterprise.deployment.Descriptor")) : class$com$sun$enterprise$deployment$Descriptor;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor d10) {
        d10.addNotificationListener(this);
        this.descriptor = d10;
        this.refresh();
    }

    public DescriptorViewer(Frame frame) {
        super(frame, false);
        ((Component)this).setSize(new Dimension(500, 400));
        this.setTitle(localStrings.getLocalString("ui.descriptorviewer.title", "Deployment Descriptor Viewer"));
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints c10 = new GridBagConstraints();
        c10.gridx = 0;
        c10.gridy = 0;
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridheight = 3;
        c10.gridwidth = 3;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        this.descriptorText = new UITitledTextArea(null, false);
        this.descriptorText.setEditable(false);
        this.descriptorText.setLineWrap(false);
        contentPane.add((Component)this.descriptorText, c10);
        UITitledControlButtonBox buttonPanel = new UITitledControlButtonBox(null, false);
        buttonPanel.setControlButtonLocation(101);
        JButton saveAsPB = new JButton(localStrings.getLocalString("ui.descriptorviewer.saveas", "Save As..."));
        buttonPanel.addControlButton(saveAsPB);
        saveAsPB.setMnemonic('S');
        saveAsPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                DescriptorViewer.this.saveAsAction();
            }
        });
        JButton closePB = new JButton(localStrings.getLocalString("ui.descriptorviewer.close", "Close"));
        buttonPanel.addControlButton(closePB);
        closePB.setMnemonic('C');
        closePB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                DescriptorViewer.this.hide();
            }
        });
        buttonPanel.addControlButton(new UIHelpButton(helpSetMapID));
        c10.gridx = 2;
        c10.gridy = 3;
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.gridheight = 1;
        c10.gridwidth = 1;
        c10.anchor = 13;
        c10.fill = 0;
        contentPane.add((Component)buttonPanel, c10);
        super.setContentPane(contentPane);
    }

    public void notification(NotificationEvent ne) {
        this.refresh();
    }

    private void saveAsAction() {
        if (this.jfc == null) {
            this.jfc = UIFileChooser.getFileChooser();
        }
        this.jfc.rescanCurrentDirectory();
        int returnValue = this.jfc.showDialog(this, localStrings.getLocalString("ui.descriptorviewer.save_descriptor", "Save Deployment Descriptor"));
        if (returnValue == 0) {
            File newFile = this.jfc.getSelectedFile();
            if (newFile.exists()) {
                int overwrite = JOptionPane.showConfirmDialog(this, localStrings.getLocalString("deploytoolwindow.already_exists", "{0} already exists. Do you wish to overwrite?", new Object[]{newFile}), localStrings.getLocalString("deploytoolwindow.confirm", "Confirm"), 0, 3);
                if (overwrite == 0) {
                    newFile.delete();
                } else {
                    return;
                }
            }
            if (this.sw != null) {
                try {
                    FileOutputStream fos = new FileOutputStream(newFile);
                    byte[] deploymentDescriptor = this.sw.toString().getBytes();
                    fos.write(deploymentDescriptor, 0, deploymentDescriptor.length);
                    fos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void refresh() {
        XmlDocument document = null;
        if (this.descriptor instanceof Application) {
            document = ApplicationNode.getDocument((Application)this.descriptor);
        } else if (this.descriptor instanceof ApplicationClientDescriptor) {
            document = ApplicationClientNode.getDocument((ApplicationClientDescriptor)this.descriptor);
        } else if (this.descriptor instanceof EjbBundleDescriptor) {
            document = EjbBundleNode.getDocument((EjbBundleDescriptor)this.descriptor);
        } else if (this.descriptor instanceof WebBundleDescriptor) {
            document = WebBundleNode.getDocument((WebBundleDescriptor)this.descriptor);
        } else if (this.descriptor instanceof ConnectorDescriptor) {
            document = ConnectorNode.getDocument((ConnectorDescriptor)this.descriptor);
        }
        if (document != null) {
            try {
                this.sw = new StringWriter();
                XMLUtils.writeDocument(document, this.sw);
                this.descriptorText.setText(this.sw.toString());
            }
            catch (Throwable t2) {
                System.out.println(localStrings.getLocalString("ui.descriptorviewer.error_forming_xml", "Warning: error forming XML"));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

