/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIComponentUpdateHandler;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledPasswordField;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class DeploymentSettingsInspector {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$DeploymentSettingsInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$DeploymentSettingsInspector = DeploymentSettingsInspector.class$("com.sun.enterprise.tools.deployment.ui.DeploymentSettingsInspector")) : class$com$sun$enterprise$tools$deployment$ui$DeploymentSettingsInspector);
    private static final String INSPECTOR_BUTTON = localStrings.getLocalString("ui.deploymentsettingsinspector.inspector_button", "Deployment Settings...");
    private static final String DEPLOYMENT_SETTINGS = localStrings.getLocalString("ui.deploymentsettingsinspector.deployment_settings", "Deployment Settings");
    private static final String DB_SETTINGS = localStrings.getLocalString("ui.deploymentsettingsinspector.db_settings", "Database settings");
    private static final String DB_JNDI_NAME = localStrings.getLocalString("ui.deploymentsettingsinspector.db_jndi_name", "Database JNDI Name:");
    private static final String USER_NAME = localStrings.getLocalString("ui.deploymentsettingsinspector.user_name", "User name:");
    private static final String PASSWORD = localStrings.getLocalString("ui.deploymentsettingsinspector.password", "Password:");
    private static final String GENERATE_SQL = localStrings.getLocalString("ui.deploymentsettingsinspector.generate_sql", "Generate SQL Now");
    private static String helpSetMapID = "DeploymentSettings";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$DeploymentSettingsInspector;

    private DeploymentSettingsInspector() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class DialogDisplayButton
    extends JButton
    implements ActionListener {
        private UpdateListener target = null;
        private DeploymentSettingsDialog dialog = null;

        public DialogDisplayButton(UpdateListener target) {
            super(INSPECTOR_BUTTON);
            this.target = target;
            super.setActionCommand("show");
            super.addActionListener(this);
        }

        public void setUpdateListener(UpdateListener target) {
            this.target = target;
            this._getDialog().setUpdateListener(this.target);
        }

        public void setDeploymentSettingsInspector(String dbName, String userName, String passwd) {
            this._getDialog().setModel(dbName, userName, passwd);
        }

        public void actionPerformed(ActionEvent ae2) {
            this._getDialog().show();
        }

        private DeploymentSettingsDialog _getDialog() {
            if (this.dialog == null) {
                Window window = UIUtils.getAncestorWindow(this);
                this.dialog = window instanceof Dialog ? new DeploymentSettingsDialog((Dialog)window) : new DeploymentSettingsDialog((Frame)window);
                this.dialog.setUpdateListener(this.target);
            }
            return this.dialog;
        }
    }

    private static class DeploymentSettingsDialog
    extends UIDialog {
        private static final String helpSetMapID = "DatabaseSettings";
        private EjbBundleDescriptor descriptor = null;
        private UITitledTextField dbNameText = null;
        private UITitledTextField userNameText = null;
        private UITitledPasswordField passwdText = null;
        private JButton okButton = null;
        private JButton sqlgenPB = null;
        private final DeploymentSettingsDialog thisDialog = this;
        private UpdateListener target = null;

        public DeploymentSettingsDialog(Frame owner) {
            super(owner, true);
            this.initDialog(owner);
        }

        public DeploymentSettingsDialog(Dialog owner) {
            super(owner, true);
            this.initDialog(owner);
        }

        private void initDialog(Window window) {
            this.setTitle(DEPLOYMENT_SETTINGS);
            this.doNothingOnClose();
            this.setEnableBusyCursor(true);
            JPanel contentPane = new JPanel();
            contentPane.setToolTipText(DEPLOYMENT_SETTINGS);
            contentPane.setPreferredSize(new Dimension(580, 400));
            GridBagLayout gridbag = new GridBagLayout();
            contentPane.setLayout(gridbag);
            this.setContentPane(contentPane);
            GridBagConstraints c10 = new GridBagConstraints();
            c10.weightx = 0.5;
            c10.gridx = 0;
            c10.gridy = -1;
            c10.gridwidth = 1;
            c10.gridheight = 1;
            c10.insets = new Insets(5, 5, 5, 5);
            UITitledControlButtonBox upperHalf = new UITitledControlButtonBox(null, false);
            c10.weighty = 0.0;
            c10.fill = 2;
            c10.anchor = 11;
            contentPane.add((Component)upperHalf, c10);
            UITitledBox dbSettingsPane = new UITitledBox(DB_SETTINGS, true);
            GridBagConstraints gbc = dbSettingsPane.getGBConstraints();
            upperHalf.setView(dbSettingsPane);
            gbc.weighty = 0.0;
            gbc.gridx = -1;
            gbc.gridy = 0;
            UITitledBox dbSettingsLeft = new UITitledBox(null, false);
            gbc.weightx = 0.5;
            gbc.fill = 2;
            dbSettingsPane.addWithGBConstraints(dbSettingsLeft);
            UITitledBox dbSettingsRight = new UITitledBox(null, false);
            gbc.weightx = 0.0;
            gbc.fill = 0;
            gbc.anchor = 14;
            gbc.insets.left = 5;
            dbSettingsPane.add((Component)dbSettingsRight, gbc);
            this.dbNameText = new UITitledTextField(DB_JNDI_NAME, false);
            this.dbNameText.addUpdateHandler(new UIComponentUpdateHandler(this){
                private final /* synthetic */ DeploymentSettingsDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void updateComponent(JComponent c10) {
                    this.this$0.doButtonEnablement();
                }
            });
            dbSettingsLeft.addWithGBConstraints(this.dbNameText);
            this.userNameText = new UITitledTextField(USER_NAME, false);
            dbSettingsLeft.addWithGBConstraints(this.userNameText);
            this.passwdText = new UITitledPasswordField(PASSWORD, false);
            dbSettingsLeft.addWithGBConstraints(this.passwdText);
            this.okButton = UIButton.createOkButton(new ActionListener(this){
                private final /* synthetic */ DeploymentSettingsDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent e10) {
                    DeploymentSettingsDialog.access$500(this.this$0);
                }
            });
            upperHalf.addControlButton(this.okButton);
            UIButton canPB = UIButton.createCancelButton(new ActionListener(this){
                private final /* synthetic */ DeploymentSettingsDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent e10) {
                    DeploymentSettingsDialog.access$600(this.this$0);
                }
            });
            upperHalf.addControlButton(canPB);
            UIHelpButton helpPB = new UIHelpButton(helpSetMapID);
            upperHalf.addControlButton(helpPB);
            this.sqlgenPB = new UIButton(GENERATE_SQL, null, new ActionListener(this){
                private final /* synthetic */ DeploymentSettingsDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent e10) {
                    DeploymentSettingsDialog.access$800(this.this$0);
                }
            });
            upperHalf.addControlButton(this.sqlgenPB);
            Rectangle b10 = this.getOwner().getBounds();
            b10.x += 20;
            b10.y += 20;
            b10.width = 380;
            b10.height = 180;
            ((Component)this).setBounds(b10);
        }

        public void setUpdateListener(UpdateListener target) {
            this.target = target;
        }

        private void okAction() {
            if (!this.dbNameText.getText().equals("")) {
                this.target.resourceReferenceUpdated(this.dbNameText.getText(), this.userNameText.getText(), this.passwdText.getText());
                this.setVisible(false);
            }
        }

        private void cancelAction() {
            this.setVisible(false);
        }

        void setModel(String dbName, String name, String passwd) {
            this.dbNameText.setText(dbName);
            this.userNameText.setText(name);
            this.passwdText.setText(passwd);
            this.doButtonEnablement();
        }

        void doButtonEnablement() {
            boolean ok = !"".equals(this.dbNameText.getText());
            this.sqlgenPB.setEnabled(ok);
            this.okButton.setEnabled(ok);
        }

        private void generateSQL() {
            String dbName = this.dbNameText.getText();
            if (dbName.equals("")) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploymentsettingsinspector.no_dbname_specified", "ERROR: No database name specified"));
                return;
            }
            String currentServer = DT.getServerManager().getCurrentServer();
            if (currentServer == null) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploymentsettingsinspector.please_connect_to_server", "You must connect to a target server to generate SQL"));
                return;
            }
            try {
                this.target.generateSQL(dbName, this.userNameText.getText(), this.passwdText.getText(), this);
                UIOptionPane.showInfoDialog(this, localStrings.getLocalString("ui.deploymentsettingsinspector.sql_complete", "SQL Generation complete"));
            }
            catch (Throwable t2) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploymentsettingsinspector.error_generating_sql", "ERROR: while generating SQL.\n{0}\nPlease make sure the database name/user/password is valid\nand the J2EE server and database are running.", new Object[]{t2}));
            }
        }

        static /* synthetic */ void access$500(DeploymentSettingsDialog x0) {
            x0.okAction();
        }

        static /* synthetic */ void access$600(DeploymentSettingsDialog x0) {
            x0.cancelAction();
        }

        static /* synthetic */ void access$800(DeploymentSettingsDialog x0) {
            x0.generateSQL();
        }
    }

    public static interface UpdateListener {
        public void resourceReferenceUpdated(String var1, String var2, String var3);

        public void generateSQL(String var1, String var2, String var3, JDialog var4) throws Exception;
    }
}

