/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.backend;

import com.sun.ejb.codegen.GeneratorDriver;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.Switch;
import com.sun.enterprise.activation.Activator;
import com.sun.enterprise.activation.BadServerDefinition;
import com.sun.enterprise.activation.Repository;
import com.sun.enterprise.activation.ServerDef;
import com.sun.enterprise.activation.ServerNotActiveException;
import com.sun.enterprise.activation.ServerNotRegisteredException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.jms.JmsConfig;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.repository.JmsCnxFactoryResource;
import com.sun.enterprise.repository.JmsDestinationResource;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.resource.ConnectorInfo;
import com.sun.enterprise.resource.NameNotFoundException;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.server.EJBServer;
import com.sun.enterprise.tools.deployment.backend.ApplicationRegistry;
import com.sun.enterprise.tools.deployment.backend.BufferedRemoteByteArray;
import com.sun.enterprise.tools.deployment.backend.BufferedRemoteByteArrayImpl;
import com.sun.enterprise.tools.deployment.backend.DeploymentSession;
import com.sun.enterprise.tools.deployment.backend.JarInstaller;
import com.sun.enterprise.tools.deployment.backend.JarManagerImpl;
import com.sun.enterprise.tools.deployment.backend.JarRepository;
import com.sun.enterprise.tools.deployment.backend.RemoteNotificationListener;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.Utility;
import com.sun.web.server.ServletDeployer;
import com.sun.web.server.WebServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class JarInstallerImpl
implements JarInstaller {
    private static final boolean debug = false;
    public static final String CODEBASE_PREFIX = "http://" + Utility.getLocalAddress() + ":";
    public static final String SERVER_CHANGED = "ServerChanged";
    public static String port = null;
    public static String jit = System.getProperty("java.compiler");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$backend$JarInstallerImpl == null ? (class$com$sun$enterprise$tools$deployment$backend$JarInstallerImpl = JarInstallerImpl.class$("com.sun.enterprise.tools.deployment.backend.JarInstallerImpl")) : class$com$sun$enterprise$tools$deployment$backend$JarInstallerImpl);
    private static int uniqueId = (int)(System.currentTimeMillis() & 0xFFFFFFFFFFFFFFFFL);
    private static Hashtable ejbJarCache = new Hashtable();
    private Vector listeners = new Vector();
    private InitialContext ic = null;
    private Repository serverRepository = null;
    private Activator activator = null;
    private EJBServer server = null;
    private WebServer httpd = null;
    private ApplicationRegistry applicationRegistry = null;
    private JmsConfig jmsConfig_ = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$backend$JarInstallerImpl;
    static /* synthetic */ Class class$com$sun$web$server$ServletDeployer;

    public JarInstallerImpl(EJBServer server, WebServer httpd, File workingDirectory, Repository rep, Activator act) throws Exception {
        this.applicationRegistry = new ApplicationRegistry(workingDirectory);
        this.ic = new InitialContext();
        this.serverRepository = rep;
        this.activator = act;
        this.server = server;
        this.httpd = httpd;
        ServerConfiguration sconfig = ServerConfiguration.getConfiguration();
        port = sconfig.getProperty("ejb.http.port", "9191");
    }

    public String deployApplication(BufferedRemoteByteArray applicationBuffer, String applicationName, DeploymentSession session) throws RemoteException {
        byte[] applicationBytes = BufferedRemoteByteArrayImpl.getBytesUtility(applicationBuffer);
        String clientCodeUrl = this.deployApplication(applicationBytes, applicationName, session);
        return clientCodeUrl;
    }

    public String deployApplication(byte[] applicationJar, String applicationName, DeploymentSession session) throws RemoteException {
        boolean deleted;
        File jarFile;
        Object ejbClientJarFile = null;
        String codebase = null;
        int webAppCount = 0;
        Application application = null;
        this.progress(localStrings.getLocalString("enterprise.tools.deployment.backend.contacted.server", "Contacted server..."), session);
        try {
            jarFile = this.applicationRegistry.newApplicationJarFile(applicationName);
            this.saveAsBytes(applicationJar, jarFile);
            this.progress(localStrings.getLocalString("enterprise.tools.deployment.backend.application.transferred", "Application {0} transferred", new Object[]{applicationName}), session);
            this.progressEvent("Application Transferred", session);
            application = ApplicationArchivist.open(jarFile, false);
            this.setEjbJarIds(application);
            ApplicationArchivist appArch = application.getApplicationArchivist();
            appArch.setClassLoadable(true);
            appArch.save(appArch.getApplicationFile(), true);
        }
        catch (Throwable ioe) {
            Log.err.println(ioe);
            session.setException(new Exception(ioe.getMessage()));
            throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.error.saving/opening.jar", "Error saving/opening JAR ", new Object[]{ioe.getMessage()}));
        }
        boolean redeploy = false;
        File oldAppJar = null;
        if (this.isInstalled(applicationName)) {
            redeploy = true;
            String serverJarFileName = JarRepository.getServerJarFilename(applicationName);
            oldAppJar = new File(serverJarFileName);
            this.undeployApplication(applicationName, redeploy);
        }
        int ejbCount = application.getEjbDescriptors().size();
        webAppCount = application.getWebBundleDescriptors().size();
        this.progress(localStrings.getLocalString("enterprise.tools.deployment.backend.application.ejb/webcount", "{0} has {1}  ejbs, {2} web components to deploy", new Object[]{application.getName(), new Integer(ejbCount), new Integer(webAppCount)}), session);
        File serverJarFile = jarFile;
        File clientJarFile = jarFile;
        serverJarFile = this.applicationRegistry.newEjbServerJarFile(application.getName());
        clientJarFile = this.applicationRegistry.newEjbClientJarFile(application.getName());
        codebase = this.deployEjbs(application, serverJarFile, clientJarFile, session, oldAppJar);
        if (oldAppJar != null && !(deleted = oldAppJar.delete())) {
            Log.err.println("Couldn't delete old app jar : " + oldAppJar);
        }
        if (webAppCount > 0) {
            this.deployWebComponents(serverJarFile, session);
        }
        if (application.getRarComponentCount() > 0) {
            ResourceInstaller ri = Switch.getSwitch().getResourceInstaller();
            Iterator iter = application.getRarDescriptors().iterator();
            while (iter.hasNext()) {
                ConnectorDescriptor desc = (ConnectorDescriptor)iter.next();
                String connectorName = desc.getArchivist().getArchiveUri();
                ri.registerConnectorDescriptor(desc, applicationName, connectorName);
            }
        }
        if (!session.isCancelled()) {
            JarRepository.writeToPropsFile(application.getName(), application.getApplicationArchivist().getApplicationFile(), serverJarFile, clientJarFile);
            System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.application.deployed", "Application {0} deployed.\n", new Object[]{applicationName}));
            this.changed();
            this.progress(localStrings.getLocalString("enterprise.tools.deployment.backend.deployment.complete", " Deployment of {0} is complete.", new Object[]{application.getName()}), session);
            this.progressEvent("Done Deploying", session);
            return codebase;
        }
        return null;
    }

    public void restoreWebComponents() throws Exception {
        Vector applicationNames = JarRepository.getApplicationList();
        ServletDeployer webServer = this.getDeploymentModule();
        if (webServer == null) {
            throw new Exception(localStrings.getLocalString("enterprise.tools.deployment.backend.webservernotfound", "Couldn't find of web server to restore the last known applications"));
        }
        Enumeration e10 = applicationNames.elements();
        while (e10.hasMoreElements()) {
            String applicationName = (String)e10.nextElement();
            String applicationFile = JarRepository.getServerJarFilename(applicationName);
            try {
                webServer.loadWebComponents(applicationFile, null);
            }
            catch (Throwable t2) {
                throw new Exception(localStrings.getLocalString("enterprise.tools.deployment.backend.errorrestoring.application", " Error restoring {0}   {1}", new Object[]{applicationName, t2.getMessage()}));
            }
        }
    }

    private void setEjbJarIds(Application app) {
        Application oldApp = JarRepository.getApplicationForName(app.getName());
        if (oldApp == null) {
            Iterator it = app.getEjbBundleDescriptors().iterator();
            while (it.hasNext()) {
                EjbBundleDescriptor ebd = (EjbBundleDescriptor)it.next();
                int id = this.getUniqueId();
                ebd.setUniqueId(id);
                ejbJarCache.put(new Integer(id), ebd);
            }
        } else {
            Iterator it = app.getEjbBundleDescriptors().iterator();
            while (it.hasNext()) {
                EjbBundleDescriptor ebd = (EjbBundleDescriptor)it.next();
                EjbBundleDescriptor oldEbd = null;
                try {
                    oldEbd = oldApp.getEjbBundleByUri(ebd.getArchivist().getArchiveUri());
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                int id = oldEbd != null ? oldEbd.getUniqueId() : this.getUniqueId();
                ebd.setUniqueId(id);
                ejbJarCache.put(new Integer(id), ebd);
            }
        }
    }

    public static EjbBundleDescriptor getEjbJarForId(int id) {
        return (EjbBundleDescriptor)ejbJarCache.get(new Integer(id));
    }

    private synchronized int getUniqueId() {
        return ++uniqueId;
    }

    private boolean isInstalled(String applicationName) {
        boolean installed = false;
        try {
            installed = this.getApplicationNames().contains(applicationName);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return installed;
    }

    public Vector getApplicationNames() throws RemoteException {
        return JarRepository.getApplicationList();
    }

    public Application getApplicationForName(String applicationName) throws RemoteException {
        Application a = null;
        try {
            a = JarRepository.getApplicationForName(applicationName);
        }
        catch (Throwable t2) {
            System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.errorreturning.application", " Error returning {0}", new Object[]{applicationName}));
            System.out.println(t2);
        }
        return a;
    }

    public void undeployApplication(String applicationName) throws RemoteException {
        this.undeployApplication(applicationName, false);
    }

    private void undeployApplication(String applicationName, boolean redeploy) throws RemoteException {
        int serverId = -1;
        try {
            File appFile;
            Application application;
            this.cleanupNameSpace(applicationName);
            if (this.server == null) {
                serverId = this.serverRepository.getServerID(applicationName);
                if (serverId != -1) {
                    this.serverRepository.unregisterServer(serverId);
                    this.activator.shutdown(serverId);
                }
            } else {
                serverId = this.serverRepository.getServerID(applicationName);
                if (serverId != -1) {
                    this.serverRepository.unregisterServer(serverId);
                }
            }
            String applicationJarFilename = JarRepository.getJarFilename(applicationName);
            this.getDeploymentModule().unloadWebComponents(applicationJarFilename);
            if (this.server != null) {
                JarManagerImpl jarMgr = this.server.getEJBJarManager();
                jarMgr.undeploy(applicationName);
            }
            if ((application = ApplicationArchivist.open(appFile = new File(applicationJarFilename))).getRarComponentCount() > 0) {
                ResourceInstaller ri = Switch.getSwitch().getResourceInstaller();
                Iterator iter = application.getRarDescriptors().iterator();
                while (iter.hasNext()) {
                    ConnectorDescriptor desc = (ConnectorDescriptor)iter.next();
                    String connectorName = desc.getArchivist().getArchiveUri();
                    ri.forceResourcePoolCleanup(applicationName, connectorName);
                    ri.unregisterConnectorDescriptor(applicationName, connectorName);
                }
            }
            JarRepository.getApplicationJarFilenamesFor(applicationName);
            String serverJarFileName = JarRepository.getServerJarFilename(applicationName);
            Enumeration e10 = JarRepository.getApplicationJarFilenamesFor(applicationName).elements();
            while (e10.hasMoreElements()) {
                String nextServerJar = (String)e10.nextElement();
                if (redeploy && nextServerJar.equals(serverJarFileName)) continue;
                System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.delete.nextserverjar", " delete {0}", new Object[]{nextServerJar}));
                boolean deleted = new File(nextServerJar).delete();
                if (deleted) continue;
                System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.errorjarnotdeleted", " Warning: {0} could not be deleted", new Object[]{nextServerJar}));
            }
            JarRepository.removeFromPropsFile(applicationName);
            this.removeDirectory(GeneratorDriver.getTempDirectory(applicationName));
            if (!redeploy) {
                Iterator it = application.getEjbBundleDescriptors().iterator();
                while (it.hasNext()) {
                    EjbBundleDescriptor ebd = (EjbBundleDescriptor)it.next();
                    int id = ebd.getUniqueId();
                    ejbJarCache.remove(new Integer(id));
                }
            }
        }
        catch (ServerNotRegisteredException e11) {
            throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.exceptionapplicationnotdeployed", " Application {0} is not deployed", new Object[]{applicationName}));
        }
        catch (ServerNotActiveException se) {
            throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.exceptionapplicationnotactive", " Applicaiton {0} is not active ", new Object[]{applicationName}));
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.exceptionapplicationnotundeployed.reasonnotknown", " Application {0} could not be undeployed - reason unknown", new Object[]{applicationName}));
        }
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.applicationundeployed", " Application {0} has been undeployed", new Object[]{applicationName}));
        this.changed();
    }

    private void removeDirectory(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            int i2 = 0;
            while (i2 < files.length) {
                File child = files[i2];
                if (child.isDirectory()) {
                    this.removeDirectory(child);
                }
                child.delete();
                ++i2;
            }
        }
        dir.delete();
    }

    public Vector getGroupNames() throws RemoteException {
        String[] realms = Realm.getSupported();
        Vector groupNames = new Vector();
        if (realms != null) {
            try {
                int i2 = 0;
                while (i2 < realms.length) {
                    Enumeration e10 = Realm.getInstance(realms[i2]).getGroupNames();
                    while (e10.hasMoreElements()) {
                        groupNames.addElement(e10.nextElement());
                    }
                    ++i2;
                }
            }
            catch (Exception e11) {
                System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.errorjarinstallergettinggroupnames", "Jar Installer Error getting group names"));
                throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.exceptiongettinggroupnames", " Error getting group names: {0} ", new Object[]{e11.getMessage()}));
            }
        }
        return groupNames;
    }

    public Vector getUserNames() throws RemoteException {
        String[] realms = Realm.getSupported();
        Vector userNames = new Vector();
        if (realms != null) {
            try {
                int i2 = 0;
                while (i2 < realms.length) {
                    Enumeration e10 = Realm.getInstance(realms[i2]).getUserNames();
                    while (e10.hasMoreElements()) {
                        userNames.addElement(e10.nextElement());
                    }
                    ++i2;
                }
            }
            catch (Exception e11) {
                System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.jarinstallerimplerrorgettingusernames", "Jar Installer Impl Error getting user names"));
                throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.exceptiongettingusernames", " Error getting user names: {0} ", new Object[]{e11.getMessage()}));
            }
        }
        return userNames;
    }

    public void deployConnector(byte[] data, String name) throws RemoteException, PoolingException {
        ResourceInstaller pm = Switch.getSwitch().getResourceInstaller();
        pm.installResourceAdapter(data, name);
    }

    public Set getConnectionFactoryPropertyTemplate(String appName, String connectorName) throws RemoteException, PoolingException {
        ResourceInstaller pm = Switch.getSwitch().getResourceInstaller();
        ConnectorDescriptor desc = pm.getDescriptorByConnectorName(appName, connectorName);
        if (desc == null) {
            throw new NameNotFoundException(appName + ":" + connectorName);
        }
        Set props = desc.getConfigProperties();
        return props;
    }

    public void addConnectionFactory(String appName, String connectorName, String jndiName, String xaRecoveryUser, String xaRecoveryPassword, Properties props) throws RemoteException, PoolingException {
        ResourceInstaller pm = Switch.getSwitch().getResourceInstaller();
        pm.addConnectionFactory(appName, connectorName, jndiName, xaRecoveryUser, xaRecoveryPassword, props);
    }

    public void removeConnectionFactory(String jndiName) throws RemoteException, PoolingException {
        ResourceInstaller pm = Switch.getSwitch().getResourceInstaller();
        pm.removeConnectionFactory(jndiName);
    }

    public void undeployConnector(String name) throws RemoteException, PoolingException {
        ResourceInstaller pm = Switch.getSwitch().getResourceInstaller();
        pm.uninstallResourceAdapter(name);
    }

    public ConnectorInfo listConnectors() throws RemoteException, PoolingException {
        ResourceInstaller pm = Switch.getSwitch().getResourceInstaller();
        return pm.listResourceAdapters();
    }

    public Set listConnectorResources() throws RemoteException {
        ResourceInstaller pm = Switch.getSwitch().getResourceInstaller();
        return pm.listConnectorResources();
    }

    public void createDestination(JmsDestinationResource destination) throws RemoteException, JMSException {
        try {
            JmsConfig jmsConfig = this.getJmsConfig();
            jmsConfig.createDestination(destination.getName(), destination.getIsQueue());
        }
        catch (Exception e10) {
            Log.err.println(e10);
            throw new JMSException(e10.getMessage());
        }
    }

    public void deleteDestination(JmsDestinationResource destination) throws RemoteException, JMSException {
        try {
            JmsConfig jmsConfig = this.getJmsConfig();
            jmsConfig.deleteDestination(destination.getName());
        }
        catch (Exception e10) {
            Log.err.println(e10);
            throw new JMSException(e10.getMessage());
        }
    }

    public void createJmsConnectionFactory(JmsCnxFactoryResource jmsCnxFactory) throws RemoteException, JMSException {
        try {
            JmsConfig jmsConfig = this.getJmsConfig();
            HashMap<String, Object> propsMap = new HashMap<String, Object>();
            Iterator propsIter = jmsCnxFactory.getProperties().iterator();
            while (propsIter.hasNext()) {
                ResourceProperty nextProp = (ResourceProperty)propsIter.next();
                propsMap.put(nextProp.getName(), nextProp.getValue());
            }
            jmsConfig.createConnectionFactory(jmsCnxFactory.getName(), jmsCnxFactory.getIsQueue(), propsMap);
        }
        catch (Exception e10) {
            Log.err.println(e10);
            throw new JMSException(e10.getMessage());
        }
    }

    public void deleteJmsConnectionFactory(JmsCnxFactoryResource jmsCnxFactory) throws RemoteException, JMSException {
        try {
            JmsConfig jmsConfig = this.getJmsConfig();
            jmsConfig.deleteConnectionFactory(jmsCnxFactory.getName());
        }
        catch (Exception e10) {
            Log.err.println(e10);
            throw new JMSException(e10.getMessage());
        }
    }

    private String deployEjbs(Application application, File serverJarFile, File clientJarFile, DeploymentSession session, File oldServerJar) throws RemoteException {
        String serverJarName = "";
        int serverId = -1;
        String codebase = CODEBASE_PREFIX + port + "/" + URLEncoder.encode(application.getName()) + "Client.jar";
        this.progress(localStrings.getLocalString("enterprise.tools.deployment.backend.deployingEjbs", "Deploying Ejbs..."), session);
        try {
            serverJarName = GeneratorDriver.preDeploy(application.getName(), application.getApplicationArchivist().getApplicationFile(), serverJarFile, clientJarFile, session, oldServerJar);
            if (session.isCancelled()) {
                return null;
            }
        }
        catch (Exception e10) {
            Log.err.println(e10);
            session.setException(e10);
            throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.exceptionprocessingejbjar", " Error processing ejb jar: {0} ", new Object[]{e10.getMessage()}));
        }
        if (this.server == null) {
            try {
                serverId = JarInstallerImpl.registerServer(application.getName(), serverJarFile, this.serverRepository);
            }
            catch (BadServerDefinition e11) {
                session.setException(e11);
                throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.exceptionapplicationalreadydeployed", " Application {0} is already deployed", new Object[]{application.getName()}));
            }
            catch (Throwable t2) {
                Log.err.println(t2);
                throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.servercouldnotberegistered", "server could not be registered"));
            }
            this.progress(localStrings.getLocalString("enterprise.tools.deployment.backend.activatingEJBserverwithid", "Activating EJB Server with id: {0} ", new Object[]{new Integer(serverId)}), session);
            try {
                this.activator.activate(serverId, true);
            }
            catch (Exception e12) {
                Log.err.println(e12);
                session.setException(e12);
                throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.exceptionactivationerror", " Activation error {0} ", new Object[]{e12.getMessage()}));
            }
        }
        JarManagerImpl jarMgr = this.server.getEJBJarManager();
        jarMgr.loadJar(serverJarFile.toString());
        return codebase;
    }

    protected void deployWebComponents(File applicationServerFile, DeploymentSession session) throws RemoteException {
        ServletDeployer webServer = this.getDeploymentModule();
        if (webServer == null) {
            String message = localStrings.getLocalString("enterprise.tools.deployment.backend.webservercouldnotbecontacted", "Error: The Web Server could not be contacted");
            this.progress(message, session);
            throw new RemoteException(message);
        }
        this.progress(localStrings.getLocalString("enterprise.tools.deployment.backend.contactwebservertorun", "Contact the web server and ask it to run: {0} ", new Object[]{applicationServerFile}), session);
        webServer.loadWebComponents(applicationServerFile.toString(), session);
        if (session != null && !session.isCancelled()) {
            this.progress(localStrings.getLocalString("enterprise.tools.deployment.backend.webcomponentdeployed", "Web Components Deployed."), session);
        }
    }

    private void saveAsBytes(byte[] data, File file) throws IOException {
        if (data == null) {
            throw new IOException(localStrings.getLocalString("enterprise.tools.deployment.backend.nulldata", "null data"));
        }
        FileOutputStream fileStream = new FileOutputStream(file);
        fileStream.write(data, 0, data.length);
        fileStream.close();
    }

    private byte[] getFileAsBytes(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] fileAsBytes = new byte[fileInputStream.available()];
        fileInputStream.read(fileAsBytes);
        fileInputStream.close();
        return fileAsBytes;
    }

    private void progress(String message, DeploymentSession session) {
        if (session != null) {
            try {
                session.setStatusMessage(message);
            }
            catch (Throwable t2) {
                Log.err.println(t2);
            }
        }
    }

    private void progressEvent(String eventType, DeploymentSession session) {
        if (session != null) {
            try {
                session.notification(new NotificationEvent("", eventType, ""));
            }
            catch (Throwable t2) {
                Log.err.println(t2);
            }
        }
    }

    public void addRemoteNotificationListener(RemoteNotificationListener listener) throws RemoteException {
        this.listeners.addElement(listener);
    }

    public void removeRemoteNotificationListener(RemoteNotificationListener listener) throws RemoteException {
        this.listeners.removeElement(listener);
    }

    public void changed() throws RemoteException {
        Vector listenersClone = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            listenersClone = (Vector)this.listeners.clone();
        }
        Enumeration e10 = listenersClone.elements();
        while (e10.hasMoreElements()) {
            final RemoteNotificationListener nl = (RemoteNotificationListener)e10.nextElement();
            final NotificationEvent ne = new NotificationEvent("", SERVER_CHANGED, SERVER_CHANGED, "");
            Thread notificationThread = new Thread(){

                public void run() {
                    try {
                        nl.notification(ne);
                    }
                    catch (Throwable re) {
                        JarInstallerImpl.this.listeners.removeElement(nl);
                    }
                }
            };
            notificationThread.start();
        }
    }

    private ServletDeployer getDeploymentModule() {
        try {
            if (this.httpd == null) {
                Object objref = this.ic.lookup("WebInstaller");
                Object o2 = PortableRemoteObject.narrow((Object)objref, (Class)(class$com$sun$web$server$ServletDeployer == null ? (class$com$sun$web$server$ServletDeployer = JarInstallerImpl.class$("com.sun.web.server.ServletDeployer")) : class$com$sun$web$server$ServletDeployer));
                ServletDeployer deploymentModule = (ServletDeployer)o2;
                return deploymentModule;
            }
            return this.httpd.getDeployer();
        }
        catch (Exception ex2) {
            Log.err.println(ex2);
            return null;
        }
    }

    private void cleanupNameSpace(String appName) {
        try {
            NamingManager nm = Switch.getSwitch().getNamingManager();
            Application application = JarRepository.getApplicationForName(appName);
            if (application == null) {
                throw new RuntimeException(localStrings.getLocalString("enterprise.tools.deployment.backend.exceptioncouldnotopenapplication", "Couldn't open :  {0} ", new Object[]{appName}));
            }
            Vector ejbDescriptors = application.getEjbDescriptors();
            int i2 = 0;
            while (i2 < ejbDescriptors.size()) {
                EjbDescriptor e10 = (EjbDescriptor)ejbDescriptors.elementAt(i2);
                String jndiName = e10.getJndiName();
                System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.unbindingJNDIname", "Unbinding JNDI name: {0} ", new Object[]{jndiName}));
                if (!e10.getType().equals("Message-driven") && e10.isRemoteInterfacesSupported()) {
                    nm.unpublishObject(jndiName);
                }
                nm.unbindObjects(e10);
                ++i2;
            }
            Set webDescriptors = application.getWebBundleDescriptors();
            Iterator itr = webDescriptors.iterator();
            while (itr.hasNext()) {
                WebBundleDescriptor wbd = (WebBundleDescriptor)itr.next();
                nm.unbindObjects(wbd);
            }
        }
        catch (Exception e11) {
            Log.err.println(e11);
        }
    }

    public static int registerServer(String appname, File serverJarFile, Repository repository) throws BadServerDefinition, RemoteException {
        String classpath = "";
        String codebase = CODEBASE_PREFIX + port + "/" + appname + "Client.jar";
        String vmArgs = "-Djava.security.policy=" + System.getProperty("com.sun.enterprise.home") + "/lib/security/server.policy";
        vmArgs = vmArgs + " -Djava.rmi.server.codebase=" + codebase;
        if (jit != null) {
            vmArgs = vmArgs + " -Djava.compiler=" + jit;
        }
        ServerDef serverDef = new ServerDef(appname, "com.sun.enterprise.server.EJBServer", classpath, serverJarFile.getAbsolutePath(), vmArgs);
        int serverId = repository.registerServer(serverDef);
        return serverId;
    }

    private JmsConfig getJmsConfig() throws Exception {
        if (this.jmsConfig_ == null) {
            this.jmsConfig_ = new JmsConfig(1);
        }
        return this.jmsConfig_;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

