/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login;

import com.sun.enterprise.security.LoginContext;
import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.security.auth.login.X509CertificateCredential;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class CertificateLoginModule
implements LoginModule {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$security$auth$login$CertificateLoginModule == null ? (class$com$sun$enterprise$security$auth$login$CertificateLoginModule = CertificateLoginModule.class$("com.sun.enterprise.security.auth.login.CertificateLoginModule")) : class$com$sun$enterprise$security$auth$login$CertificateLoginModule);
    private static KeyStore ks = null;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean debug = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private String alias;
    private X509Certificate certificate;
    private PrincipalImpl userPrincipal;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$CertificateLoginModule;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        this.init();
    }

    private void init() {
        try {
            if (ks == null) {
                SSLUtils.initKeyStore();
            }
        }
        catch (Exception e10) {
            e10.printStackTrace();
        }
    }

    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        try {
            String[] as2 = new String[ks.size()];
            String[] aliasString = new String[ks.size()];
            Enumeration<String> aliases = ks.aliases();
            int i2 = 0;
            while (i2 < ks.size()) {
                aliasString[i2] = aliases.nextElement();
                as2[i2] = ((X509Certificate)ks.getCertificate(aliasString[i2])).getSubjectDN().getName();
                ++i2;
            }
            Callback[] callbacks = new Callback[]{new ChoiceCallback(localStrings.getLocalString("login.certificate", "Choose from list of certificates: "), as2, 0, false)};
            this.callbackHandler.handle(callbacks);
            String[] choices = ((ChoiceCallback)callbacks[0]).getChoices();
            int[] idx = ((ChoiceCallback)callbacks[0]).getSelectedIndexes();
            if (choices == null) {
                // empty if block
            }
            if (idx == null) {
                throw new LoginException("No certificate selected!");
            }
            if (idx[0] == -1) {
                throw new LoginException("Incorrect keystore password");
            }
            if (this.debug) {
                System.out.print("\t\t[CertificateLoginModule] user entered certificate: ");
                int i3 = 0;
                while (i3 < idx.length) {
                    System.out.print(aliasString[idx[i3]]);
                    ++i3;
                }
                System.out.println();
            }
            boolean check = true;
            check = this.authenticate(this.username, aliasString);
            if (check) {
                if (this.debug) {
                    System.out.println("\t\t[CertificateLoginModule] authentication succeeded");
                }
                this.succeeded = true;
                return true;
            }
            if (this.debug) {
                System.out.println("\t\t[CertificateLoginModule] authentication failed");
            }
            this.succeeded = false;
            this.username = null;
            throw new FailedLoginException("Authentication failed");
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication information " + "from the user");
        }
        catch (Exception e10) {
            throw new LoginException(e10.toString());
        }
    }

    private boolean authenticate(String user, String[] alias) {
        LoginContext lc = new LoginContext();
        lc.setRealmName("certificate");
        lc.setAuthenticationMethod("certificate");
        try {
            this.certificate = (X509Certificate)ks.getCertificate(alias[0]);
            this.alias = alias[0];
            this.username = alias[0];
            lc.login(this.alias, this.certificate.getEncoded());
        }
        catch (Exception le) {
            le.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        this.userPrincipal = new PrincipalImpl(this.username);
        if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
            this.subject.getPrincipals().add(this.userPrincipal);
        }
        if (this.debug) {
            System.out.println("\t\t[CertificateLoginModule] added PrincipalImpl to Subject");
        }
        String realm = "certificate";
        X509Certificate[] certChain = new X509Certificate[]{this.certificate};
        X509CertificateCredential pc = new X509CertificateCredential(certChain, this.alias, realm);
        if (!this.subject.getPrivateCredentials().contains(pc)) {
            this.subject.getPrivateCredentials().add(pc);
        }
        this.username = null;
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            this.userPrincipal = null;
        } else {
            this.logout();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.succeeded = false;
        this.succeeded = this.commitSucceeded;
        this.username = null;
        this.userPrincipal = null;
        return true;
    }

    public static void setKeyStore(KeyStore keyStore) {
        ks = keyStore;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

