/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.ExecutionContext;
import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.security.LoginContext;
import com.sun.enterprise.security.auth.Credentials;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import java.io.Serializable;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.security.auth.Subject;

public abstract class SecurityContext
implements Serializable {
    private static final String SECURITY_CONTEXT_ID = "SecurityContext";
    private static SecurityContext defaultSecurityContext = null;
    private boolean SERVER_GENERATED_SECURITY_CONTEXT = false;
    static /* synthetic */ Class class$com$sun$enterprise$security$SecurityContext;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$PasswordCredential;

    public static SecurityContext init() {
        SecurityContext sc = SecurityContext.getCurrent();
        if (sc == null) {
            if (defaultSecurityContext == null) {
                SecurityContext.generateDefaultSecurityContext();
            }
            SecurityContext.setCurrent(defaultSecurityContext);
        }
        return sc;
    }

    public static void setUnauthenticatedContext() {
        if (defaultSecurityContext == null) {
            SecurityContext.generateDefaultSecurityContext();
        }
        SecurityContext.setCurrent(defaultSecurityContext);
    }

    private static void generateDefaultSecurityContext() {
        String PRINCIPAL_NAME = "auth.default.principal.name";
        String PRINCIPAL_PASS = "auth.default.principal.password";
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        String username = config.getProperty("auth.default.principal.name", "guest");
        String password = config.getProperty("auth.default.principal.password", "guest123");
        Class clazz = class$com$sun$enterprise$security$SecurityContext == null ? (class$com$sun$enterprise$security$SecurityContext = SecurityContext.class$("com.sun.enterprise.security.SecurityContext")) : class$com$sun$enterprise$security$SecurityContext;
        synchronized (clazz) {
            try {
                final Subject fs = new Subject();
                final PasswordCredential pc = new PasswordCredential(username, password, "default");
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        fs.getPrivateCredentials().add(pc);
                        return null;
                    }
                });
                LoginContext lc = new LoginContext();
                lc.login(fs, class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (class$com$sun$enterprise$security$auth$login$PasswordCredential = SecurityContext.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : class$com$sun$enterprise$security$auth$login$PasswordCredential);
                defaultSecurityContext = SecurityContext.getCurrent();
                defaultSecurityContext.setServerGeneratedCredentials();
                SecurityContext.setCurrent(null);
            }
            catch (Exception e10) {
                // empty catch block
            }
        }
    }

    public static void reset(SecurityContext sc) {
        SecurityContext.setCurrent(sc);
    }

    public static SecurityContext getCurrent() {
        Hashtable current = ExecutionContext.getContext();
        SecurityContext sc = (SecurityContext)current.get(SECURITY_CONTEXT_ID);
        return sc;
    }

    public static void setCurrent(SecurityContext sc) {
        Hashtable current = ExecutionContext.getContext();
        if (sc != null) {
            current.put(SECURITY_CONTEXT_ID, sc);
        } else {
            current.remove(SECURITY_CONTEXT_ID);
        }
    }

    public boolean didServerGenerateCredentials() {
        return this.SERVER_GENERATED_SECURITY_CONTEXT;
    }

    private void setServerGeneratedCredentials() {
        this.SERVER_GENERATED_SECURITY_CONTEXT = true;
    }

    public abstract Principal getCallerPrincipal();

    public abstract Credentials getCredentials();

    public abstract Subject getSubject();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

