/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.iiop.IIOPSSLSocketFactory;
import com.sun.enterprise.security.KeyTool;
import com.sun.enterprise.security.auth.login.CertificateLoginModule;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Utility;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.web.security.SSLSocketFactory;
import java.io.File;
import java.io.FileInputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Properties;

public final class SSLUtils {
    private static boolean debug;
    private static final String defaultKeyStore;
    private static final String defaultTrustStore;
    private static final String defaultKeyStorePass = "changeit";
    private static final String defaultTrustStorePass = "changeit";
    private static final String keystoreProp = "com.sun.enterprise.keyStore";
    private static final String truststoreProp = "javax.net.ssl.trustStore";
    private static final String keystorePassProp = "com.sun.enterprise.keyStorePass";
    private static final String truststorePassProp = "com.sun.enterprise.trustStorePass";
    private static final String SECURE_PROPERTIES = "security.properties";
    private static final String KEYSTORE_PASS = "keyStorePass";
    private static final String TRUSTSTORE_PASS = "trustStorePass";
    private static LocalStringManagerImpl localStrings;
    private static Object keyIndex;
    private static Object trustIndex;
    static /* synthetic */ Class class$com$sun$enterprise$security$SSLUtils;

    public static void initKeyStore() throws Exception {
        String keyfile = System.getProperty(keystoreProp);
        if (keyfile == null) {
            throw new GeneralSecurityException(localStrings.getLocalString("enterprise.security.setKeyStoreException", "Keystore file not specified. Please set the com.sun.enterprise.keyStore property"));
        }
        String trustfile = System.getProperty(truststoreProp, defaultTrustStore);
        String keypass = SSLUtils.getKeyStorePass();
        String trustpass = SSLUtils.getTrustStorePass();
        if (debug) {
            System.out.println(" Loading keyfile = " + keyfile + " keypass =" + keypass);
        }
        KeyStore ks = SSLUtils.loadKS("JKS", keyfile, keypass);
        KeyManagerFactory kmf = SSLUtils.loadKeyStore(ks, keypass);
        KeyStore ts = SSLUtils.loadKS("JKS", trustfile, trustpass);
        TrustManagerFactory tmf = SSLUtils.loadTrustStore(ts);
        if (debug) {
            System.out.println(" keyfile = " + keyfile);
        }
        IIOPSSLSocketFactory.setFactories(kmf, tmf);
        SSLSocketFactory.setFactories(kmf, tmf);
        CertificateLoginModule.setKeyStore(ks);
    }

    public static String getKeyStorePass() {
        String ret = System.getProperty(keystorePassProp);
        if (ret != null) {
            return ret;
        }
        try {
            Properties cprops = Utility.getPropertiesFromFile(SECURE_PROPERTIES);
            String cs2 = cprops.getProperty(KEYSTORE_PASS);
            if (cs2 != null) {
                return cs2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ret = "changeit";
        return ret;
    }

    public static String getTrustStorePass() {
        String ret = System.getProperty(truststorePassProp);
        if (ret != null) {
            return ret;
        }
        try {
            Properties cprops = Utility.getPropertiesFromFile(SECURE_PROPERTIES);
            String cs2 = cprops.getProperty(TRUSTSTORE_PASS);
            if (cs2 != null) {
                return cs2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ret = "changeit";
        return ret;
    }

    public static KeyManagerFactory loadKeyStore(KeyStore ks, String keyPass) throws Exception {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(ks, keyPass.toCharArray());
        return kmf;
    }

    public static TrustManagerFactory loadTrustStore(KeyStore ks) throws Exception {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(ks);
        return tmf;
    }

    private static KeyStore loadKS(String keystoreType, String keystoreFile, String keyPass) throws Exception {
        KeyStore ks = KeyStore.getInstance(keystoreType);
        FileInputStream istream = new FileInputStream(keystoreFile);
        if (debug) {
            System.out.println("Loading key store file:" + keystoreFile);
        }
        char[] passphrase = keyPass.toCharArray();
        ks.load(new FileInputStream(keystoreFile), passphrase);
        istream.close();
        return ks;
    }

    public static boolean isClientKeyStoreAvailable() {
        String keyfile = System.getProperty(keystoreProp, defaultKeyStore);
        File f2 = new File(keyfile);
        return f2.exists();
    }

    public static String getKeyStoreProp() {
        return keystoreProp;
    }

    public static String getDefaultKeyStoreName() {
        return defaultKeyStore;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        KeyTool.initProvider();
        debug = false;
        defaultKeyStore = System.getProperty("com.sun.enterprise.home") + File.separator + "lib" + File.separator + "security" + File.separator + "keystore.jks";
        defaultTrustStore = System.getProperty("com.sun.enterprise.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts.jks";
        localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$security$SSLUtils == null ? (class$com$sun$enterprise$security$SSLUtils = SSLUtils.class$("com.sun.enterprise.security.SSLUtils")) : class$com$sun$enterprise$security$SSLUtils);
        keyIndex = new Object();
        trustIndex = new Object();
    }
}

