/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.iiop.security.AnonCredential;
import com.sun.enterprise.iiop.security.GSSUPName;
import com.sun.enterprise.security.AuthenticationServer;
import com.sun.enterprise.security.LoginException;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.application.EJBSecurityContext;
import com.sun.enterprise.security.auth.AuthenticationStatus;
import com.sun.enterprise.security.auth.Authenticator;
import com.sun.enterprise.security.auth.Credentials;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import com.sun.enterprise.security.auth.login.X509CertificateCredential;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.Utility;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import sun.security.x509.X500Name;

public class LoginContext {
    private static final boolean debug = false;
    private static final int MAX_COUNT = 5;
    private Authenticator authenticator = null;
    private Credentials credentials = null;
    private Subject subject = null;
    private String realmName = "default";
    private String authMethod = "password";
    private String userName = null;
    private SecurityContext securityContext = null;
    private int type = 0;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$security$LoginContext == null ? (class$com$sun$enterprise$security$LoginContext = LoginContext.class$("com.sun.enterprise.security.LoginContext")) : class$com$sun$enterprise$security$LoginContext);
    static /* synthetic */ Class class$com$sun$enterprise$security$LoginContext;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$PasswordCredential;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$Authenticator;

    public LoginContext() throws LoginException {
        try {
            if (ORBManager.getORB() == null) {
                new InitialContext();
            }
            this.init();
        }
        catch (Exception e10) {
            e10.printStackTrace();
            throw new LoginException(e10.getMessage());
        }
    }

    private void init() throws RemoteException, NamingException {
        int cnt = 0;
        while (cnt < 5) {
            try {
                this.authenticator = this.lookupAuthenticator();
                break;
            }
            catch (NameNotFoundException e10) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++cnt;
            }
        }
        if (cnt == 5) {
            throw new NamingException("Cannot look up authenticator");
        }
        this.credentials = this.authenticator.initAuthentication();
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public void setAuthenticationMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public void login(String username, String password) throws LoginException {
        final Subject s2 = new Subject();
        final PasswordCredential pc = new PasswordCredential(username, password, this.realmName);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                s2.getPrivateCredentials().add(pc);
                return null;
            }
        });
        this.subject = s2;
        this.loginUser(username, password);
    }

    public void loginUser(String username, String password) throws LoginException {
        this.login(username, password.getBytes());
    }

    public void login(String username, byte[] authData) throws LoginException {
        AuthenticationStatus astatus = null;
        this.userName = username;
        try {
            if (this.authenticator == null && this.credentials == null) {
                this.init();
            }
            if ((astatus = this.authenticator.authenticate(this.userName, this.realmName, this.authMethod, authData, this.credentials)) == null || astatus.getStatus() != 0) {
                throw new LoginException(astatus);
            }
        }
        catch (LoginException le) {
            throw le;
        }
        catch (Exception e10) {
            e10.printStackTrace();
            throw new LoginException(e10.getMessage());
        }
        this.setSecurityContext();
    }

    public void login(Subject subject, Class cls) throws LoginException {
        this.subject = subject;
        Set credset = null;
        final Subject fs = subject;
        credset = cls.equals(class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (class$com$sun$enterprise$security$auth$login$PasswordCredential = LoginContext.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : class$com$sun$enterprise$security$auth$login$PasswordCredential) ? (Set)AccessController.doPrivileged(new PrivilegedAction(){
            static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$PasswordCredential;

            public Object run() {
                return fs.getPrivateCredentials(class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (class$com$sun$enterprise$security$auth$login$PasswordCredential = 2.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : class$com$sun$enterprise$security$auth$login$PasswordCredential);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }) : subject.getPublicCredentials(cls);
        Iterator iter = credset.iterator();
        while (iter.hasNext()) {
            String user;
            Object obj = iter.next();
            if (obj instanceof PasswordCredential) {
                PasswordCredential p2 = (PasswordCredential)obj;
                user = p2.getUser();
                String pwd = p2.getPassword();
                this.loginUser(user, pwd);
                continue;
            }
            if (obj instanceof X509CertificateCredential) {
                X509CertificateCredential xp = (X509CertificateCredential)obj;
                user = xp.getAlias();
                X509Certificate[] c10 = xp.getX509CertificateChain();
                try {
                    byte[] certBytes = c10[0].getEncoded();
                    this.login(user, certBytes);
                    continue;
                }
                catch (CertificateEncodingException e10) {
                    e10.printStackTrace();
                    throw new LoginException(e10.getMessage());
                }
            }
            if (obj instanceof AnonCredential) {
                SecurityContext.setUnauthenticatedContext();
                continue;
            }
            String user2 = "";
            if (obj instanceof GSSUPName) {
                user2 = ((GSSUPName)obj).getUser();
            } else if (obj instanceof X500Name) {
                user2 = ((X500Name)obj).getName();
            }
            this.userName = user2;
            this.loginWithNoPassword(user2);
        }
    }

    public void loginPrincipal(String username) throws LoginException {
        final Subject s2 = new Subject();
        final GSSUPName name = new GSSUPName(username, this.realmName);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                s2.getPublicCredentials().add(name);
                return null;
            }
        });
        this.subject = s2;
        this.loginWithNoPassword(username);
    }

    public void loginPrincipalForWebRunAs(String username) throws LoginException {
        final Subject s2 = new Subject();
        final GSSUPName name = new GSSUPName(username, this.realmName);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                s2.getPublicCredentials().add(name);
                return null;
            }
        });
        this.subject = s2;
        this.loginWithNoPasswordForWebRunAs(username);
    }

    private void loginWithNoPassword(String username) throws LoginException {
        AuthenticationStatus astatus = null;
        this.userName = username;
        try {
            if (this.authenticator == null && this.credentials == null) {
                this.init();
            }
            if ((astatus = this.authenticator.authenticateWithNoPassword(this.userName, this.realmName, this.authMethod, this.credentials)) == null || astatus.getStatus() != 0) {
                throw new LoginException(astatus);
            }
        }
        catch (LoginException le) {
            throw le;
        }
        catch (Exception e10) {
            e10.printStackTrace();
            throw new LoginException(e10.getMessage());
        }
        this.setSecurityContext();
    }

    private void loginWithNoPasswordForWebRunAs(String username) throws LoginException {
        AuthenticationStatus astatus = null;
        this.userName = username;
        try {
            if (this.authenticator == null && this.credentials == null) {
                this.init();
            }
            if ((astatus = this.authenticator.authenticateWithNoPassword(this.userName, this.realmName, this.authMethod, this.credentials)) == null || astatus.getStatus() != 0) {
                throw new LoginException(astatus);
            }
        }
        catch (LoginException le) {
            throw le;
        }
        catch (Exception e10) {
            e10.printStackTrace();
            throw new LoginException(e10.getMessage());
        }
        this.securityContext = new EJBSecurityContext(this.userName, this.credentials, this.subject);
        SecurityContext.setCurrent(this.securityContext);
    }

    public void logout() throws LoginException {
        try {
            block4: {
                try {
                    if (this.authenticator == null || this.credentials == null) break block4;
                    this.authenticator.destroyCredentials(this.credentials);
                }
                catch (RemoteException re) {
                    throw new LoginException(re.getMessage());
                }
            }
            Object var3_1 = null;
            this.authenticator = null;
            this.credentials = null;
            this.unsetSecurityContext();
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.authenticator = null;
            this.credentials = null;
            this.unsetSecurityContext();
            throw throwable;
        }
    }

    public void continueLogin(String moreInfo) throws LoginException {
        this.continueLogin(moreInfo.getBytes());
    }

    public void continueLogin(byte[] authData) throws LoginException {
        AuthenticationStatus astatus = null;
        try {
            astatus = this.authenticator.continueAuthentication(authData, this.credentials);
            if (astatus == null || astatus.getStatus() != 0) {
                throw new LoginException(astatus);
            }
        }
        catch (LoginException le) {
            throw le;
        }
        catch (Exception e10) {
            throw new LoginException(e10.getMessage());
        }
        this.setSecurityContext();
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    protected Authenticator getAuthenticator() {
        return this.authenticator;
    }

    private void setSecurityContext() {
        if (this.securityContext == null) {
            this.securityContext = new EJBSecurityContext(this.userName, this.credentials, this.subject);
            SecurityContext.setCurrent(this.securityContext);
        }
    }

    public void clear() {
        this.unsetSecurityContext();
    }

    public void authenticate(String username, String password) throws LoginException {
        AuthenticationStatus astatus = null;
        try {
            if (this.authenticator == null && this.credentials == null) {
                this.init();
            }
            if ((astatus = this.authenticator.authenticate(username, this.realmName, this.authMethod, password.getBytes(), this.credentials)) == null || astatus.getStatus() != 0) {
                throw new LoginException(astatus);
            }
        }
        catch (LoginException le) {
            throw le;
        }
        catch (Exception e10) {
            e10.printStackTrace();
            throw new LoginException(e10.getMessage());
        }
    }

    private void unsetSecurityContext() {
        this.securityContext = null;
        SecurityContext.setCurrent(null);
    }

    private void setType(int type) {
        this.type = type;
    }

    private Authenticator lookupAuthenticator() throws NamingException {
        return (Authenticator)Utility.lookupObject(AuthenticationServer.AUTH_SERVICE_NAME, class$com$sun$enterprise$security$auth$Authenticator == null ? (class$com$sun$enterprise$security$auth$Authenticator = LoginContext.class$("com.sun.enterprise.security.auth.Authenticator")) : class$com$sun$enterprise$security$auth$Authenticator);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

