/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.internal.core.IOR;
import com.sun.enterprise.iiop.POAEJBORB;
import com.sun.enterprise.iiop.security.SecurityContext;
import com.sun.enterprise.iiop.security.SecurityMechanismException;
import com.sun.enterprise.iiop.security.SecurityMechanismSelector;
import com.sun.enterprise.iiop.security.SecurityService;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.security.LoginContext;
import com.sun.enterprise.util.ORBManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.omg.CORBA.Object;

public class SecurityServiceImpl
implements SecurityService {
    private static final boolean debug = false;

    public SecurityContext getSecurityContext(Object effective_target) {
        SecurityContext context = null;
        POAEJBORB orb = (POAEJBORB)ORBManager.getORB();
        IOR ior = orb.getIOR(effective_target);
        if (ior.isLocal()) {
            return null;
        }
        try {
            SecurityMechanismSelector sms = new SecurityMechanismSelector();
            context = sms.selectSecurityContext(ior);
        }
        catch (SecurityMechanismException sme) {
            Log.err.println(sme);
            throw new RuntimeException(sme.getMessage());
        }
        return context;
    }

    public void receivedReply(int reply_status, Object effective_target) {
        if (reply_status == 1) {
            System.out.println("Failed status");
            throw new RuntimeException("Target did not accept security context");
        }
        if (reply_status == 2) {
            // empty if block
        }
    }

    public int setSecurityContext(SecurityContext context) {
        SecurityContext ssc = null;
        Class cls = null;
        try {
            Subject s2 = null;
            SecurityMechanismSelector sms = new SecurityMechanismSelector();
            ssc = sms.evaluateTrust(context);
            if (ssc == null) {
                return 0;
            }
            cls = ssc.authcls != null ? ssc.authcls : ssc.identcls;
            s2 = ssc.subject;
            this.authenticate(s2, cls);
        }
        catch (Exception e10) {
            Log.err.println(e10);
            return 1;
        }
        return 0;
    }

    public void sendingReply(SecurityContext context) {
    }

    private void authenticate(Subject s2, Class cls) throws SecurityMechanismException {
        try {
            final LoginContext lc = new LoginContext();
            final Subject fs = s2;
            final Class cl2 = cls;
            AccessController.doPrivileged(new PrivilegedAction(){

                public java.lang.Object run() {
                    lc.login(fs, cl2);
                    return null;
                }
            });
        }
        catch (Exception e10) {
            Log.err.println(e10);
            throw new SecurityMechanismException("Cannot login user:" + e10.getMessage());
        }
    }
}

