/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.connection.EndPointInfo;
import com.sun.corba.ee.internal.core.IOR;
import com.sun.corba.ee.internal.ior.IIOPAddress;
import com.sun.corba.ee.org.omg.CSIIOP.AS_ContextSec;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMech;
import com.sun.corba.ee.org.omg.CSIIOP.SAS_ContextSec;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.appclient.AppContainer;
import com.sun.enterprise.iiop.CSIV2TaggedComponentInfo;
import com.sun.enterprise.iiop.EndPointInfoImpl;
import com.sun.enterprise.iiop.POAEJBORB;
import com.sun.enterprise.iiop.SSL;
import com.sun.enterprise.iiop.security.AnonCredential;
import com.sun.enterprise.iiop.security.ConnectionContext;
import com.sun.enterprise.iiop.security.ConnectionExecutionContext;
import com.sun.enterprise.iiop.security.GSSUPName;
import com.sun.enterprise.iiop.security.SecurityContext;
import com.sun.enterprise.iiop.security.SecurityMechanismException;
import com.sun.enterprise.iiop.security.ServerConnectionContext;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.TypeUtil;
import com.sun.enterprise.util.Utility;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.cert.X509Certificate;
import sun.security.x509.X500Name;

public final class SecurityMechanismSelector {
    private static final String SECURE_PROPERTIES = "security.properties";
    private static final String SEND_PASSWORD = "client.sendpassword";
    private static final String CLIENT_TRUSTED_HOSTS = "client.trustedhosts";
    private static final String SERVER_TRUSTED_HOSTS = "server.trustedhosts";
    public static final String CLIENT_CONNECTION_CONTEXT = "ClientConnContext";
    public static final String SERVER_CONNECTION_CONTEXT = "ServerConnContext";
    private static final boolean debug = false;
    private static final String USE_SSL = "com.sun.enterprise.useSSL";
    private static final String NAMESERVICE_KEY = "com.sun.enterprise.nameServiceKey";
    private static boolean sendPassword = false;
    private static String[] clientTrustedHosts = null;
    private static String[] serverTrustedHosts = null;
    private static Hashtable clientAuthMapping = new Hashtable();
    private static boolean useSSL = false;
    private static String nameServiceKey;
    private static LocalStringManagerImpl localStrings;
    private CompoundSecMech mech = null;
    private POAEJBORB orb = (POAEJBORB)ORBManager.getORB();
    private CSIV2TaggedComponentInfo ctc = new CSIV2TaggedComponentInfo(this.orb);
    static /* synthetic */ Class class$com$sun$enterprise$iiop$security$SecServerRequestInterceptor;
    static /* synthetic */ Class class$com$sun$enterprise$iiop$security$GSSUPName;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$PasswordCredential;
    static /* synthetic */ Class class$com$sun$enterprise$iiop$security$AnonCredential;
    static /* synthetic */ Class class$sun$security$x509$X500Name;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$X509CertificateCredential;

    public ServerConnectionContext getServerConnectionContext() {
        Hashtable h2 = ConnectionExecutionContext.getContext();
        ServerConnectionContext scc = (ServerConnectionContext)h2.get(SERVER_CONNECTION_CONTEXT);
        return scc;
    }

    public void setServerConnectionContext(ServerConnectionContext scc) {
        Hashtable h2 = ConnectionExecutionContext.getContext();
        h2.put(SERVER_CONNECTION_CONTEXT, scc);
    }

    public ConnectionContext getClientConnectionContext() {
        Hashtable h2 = ConnectionExecutionContext.getContext();
        ConnectionContext scc = (ConnectionContext)h2.get(CLIENT_CONNECTION_CONTEXT);
        return scc;
    }

    public void setClientConnectionContext(ConnectionContext scc) {
        Hashtable h2 = ConnectionExecutionContext.getContext();
        h2.put(CLIENT_CONNECTION_CONTEXT, scc);
    }

    public EndPointInfo getSSLPort(IOR ior, ConnectionContext ctx) {
        if (this.isNameServiceIOR(ior)) {
            if (!useSSL) {
                return null;
            }
            IIOPAddress addr = ior.getProfile().getTemplate().getPrimaryAddress();
            EndPointInfoImpl info = new EndPointInfoImpl("SSL", addr.getHost(), addr.getPort());
            return info;
        }
        EndPointInfoImpl info = null;
        try {
            this.mech = this.selectSecurityMechanism(ior);
        }
        catch (SecurityMechanismException sme) {
            throw new RuntimeException(sme.getMessage());
        }
        ctx.setIOR(ior);
        ctx.setMechanism(this.mech);
        if (this.mech == null) {
            return null;
        }
        SSL ssl = this.ctc.getSSLInformation(this.mech);
        this.debug("SSL tagged component:" + ssl);
        if (ssl == null) {
            return null;
        }
        int targetRequires = ssl.getTargetRequires();
        int targetSupports = ssl.getTargetSupports();
        if (this.isSet(targetRequires, 2) || this.isSet(targetRequires, 4) || this.isSet(targetRequires, 64)) {
            this.debug("Target requires SSL");
            ctx.setSSLUsed(true);
            String type = "SSL";
            if (this.isSet(targetRequires, 64)) {
                type = "SSL_MUTUALAUTH";
                ctx.setSSLClientAuthenticationOccurred(true);
            }
            info = new EndPointInfoImpl(type, "", ssl.getPort());
            return info;
        }
        if (this.isSet(targetSupports, 2) || this.isSet(targetSupports, 4) || this.isSet(targetSupports, 64)) {
            this.debug("Target supports SSL");
            if (this.clientPrefersSSL(ior)) {
                this.debug("Client is configured to use SSL for the target");
                ctx.setSSLUsed(true);
                info = new EndPointInfoImpl("SSL", "", ssl.getPort());
                return info;
            }
            return null;
        }
        return null;
    }

    private boolean isNameServiceIOR(IOR ior) {
        byte[] objKey = ior.getProfile().getObjectId().getId();
        String strKey = new String(objKey);
        return strKey.equals("NameService") || strKey.equals("INIT") || strKey.equals(nameServiceKey);
    }

    private boolean clientPrefersSSL(IOR ior) {
        return useSSL;
    }

    public SecurityContext selectSecurityContext(IOR ior) throws SecurityMechanismException {
        SecurityContext context = null;
        ConnectionContext cc2 = this.getClientConnectionContext();
        if (cc2 == null) {
            return null;
        }
        this.mech = cc2.getMechanism();
        if (this.mech == null) {
            return null;
        }
        boolean sslUsed = cc2.getSSLUsed();
        boolean clientAuthOccurred = cc2.getSSLClientAuthenticationOccurred();
        InvocationManager im = Switch.getSwitch().getInvocationManager();
        if (im == null) {
            context = this.getSecurityContextForAppClient(null, sslUsed, clientAuthOccurred);
            return context;
        }
        this.debug("SSL used:" + sslUsed + " SSL Mutual auth:" + clientAuthOccurred);
        ComponentInvocation ci2 = null;
        try {
            ci2 = im.getCurrentInvocation();
        }
        catch (InvocationException ie) {
            return null;
        }
        Object obj = ci2.getContainerContext();
        context = obj instanceof AppContainer ? this.getSecurityContextForAppClient(ci2, sslUsed, clientAuthOccurred) : this.getSecurityContextForWebOrEJB(ci2, sslUsed, clientAuthOccurred);
        return context;
    }

    public SecurityContext getSecurityContextForAppClient(ComponentInvocation ci2, boolean sslUsed, boolean clientAuthOccurred) throws SecurityMechanismException {
        SecurityContext ctx = null;
        boolean plainIIOP = true;
        if (!sslUsed) {
            ctx = this.sendUsernameAndPassword(plainIIOP, ci2);
        } else if (!clientAuthOccurred) {
            plainIIOP = false;
            ctx = this.sendUsernameAndPassword(plainIIOP, ci2);
        } else {
            return null;
        }
        return ctx;
    }

    public SecurityContext getSecurityContextForWebOrEJB(ComponentInvocation ci2, boolean sslUsed, boolean clientAuthOccurred) throws SecurityMechanismException {
        SecurityContext ctx = null;
        boolean plainIIOP = true;
        boolean sslClientAuth = false;
        if (!sslUsed) {
            ctx = this.propagateIdentity(plainIIOP, sslClientAuth, ci2);
        } else if (!clientAuthOccurred) {
            plainIIOP = false;
            ctx = this.propagateIdentity(plainIIOP, sslClientAuth, ci2);
        } else {
            plainIIOP = false;
            sslClientAuth = true;
            ctx = this.propagateIdentity(plainIIOP, sslClientAuth, ci2);
        }
        return ctx;
    }

    private SecurityContext sendUsernameAndPassword(boolean plainIIOP, ComponentInvocation ci2) throws SecurityMechanismException {
        SecurityContext ctx = null;
        if (this.mech == null) {
            return null;
        }
        AS_ContextSec asContext = this.mech.as_context_mech;
        if (!this.isSet(asContext.target_requires, 64)) {
            return null;
        }
        ctx = this.setUsernameAndPassword(plainIIOP, ci2);
        this.debug("Sending Username/Password");
        return ctx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SecurityContext propagateIdentity(boolean plainIIOP, boolean clientAuth, ComponentInvocation ci2) throws SecurityMechanismException {
        SecurityContext ctx = null;
        if (this.mech == null) {
            return null;
        }
        AS_ContextSec asContext = this.mech.as_context_mech;
        SAS_ContextSec sasContext = this.mech.sas_context_mech;
        this.debug("SAS CONTEXT's target_requires=" + sasContext.target_requires);
        this.debug("SAS CONTEXT's target_supports=" + sasContext.target_supports);
        if (this.isSet(asContext.target_requires, 64)) {
            ctx = this.setUsernameAndPassword(plainIIOP, ci2);
            if (ctx.authcls != null) return ctx;
            String errmsg = localStrings.getLocalString("securitymechansimselector.runas_cannot_propagate_username_password", "Cannot propagate username/password required by target when using run as identity");
            Log.err.println(errmsg);
            throw new SecurityMechanismException(errmsg);
        }
        if (this.isSet(sasContext.target_supports, 1024)) return this.getIdentity();
        if (this.isSet(sasContext.target_requires, 1024)) {
            return this.getIdentity();
        }
        if (!this.isSet(asContext.target_supports, 64)) return null;
        if (!clientAuth) return null;
        ctx = this.setUsernameAndPassword(plainIIOP, ci2);
        if (ctx.authcls != null) return ctx;
        return null;
    }

    private SecurityContext setUsernameAndPassword(boolean plainIIOP, ComponentInvocation ci2) throws SecurityMechanismException {
        SecurityContext ctx = null;
        if (plainIIOP && sendPassword && this.isServerTrusted()) {
            ctx = this.getUsernameAndPassword(ci2);
        } else if (!plainIIOP && this.isServerTrusted()) {
            ctx = this.getUsernameAndPassword(ci2);
        } else {
            String msg = "Cannot send authentication information because ";
            msg = plainIIOP && !sendPassword ? msg + " client policy does not allow password to " + " be sent over plain IIOP" : msg + " client does not trust the server " + " to send password over IIOP";
            this.debug(msg);
            throw new SecurityMechanismException(msg);
        }
        return ctx;
    }

    private boolean isServerTrusted() {
        String star = "*";
        int i2 = 0;
        while (i2 < serverTrustedHosts.length) {
            if (serverTrustedHosts[i2].length() == 1 && serverTrustedHosts[i2].equals(star)) {
                return true;
            }
            ++i2;
        }
        ConnectionContext scc = this.getClientConnectionContext();
        if (scc != null) {
            Socket skt = scc.getSocket();
            InetAddress adr = skt.getInetAddress();
            return this.isDomainInTrustedList(adr, serverTrustedHosts);
        }
        return false;
    }

    private boolean isDomainInTrustedList(InetAddress inetAddress, String[] trusted) throws SecurityException {
        boolean isTrusted = false;
        String domain = null;
        String star = "*";
        String dot = ".";
        try {
            domain = inetAddress.getHostName();
        }
        catch (Exception e10) {
            System.err.println(" Could not lookup the domain name of IP  address = " + inetAddress.getHostAddress());
            return false;
        }
        this.debug(" Verifying if domain address =" + inetAddress.toString() + " is in the Trusted list ");
        this.debug(" the domain name is = " + domain);
        String[] domainTok = TypeUtil.stringToArray(domain, dot);
        int i2 = 0;
        while (i2 < trusted.length) {
            String[] toksList = TypeUtil.stringToArray(trusted[i2], dot);
            if (toksList.length != domainTok.length) {
                isTrusted = false;
            } else {
                int j2 = toksList.length - 1;
                while (j2 >= 0) {
                    if (toksList[j2].equals(domainTok[j2])) {
                        isTrusted = true;
                    } else if (toksList[j2].equals(star)) {
                        isTrusted = true;
                    } else {
                        isTrusted = false;
                        break;
                    }
                    --j2;
                }
                if (isTrusted) {
                    return isTrusted;
                }
            }
            ++i2;
        }
        return isTrusted;
    }

    private SecurityContext getUsernameAndPassword(ComponentInvocation ci2) throws SecurityMechanismException {
        try {
            Subject s2 = null;
            if (ci2 == null) {
                com.sun.enterprise.security.SecurityContext sc = com.sun.enterprise.security.SecurityContext.getCurrent();
                if (sc == null) {
                    return null;
                }
                s2 = sc.getSubject();
                this.debug("SUBJECT:" + s2);
            } else {
                Object obj = ci2.getContainerContext();
                if (obj instanceof AppContainer) {
                    AppContainer ac2 = (AppContainer)obj;
                    LoginContext lc = ac2.getLoginContext(1);
                    com.sun.enterprise.security.SecurityContext sc = com.sun.enterprise.security.SecurityContext.getCurrent();
                    if (sc == null) {
                        lc.login();
                        s2 = lc.getSubject();
                    } else {
                        s2 = sc.getSubject();
                    }
                } else {
                    s2 = this.getSubjectFromSecurityCurrent();
                }
            }
            SecurityContext ctx = new SecurityContext();
            final Subject sub = s2;
            ctx.subject = s2;
            Set privateCredSet = (Set)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return sub.getPrivateCredentials();
                }
            });
            if (privateCredSet.isEmpty()) {
                this.debug("no private credential run as mode");
                ctx.authcls = null;
                ctx.identcls = class$com$sun$enterprise$iiop$security$GSSUPName == null ? (class$com$sun$enterprise$iiop$security$GSSUPName = SecurityMechanismSelector.class$("com.sun.enterprise.iiop.security.GSSUPName")) : class$com$sun$enterprise$iiop$security$GSSUPName;
            } else {
                ctx.authcls = class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (class$com$sun$enterprise$security$auth$login$PasswordCredential = SecurityMechanismSelector.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : class$com$sun$enterprise$security$auth$login$PasswordCredential;
            }
            return ctx;
        }
        catch (Exception e10) {
            e10.printStackTrace();
            return null;
        }
    }

    private SecurityContext getIdentity() throws SecurityMechanismException {
        Subject s2;
        SecurityContext ctx;
        this.debug("Getting PRINCIPAL/DN from TLS");
        final SecurityContext sCtx = ctx = new SecurityContext();
        com.sun.enterprise.security.SecurityContext scontext = com.sun.enterprise.security.SecurityContext.getCurrent();
        if (scontext == null || scontext.didServerGenerateCredentials()) {
            sCtx.identcls = class$com$sun$enterprise$iiop$security$AnonCredential == null ? (class$com$sun$enterprise$iiop$security$AnonCredential = SecurityMechanismSelector.class$("com.sun.enterprise.iiop.security.AnonCredential")) : class$com$sun$enterprise$iiop$security$AnonCredential;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Subject sub;
                    sCtx.subject = sub = new Subject();
                    sCtx.subject.getPublicCredentials().add(new AnonCredential());
                    return null;
                }
            });
            return sCtx;
        }
        ctx.subject = s2 = this.getSubjectFromSecurityCurrent();
        final Subject sub = s2;
        Set credSet = (Set)AccessController.doPrivileged(new PrivilegedAction(){
            static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$PasswordCredential;

            public Object run() {
                return sub.getPrivateCredentials(class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (class$com$sun$enterprise$security$auth$login$PasswordCredential = 3.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : class$com$sun$enterprise$security$auth$login$PasswordCredential);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
        if (credSet.size() == 1) {
            Subject subj;
            ctx.identcls = class$com$sun$enterprise$iiop$security$GSSUPName == null ? (class$com$sun$enterprise$iiop$security$GSSUPName = SecurityMechanismSelector.class$("com.sun.enterprise.iiop.security.GSSUPName")) : class$com$sun$enterprise$iiop$security$GSSUPName;
            final Set cs2 = credSet;
            ctx.subject = subj = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Subject ss = new Subject();
                    Iterator iter = cs2.iterator();
                    PasswordCredential pc = (PasswordCredential)iter.next();
                    GSSUPName gssname = new GSSUPName(pc.getUser(), pc.getRealm());
                    ss.getPublicCredentials().add(gssname);
                    return ss;
                }
            });
            return ctx;
        }
        credSet = s2.getPublicCredentials();
        if (credSet.size() != 1) {
            System.err.println("Principal propagation: Cannot find principal information in subject");
            return null;
        }
        Iterator credIter = credSet.iterator();
        if (credIter.hasNext()) {
            Object o2 = credIter.next();
            ctx.identcls = o2 instanceof GSSUPName ? (class$com$sun$enterprise$iiop$security$GSSUPName == null ? (class$com$sun$enterprise$iiop$security$GSSUPName = SecurityMechanismSelector.class$("com.sun.enterprise.iiop.security.GSSUPName")) : class$com$sun$enterprise$iiop$security$GSSUPName) : (o2 instanceof X500Name ? (class$sun$security$x509$X500Name == null ? (class$sun$security$x509$X500Name = SecurityMechanismSelector.class$("sun.security.x509.X500Name")) : class$sun$security$x509$X500Name) : (class$com$sun$enterprise$security$auth$login$X509CertificateCredential == null ? (class$com$sun$enterprise$security$auth$login$X509CertificateCredential = SecurityMechanismSelector.class$("com.sun.enterprise.security.auth.login.X509CertificateCredential")) : class$com$sun$enterprise$security$auth$login$X509CertificateCredential));
        } else {
            System.err.println("Principal propagation: Cannot find credential information in subject. ");
            return null;
        }
        return ctx;
    }

    private Subject getSubjectFromSecurityCurrent() throws SecurityMechanismException {
        com.sun.enterprise.security.SecurityContext sc = null;
        sc = com.sun.enterprise.security.SecurityContext.getCurrent();
        if (sc == null) {
            System.out.println(" SETTING GUEST ---");
            com.sun.enterprise.security.SecurityContext.init();
            sc = com.sun.enterprise.security.SecurityContext.getCurrent();
        }
        if (sc == null) {
            throw new SecurityMechanismException("Could not find  security information");
        }
        Subject s2 = sc.getSubject();
        if (s2 == null) {
            throw new SecurityMechanismException("Could not find  subject information in the security context.");
        }
        this.debug("Subject in security current:" + s2);
        return s2;
    }

    private CompoundSecMech selectSecurityMechanism(IOR ior) throws SecurityMechanismException {
        CompoundSecMech[] mechList = this.ctc.getSecurityMechanisms(ior);
        CompoundSecMech mech = this.selectSecurityMechanism(mechList);
        return mech;
    }

    private CompoundSecMech selectSecurityMechanism(CompoundSecMech[] mechList) throws SecurityMechanismException {
        if (mechList == null || mechList.length == 0) {
            return null;
        }
        CompoundSecMech mech = null;
        int i2 = 0;
        while (i2 < mechList.length) {
            mech = mechList[i2];
            boolean useMech = this.useMechanism(mech);
            if (useMech) {
                return mech;
            }
            ++i2;
        }
        throw new SecurityMechanismException("Cannot use any of the  target's supported mechanisms");
    }

    private boolean useMechanism(CompoundSecMech mech) {
        boolean val = true;
        SSL ssl = this.ctc.getSSLInformation(mech);
        if (ssl == null) {
            return true;
        }
        int targetRequires = ssl.getTargetRequires();
        if (this.isSet(targetRequires, 64) && !SSLUtils.isClientKeyStoreAvailable()) {
            val = false;
        }
        return val;
    }

    public SecurityContext evaluateTrust(SecurityContext ctx) throws SecurityMechanismException {
        SecurityContext ssc = null;
        Socket s2 = null;
        ServerConnectionContext scc = this.getServerConnectionContext();
        if (scc != null) {
            s2 = scc.getSocket();
        }
        if (ctx == null) {
            ssc = new SecurityContext();
            if (s2 == null) {
                return null;
            }
            if (!(s2 instanceof SSLSocket)) {
                com.sun.enterprise.security.SecurityContext.setUnauthenticatedContext();
                return null;
            }
            SSLSocket sslSock = (SSLSocket)s2;
            SSLSession sslSession = sslSock.getSession();
            X509Certificate[] certChain = null;
            try {
                certChain = sslSession.getPeerCertificateChain();
            }
            catch (Exception e10) {
                com.sun.enterprise.security.SecurityContext.setUnauthenticatedContext();
                return null;
            }
            X500Name x500Name = (X500Name)certChain[0].getSubjectDN();
            ssc.subject = new Subject();
            ssc.subject.getPublicCredentials().add(x500Name);
            ssc.identcls = class$sun$security$x509$X500Name == null ? (class$sun$security$x509$X500Name = SecurityMechanismSelector.class$("sun.security.x509.X500Name")) : class$sun$security$x509$X500Name;
            ssc.authcls = null;
            return ssc;
        }
        ssc = ctx;
        Class authCls = ctx.authcls;
        Class identCls = ctx.identcls;
        ssc.subject = ctx.subject;
        String msg = "Trust evaluation failed because ";
        if (authCls == null && identCls == null) {
            msg = msg + "client authentication token and identity token are " + "both null";
            throw new SecurityMechanismException(msg);
        }
        if (authCls != null && identCls != null) {
            ssc.identcls = identCls;
            ssc.authcls = null;
        } else if (identCls != null) {
            ssc.identcls = identCls;
            ssc.authcls = null;
        } else {
            ssc.authcls = authCls;
            ssc.identcls = null;
        }
        return ssc;
    }

    private boolean isSet(int val1, int val2) {
        return (val1 & val2) == val2;
    }

    private void debug(String msg) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$iiop$security$SecServerRequestInterceptor == null ? (class$com$sun$enterprise$iiop$security$SecServerRequestInterceptor = SecurityMechanismSelector.class$("com.sun.enterprise.iiop.security.SecServerRequestInterceptor")) : class$com$sun$enterprise$iiop$security$SecServerRequestInterceptor);
        Properties props = null;
        try {
            String sth;
            String cth;
            props = Utility.getPropertiesFromFile(SECURE_PROPERTIES);
            String sp = props.getProperty(SEND_PASSWORD);
            if (sp != null && !sp.trim().equals("")) {
                sendPassword = new Boolean(sp);
            }
            if ((cth = props.getProperty(CLIENT_TRUSTED_HOSTS)) != null && !cth.trim().equals("")) {
                clientTrustedHosts = TypeUtil.stringToArray(cth, ",");
            }
            if ((sth = props.getProperty(SERVER_TRUSTED_HOSTS)) != null && !sth.trim().equals("")) {
                serverTrustedHosts = TypeUtil.stringToArray(sth, ",");
            }
            useSSL = new Boolean(System.getProperty(USE_SSL));
            nameServiceKey = System.getProperty(NAMESERVICE_KEY);
        }
        catch (IOException e10) {
            e10.printStackTrace();
        }
    }
}

