/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.MessageBeanContainer;
import com.sun.ejb.containers.MessageBeanHelper;
import com.sun.ejb.containers.ServerSessionPoolImpl;
import com.sun.enterprise.jms.SessionWrapper;
import com.sun.enterprise.log.Log;
import com.sun.jms.spi.ServerSession;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ServerSessionPool;
import javax.jms.Session;

public class ServerSessionImpl
implements ServerSession {
    private static final boolean debug = false;
    private boolean inUse_ = false;
    private Session session_ = null;
    private MessageListener listener_ = null;
    private ServerSessionPool pool_ = null;
    private MessageBeanHelper helper_ = null;
    private MessageBeanContainer container_ = null;

    public ServerSessionImpl(MessageBeanHelper helper, MessageBeanContainer container, ServerSessionPool pool) throws Exception {
        this.helper_ = helper;
        this.container_ = container;
        this.pool_ = pool;
    }

    public Session getSession() throws JMSException {
        if (this.session_ == null) {
            try {
                this.session_ = this.helper_.createSession();
                this.listener_ = this.container_.createMessageDrivenEJBListener(this.session_);
                this.session_.setMessageListener(this.listener_);
            }
            catch (Exception e10) {
                Log.err.println(e10);
                this.cleanup();
                JMSException je = new JMSException("ServerSession get error");
                je.setLinkedException(e10);
                throw je;
            }
        }
        this.inUse_ = true;
        return ((SessionWrapper)this.session_).getDelegate();
    }

    public void start() throws JMSException {
        throw new JMSException("Not supported");
    }

    public void close() {
        this.inUse_ = false;
        ((ServerSessionPoolImpl)this.pool_).release(this);
    }

    public void beforeMessageDelivery(Message message) {
        this.container_.beforeMessageDelivery(message, this.listener_);
    }

    public void afterMessageDelivery(Message message) {
        this.container_.afterMessageDelivery(message, this.listener_);
    }

    void cleanup() {
        try {
            if (this.listener_ != null) {
                this.container_.destroyMessageDrivenEJBListener(this.listener_);
                this.listener_ = null;
            }
        }
        catch (Exception e10) {
            this.listener_ = null;
            Log.err.println(e10);
        }
        try {
            if (this.session_ != null) {
                this.session_.close();
                this.session_ = null;
            }
        }
        catch (Exception e11) {
            this.session_ = null;
            Log.err.println(e11);
        }
    }
}

