/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.ejb.codegen.GeneratorDriver;
import com.sun.ejb.codegen.GeneratorException;
import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import sun.rmi.rmic.IndentingWriter;

public abstract class Generator {
    protected static final boolean debug = true;
    protected String ejbClassSymbol;

    public abstract String getGeneratedClass();

    public abstract void generate(OutputStream var1) throws GeneratorException, IOException;

    protected String getPackageName(String className) {
        int dot = className.lastIndexOf(46);
        if (dot == -1) {
            return null;
        }
        return className.substring(0, dot);
    }

    protected String getBaseName(String className) {
        int dot = className.lastIndexOf(46);
        if (dot == -1) {
            return className;
        }
        return className.substring(dot + 1);
    }

    protected String printType(Class cls) {
        if (cls.isArray()) {
            return this.printType(cls.getComponentType()) + "[]";
        }
        return cls.getName();
    }

    protected Method[] removeDups(Method[] orig) {
        Vector<Method> nodups = new Vector<Method>();
        int i2 = 0;
        while (i2 < orig.length) {
            Method m1 = orig[i2];
            boolean dup = false;
            Enumeration e10 = nodups.elements();
            while (e10.hasMoreElements()) {
                Class<?>[] m2parms;
                Class<?>[] m1parms;
                Method m2 = (Method)e10.nextElement();
                if (!m1.getName().equals(m2.getName()) || (m1parms = m1.getParameterTypes()).length != (m2parms = m2.getParameterTypes()).length) continue;
                boolean parmsDup = true;
                int j2 = 0;
                while (j2 < m2parms.length) {
                    if (m1parms[j2] != m2parms[j2]) {
                        parmsDup = false;
                        break;
                    }
                    ++j2;
                }
                if (!parmsDup) continue;
                dup = true;
                if (!m2.getDeclaringClass().isAssignableFrom(m1.getDeclaringClass())) break;
                nodups.remove(m2);
                nodups.add(m1);
                break;
            }
            if (!dup) {
                nodups.add(m1);
            }
            ++i2;
        }
        return nodups.toArray(new Method[nodups.size()]);
    }

    protected String[] printStaticMethodInit(IndentingWriter p2, Class genClass, Method[] methods) throws IOException {
        if (methods == null || methods.length == 0) {
            return new String[0];
        }
        String[] methodVars = new String[methods.length];
        int i2 = 0;
        while (i2 < methods.length) {
            String methodVar;
            methodVars[i2] = methodVar = this.getUniqueMethodVar(methodVars, "__Method__" + methods[i2].getName(), 0);
            p2.pln("private static java.lang.reflect.Method " + methodVar + ";");
            ++i2;
        }
        p2.plnI("static {");
        p2.plnI("try {");
        p2.pln("java.lang.Class[] cl;");
        int i3 = 0;
        while (i3 < methods.length) {
            Class<?>[] params = methods[i3].getParameterTypes();
            p2.pln("cl = new java.lang.Class[" + params.length + "];");
            int j2 = 0;
            while (j2 < params.length) {
                p2.pln("cl[" + j2 + "] = " + this.printType(params[j2]) + ".class;");
                ++j2;
            }
            p2.pln(methodVars[i3] + " = " + genClass.getName() + ".class.getMethod(\"" + methods[i3].getName() + "\", cl);");
            ++i3;
        }
        p2.pOln("} catch(NoSuchMethodException e) {}");
        p2.pOln("}");
        return methodVars;
    }

    private String getUniqueMethodVar(String[] existingNames, String newName, int count) {
        boolean exists = false;
        String name = newName;
        if (count > 0) {
            name = newName + count;
        }
        int i2 = 0;
        while (i2 < existingNames.length) {
            String existingName = existingNames[i2];
            if (existingName != null && existingName.equals(name)) {
                exists = true;
                break;
            }
            ++i2;
        }
        if (exists) {
            return this.getUniqueMethodVar(existingNames, newName, ++count);
        }
        return name;
    }

    protected String getUniqueClassName(String origName, String origSuffix, Vector existingFiles) {
        String newClassName = null;
        boolean foundUniqueName = false;
        int count = 0;
        while (!foundUniqueName) {
            String fileName;
            String suffix = origSuffix;
            if (count > 0) {
                suffix = origSuffix + count;
            }
            if (!existingFiles.contains(fileName = GeneratorDriver.getFileName(newClassName = origName + suffix))) {
                foundUniqueName = true;
                continue;
            }
            ++count;
        }
        return newClassName;
    }

    protected String getTxAttribute(EjbDescriptor dd2, Method method) {
        if (dd2 instanceof EjbSessionDescriptor && ((EjbSessionDescriptor)dd2).getTransactionType().equals("Bean")) {
            return "TX_BEAN_MANAGED";
        }
        String txAttr = null;
        MethodDescriptor mdesc = new MethodDescriptor(method);
        mdesc.setEjbClassSymbol(this.ejbClassSymbol);
        ContainerTransaction ct2 = dd2.getContainerTransactionFor(mdesc);
        if (ct2 != null) {
            String attr = ct2.getTransactionAttribute();
            if (attr.equals(ContainerTransaction.NOT_SUPPORTED)) {
                txAttr = "TX_NOT_SUPPORTED";
            } else if (attr.equals(ContainerTransaction.SUPPORTS)) {
                txAttr = "TX_SUPPORTS";
            } else if (attr.equals(ContainerTransaction.REQUIRED)) {
                txAttr = "TX_REQUIRED";
            } else if (attr.equals(ContainerTransaction.REQUIRES_NEW)) {
                txAttr = "TX_REQUIRES_NEW";
            } else if (attr.equals(ContainerTransaction.MANDATORY)) {
                txAttr = "TX_MANDATORY";
            } else if (attr.equals(ContainerTransaction.NEVER)) {
                txAttr = "TX_NEVER";
            }
        }
        if (txAttr == null) {
            throw new RuntimeException("Transaction Attribute not found for method " + method);
        }
        return txAttr;
    }

    protected String getSecurityAttribute(EjbDescriptor dd2, Method m2) {
        Set excluded;
        MethodDescriptor thisMethodDesc = new MethodDescriptor(m2);
        thisMethodDesc.setEjbClassSymbol(this.ejbClassSymbol);
        Set unchecked = dd2.getUncheckedMethodDescriptors();
        if (unchecked != null) {
            Iterator i2 = unchecked.iterator();
            while (i2.hasNext()) {
                MethodDescriptor md = (MethodDescriptor)i2.next();
                if (!thisMethodDesc.equals(md)) continue;
                return "SEC_UNCHECKED";
            }
        }
        if ((excluded = dd2.getExcludedMethodDescriptors()) != null) {
            Iterator i3 = excluded.iterator();
            while (i3.hasNext()) {
                MethodDescriptor md = (MethodDescriptor)i3.next();
                if (!thisMethodDesc.equals(md)) continue;
                return "SEC_EXCLUDED";
            }
        }
        return "SEC_CHECKED";
    }
}

