/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.core;

import com.sun.corba.ee.internal.core.IOR;
import com.sun.corba.ee.internal.core.ORB;
import com.sun.corba.ee.internal.core.ORBVersionImpl;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class GIOPVersion {
    public static final GIOPVersion V1_0 = new GIOPVersion(1, 0);
    public static final GIOPVersion V1_1 = new GIOPVersion(1, 1);
    public static final GIOPVersion V1_2;
    public static final GIOPVersion DEFAULT_VERSION;
    public static final int VERSION_1_0 = 256;
    public static final int VERSION_1_1 = 257;
    public static final int VERSION_1_2 = 258;
    public byte major = 0;
    public byte minor = 0;

    public GIOPVersion() {
    }

    public GIOPVersion(byte by2, byte by3) {
        this.major = by2;
        this.minor = by3;
    }

    public GIOPVersion(int n2, int n3) {
        this.major = (byte)n2;
        this.minor = (byte)n3;
    }

    public byte getMajor() {
        return this.major;
    }

    public byte getMinor() {
        return this.minor;
    }

    public boolean equals(GIOPVersion gIOPVersion) {
        return gIOPVersion.major == this.major && gIOPVersion.minor == this.minor;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof GIOPVersion) {
            return this.equals((GIOPVersion)object);
        }
        return false;
    }

    public boolean lessThan(GIOPVersion gIOPVersion) {
        if (this.major < gIOPVersion.major) {
            return true;
        }
        return this.major == gIOPVersion.major && this.minor < gIOPVersion.minor;
    }

    public int intValue() {
        return this.major << 8 | this.minor;
    }

    public String toString() {
        return this.major + "." + this.minor;
    }

    public static GIOPVersion getInstance(byte by2, byte by3) {
        switch (by2 << 8 | by3) {
            case 256: {
                return V1_0;
            }
            case 257: {
                return V1_1;
            }
            case 258: {
                return V1_2;
            }
        }
        return new GIOPVersion(by2, by3);
    }

    public static GIOPVersion parseVersion(String string) {
        int n2 = string.indexOf(46);
        if (n2 < 1 || n2 == string.length() - 1) {
            throw new NumberFormatException("GIOP major, minor, and decimal point required: " + string);
        }
        int n3 = Integer.parseInt(string.substring(0, n2));
        int n4 = Integer.parseInt(string.substring(n2 + 1, string.length()));
        return GIOPVersion.getInstance((byte)n3, (byte)n4);
    }

    public static GIOPVersion chooseRequestVersion(ORB oRB, IOR iOR) {
        GIOPVersion gIOPVersion = oRB.getGIOPVersion();
        GIOPVersion gIOPVersion2 = iOR.getGIOPVersion();
        ORBVersionImpl oRBVersionImpl = (ORBVersionImpl)iOR.getORBVersion();
        if (!oRBVersionImpl.equals(ORBVersionImpl.FOREIGN) && oRBVersionImpl.lessThan(ORBVersionImpl.NEWER)) {
            return V1_0;
        }
        byte by2 = gIOPVersion2.getMajor();
        byte by3 = gIOPVersion2.getMinor();
        byte by4 = gIOPVersion.getMajor();
        byte by5 = gIOPVersion.getMinor();
        if (by4 < by2) {
            return gIOPVersion;
        }
        if (by4 > by2) {
            return gIOPVersion2;
        }
        if (by5 <= by3) {
            return gIOPVersion;
        }
        return gIOPVersion2;
    }

    public void read(InputStream inputStream) {
        this.major = inputStream.read_octet();
        this.minor = inputStream.read_octet();
    }

    public void write(OutputStream outputStream) {
        outputStream.write_octet(this.major);
        outputStream.write_octet(this.minor);
    }

    static {
        DEFAULT_VERSION = V1_2 = new GIOPVersion(1, 2);
    }
}

