/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.tool;

import java.net.URL;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class Resources {
    private static Resources sResources = null;
    private static Hashtable listImages;
    private static final String BUNDLE_NAME = "com/sap/sdb/syncMan/tool/toolres";
    private static final ResourceBundle RESOURCE_BUNDLE;

    public Resources() {
        listImages = new Hashtable();
    }

    public static synchronized void createInstance() {
        if (sResources != null) {
            throw new IllegalStateException("Resources singleton already created.");
        }
        sResources = new Resources();
    }

    public static synchronized void destroyInstance() {
        if (sResources == null) {
            throw new IllegalStateException("Resources singleton not created.");
        }
        listImages.clear();
        listImages = null;
        sResources = null;
    }

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public static Image getImage(String imageName) {
        Image img = (Image)listImages.get(imageName);
        if (img == null) {
            URL imageURL = Resources.class.getResource("/com/sap/sdb/syncMan/gui/images/" + imageName + ".gif");
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)imageURL);
            img = desc.createImage();
            listImages.put(imageName, img);
        }
        return img;
    }

    static {
        RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);
    }
}

