/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.design;

import com.sap.sdb.syncMan.design.Column;
import com.sap.sdb.syncMan.design.ColumnGroup;
import com.sap.sdb.syncMan.design.DesignSQLLayer;
import com.sap.sdb.syncMan.design.SchemaNode;
import com.sap.sdb.syncMan.design.SyncTable;
import com.sap.sdb.syncMan.design.UnitTable;
import com.sap.sdb.syncMan.tool.ConDataBase;
import com.sap.sdb.syncMan.util.GenUID;
import java.util.Enumeration;
import java.util.Vector;

public class ReplicationTable
extends SyncTable {
    public static final long DUMMY_PARTICIPANT_ID = -1L;
    private ColumnGroup _singleColumnGroup = new ColumnGroup("Single Columns", -1L);
    private ColumnGroup _keyColumnGroup = new ColumnGroup("Key Columns", -2L);
    private ColumnGroup _versionedGroup;
    private transient SchemaNode _schemaNode;

    public ReplicationTable(long tableID, String server, String database, String schema, String name) {
        super(tableID, server, database, schema, name);
        this._keyColumnGroup.setKeyCols(true);
        this._versionedGroup = null;
    }

    public void removeColumnGroup(ColumnGroup colGroup) throws Exception {
        boolean bRemoved = this._columnGroups.remove(colGroup);
        if (bRemoved) {
            if (this._versionedGroup != null && colGroup.equals(this._versionedGroup)) {
                this._versionedGroup = null;
            }
            Enumeration enumCol = colGroup.columns();
            while (enumCol.hasMoreElements()) {
                Column col = (Column)enumCol.nextElement();
                this._singleColumnGroup.addColumn(col);
            }
        } else {
            throw new Exception("Column Group not in Design Table");
        }
    }

    public void addColumn(Column col) throws Exception {
        if (col.keyPos() > 0) {
            this._keyColumnGroup.addColumn(col);
        } else {
            this._singleColumnGroup.addColumn(col);
        }
    }

    public void assignColumnToColumnGroup(ColumnGroup cg, Column col) throws Exception {
        if (this.getColumnGroupByName(cg.columnGroupName()) == null) {
            throw new Exception("Column Group not in Design Table");
        }
        if (this._keyColumnGroup.containsColumn(col)) {
            throw new Exception("Column is already in primary key group");
        }
        if (cg.containsColumn(col)) {
            throw new Exception("Column is already in group");
        }
        this._singleColumnGroup.removeColumn(col);
        if (!(col.sqlType() != -4 && col.sqlType() != -1 || this._versionedGroup != null && cg.equals(this._versionedGroup))) {
            throw new Exception("Adding blob column to a not versioned Column Group");
        }
        cg.addColumn(col);
    }

    public void withdrawColumnFromColumnGroup(ColumnGroup cg, Column col) throws Exception {
        if (this.getColumnGroupByName(cg.columnGroupName()) == null) {
            throw new Exception("Column Group not in Design Table");
        }
        if (this._keyColumnGroup.columnGroupName().equals(cg.columnGroupName()) && this._keyColumnGroup.containsColumn(col)) {
            throw new Exception("Column from primary key group cannot be removed");
        }
        if (!cg.containsColumn(col)) {
            throw new Exception("Column is not in column group");
        }
        if ((col.sqlType() == -4 || col.sqlType() == -1) && this._versionedGroup != null && cg.equals(this._versionedGroup)) {
            throw new Exception("Removing blob column from a versioned Column Group");
        }
        cg.removeColumn(col);
        this._singleColumnGroup.addColumn(col);
    }

    public int addColumnGroup(ColumnGroup cg) throws Exception {
        if (cg.columnGroupID() == -1L) {
            this._singleColumnGroup = cg;
            return -1;
        }
        if (cg.columnGroupID() == -2L) {
            this._keyColumnGroup = cg;
            return -1;
        }
        if (cg.columnGroupName().equals("Key Columns")) {
            throw new Exception("Column Group has reserved word: Key Columns");
        }
        if (cg.columnGroupName().equals("Single Columns")) {
            throw new Exception("Column Group has reserved word: Single Columns");
        }
        if (this.getColumnGroupByName(cg.columnGroupName()) != null) {
            throw new Exception("Column Group already in Design Table");
        }
        cg.setForReplication(true);
        int i = 0;
        for (i = 0; i < this._columnGroups.size() && cg.columnGroupName().compareTo(((ColumnGroup)this._columnGroups.get(i)).columnGroupName()) >= 0; ++i) {
        }
        this._columnGroups.add(i, cg);
        return i;
    }

    public ColumnGroup versionedColumnGroup() {
        return this._versionedGroup;
    }

    public ColumnGroup singleColumnGroup() {
        return this._singleColumnGroup;
    }

    public ColumnGroup keyColumnGroup() {
        return this._keyColumnGroup;
    }

    private void setSingleColumnGroup(ColumnGroup cg) {
        this._singleColumnGroup = cg;
    }

    private void setKeyColumnGroup(ColumnGroup cg) {
        this._keyColumnGroup = cg;
    }

    public UnitTable createUnitTable(long designID, long participantID) throws Exception {
        long tableID = GenUID.getNext();
        UnitTable table = new UnitTable(designID, participantID, this._tableID, tableID, this._host, this._dataBase, this._schema, this._name, false);
        table.addColumnGroup(this._keyColumnGroup.cloneColumnGroup());
        Enumeration enumCGS = this._columnGroups.elements();
        while (enumCGS.hasMoreElements()) {
            ColumnGroup cg = (ColumnGroup)enumCGS.nextElement();
            if (cg.columnCount() < 1) {
                throw new Exception("Empty Column Group " + cg.columnGroupName() + " not allowed.");
            }
            table.addColumnGroup(cg.cloneColumnGroup());
        }
        Enumeration enumCG = this._singleColumnGroup.columns();
        while (enumCG.hasMoreElements()) {
            Column col = (Column)enumCG.nextElement();
            long columnID = GenUID.getNext();
            ColumnGroup cg = new ColumnGroup(col.columnName(), columnID);
            cg.addColumn(col);
            table.addColumnGroup(cg);
        }
        return table;
    }

    public String toString() {
        return this._name;
    }

    public ColumnGroup getColumnGroup(int index) {
        return (ColumnGroup)this._columnGroups.get(index);
    }

    public ColumnGroup getColumnGroupByName(String colGroupName) {
        for (int i = 0; i < this._columnGroups.size(); ++i) {
            if (!((ColumnGroup)this._columnGroups.get(i)).columnGroupName().equalsIgnoreCase(colGroupName)) continue;
            return (ColumnGroup)this._columnGroups.get(i);
        }
        return null;
    }

    public void loadColumnGroups(ConDataBase dbCon) throws Exception {
        Vector temp = DesignSQLLayer.selectColumnGroupsOfTable(dbCon, -1L, this._tableID);
        int removeSingleCols = -1;
        int removeKeyCols = -1;
        for (int i = 0; i < temp.size(); ++i) {
            ColumnGroup cg = (ColumnGroup)temp.get(i);
            if (cg.columnGroupID() == -1L) {
                this.setSingleColumnGroup(cg);
                removeSingleCols = i;
            } else if (cg.columnGroupID() == -2L) {
                this.setKeyColumnGroup(cg);
                removeKeyCols = i;
            } else {
                this.addColumnGroup(cg);
            }
            if (!cg.versioned()) continue;
            this.setVersionedColumnGroup(cg, true);
        }
        if (removeKeyCols > 0) {
            temp.remove(removeKeyCols);
            --removeSingleCols;
        }
        if (removeSingleCols > 0) {
            temp.remove(removeSingleCols);
        }
    }

    public void setVersionedColumnGroup(ColumnGroup cg, boolean versioned) throws Exception {
        boolean contains = this._columnGroups.contains(cg);
        if (!contains) {
            throw new Exception("Column Group " + cg.columnGroupName() + " not in Design Table");
        }
        if (versioned) {
            if (this._versionedGroup != null) {
                throw new Exception("Column Group " + this._versionedGroup.columnGroupName() + " already versioned");
            }
            this._versionedGroup = cg;
            cg.setVersioned(true);
        } else {
            if (this._versionedGroup == null || !cg.equals(this._versionedGroup)) {
                throw new Exception("Column Group " + cg.columnGroupName() + " not versioned");
            }
            if (cg.containsBlobColumn()) {
                throw new Exception("Column Group " + cg.columnGroupName() + " contains blob column");
            }
            cg.setVersioned(false);
            this._versionedGroup = null;
        }
    }

    public SchemaNode getParent() {
        return this._schemaNode;
    }

    public void setParent(SchemaNode schemaNode) {
        this._schemaNode = schemaNode;
    }
}

