/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.design;

import com.sap.sdb.syncMan.design.DesignSQLLayer;
import com.sap.sdb.syncMan.design.ParticipantConfig;
import com.sap.sdb.syncMan.tool.ConDataBase;
import com.sap.sdb.syncMan.util.SQLBuilder;
import java.sql.SQLException;
import java.util.Vector;

public class Participant {
    private transient int _masterParticipantType;
    private boolean _isInstalled;
    private long _designID;
    private long _participantID;
    private boolean _isMaster;
    private String _dataBase;
    private String m_Host;
    private String _user;
    private String _passWord;
    private String _inDest;
    private String _outDest;
    private String _participantName;
    private int _participantType;
    private transient ParticipantConfig _config;

    public Participant(long designID, long participantID, String participantName, int participantType, String host, String database, String user, String passWord, boolean isMaster, boolean isInstalled) {
        this._designID = designID;
        this._participantID = participantID;
        this._participantName = participantName;
        this._participantType = participantType;
        this.m_Host = host;
        if (this.m_Host.length() < 1) {
            this.m_Host = "127.0.0.1";
        }
        this._dataBase = database;
        this._user = user;
        this._passWord = passWord;
        this._isMaster = isMaster;
        this._isInstalled = isInstalled;
        this.makeDestinationNames();
    }

    public String getDataBase() {
        return this._dataBase;
    }

    public long getDesignID() {
        return this._designID;
    }

    public boolean isInstalled() {
        return this._isInstalled;
    }

    public boolean isMaster() {
        return this._isMaster;
    }

    public String getPassWord() {
        return this._passWord;
    }

    public String getUser() {
        return this._user;
    }

    public String getHost() {
        return this.m_Host;
    }

    public void setDataBase(String database) {
        this._dataBase = database;
    }

    public void setIsInstalled(boolean isInstalled) {
        this._isInstalled = isInstalled;
    }

    public void setIsMaster(boolean master) {
        this._isMaster = master;
    }

    public void setPassWord(String password) {
        this._passWord = password != null && password.length() > 0 ? (password.charAt(0) == '\"' ? password : "\"" + password + "\"") : password;
    }

    public void setUser(String user) {
        this._user = user;
    }

    public void setHost(String host) {
        this.m_Host = host == null || host.length() < 1 ? "127.0.0.1" : host;
    }

    public String toString() {
        return this._participantName + ":" + this.m_Host + ";" + this._dataBase + ";" + this._user;
    }

    private void makeDestinationNames() {
        if (this._participantType == 2) {
            if (this._isMaster) {
                this._outDest = SQLBuilder.makeTopicDestName((long)this._designID);
                this._inDest = SQLBuilder.makeQueueDestName((long)this._designID);
            } else {
                this._outDest = SQLBuilder.makeQueueDestName((long)this._designID);
                this._inDest = SQLBuilder.makeTopicDestName((long)this._designID);
            }
        } else if (this._participantType == 1) {
            if (this._isMaster) {
                this._outDest = null;
                this._inDest = SQLBuilder.makeQueueDestName((long)this._designID);
            } else {
                this._outDest = null;
                this._inDest = SQLBuilder.makeTopicDestName((long)this._designID);
            }
        } else if (this._participantType == 0) {
            if (this._isMaster) {
                this._outDest = SQLBuilder.makeTopicDestName((long)this._designID);
                this._inDest = null;
            } else {
                this._inDest = null;
                this._outDest = SQLBuilder.makeQueueDestName((long)this._designID);
            }
        }
    }

    public String getOutDest() {
        return this._outDest;
    }

    public String getInDest() {
        return this._inDest;
    }

    public long getParticipantID() {
        return this._participantID;
    }

    public String getParticipantName() {
        return this._participantName;
    }

    public int getParticipantType() {
        return this._participantType;
    }

    public Vector getTables(ConDataBase con) throws SQLException {
        Vector tables = DesignSQLLayer.selectUnitTables(con, this._designID, this._participantID);
        return tables;
    }

    public void setParticipantName(String participantName) {
        this._participantName = participantName;
    }

    public void setParticipantType(int participantType) {
        this._participantType = participantType;
        this.makeDestinationNames();
    }

    public boolean hasChildren() {
        return this.isMaster();
    }

    public int hashCode() {
        return this._participantName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Participant) {
            return this._participantID == ((Participant)obj)._participantID;
        }
        return false;
    }

    public ParticipantConfig getConfig() {
        return this._config;
    }

    public void setConfig(ParticipantConfig config) {
        this._config = config;
    }

    public int getMasterParticipantType() {
        return this._masterParticipantType;
    }

    public void setMasterParticipantType(int masterParticipantType) {
        this._masterParticipantType = masterParticipantType;
    }
}

