/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.test;

import com.sap.sapdb.benchmark.common.BenchEnv;
import com.sap.sapdb.benchmark.common.BenchmarkException;
import com.sap.sapdb.benchmark.common.NonPersistent;
import com.sap.sapdb.benchmark.common.ServerNode;
import com.sap.sapdb.benchmark.common.Session;
import com.sap.sapdb.benchmark.common.StorableObject;
import com.sap.sapdb.benchmark.common.User;
import com.sap.sapdb.benchmark.tp2.common.AccessType;
import com.sap.sapdb.benchmark.tp2.common.PropertyException;
import com.sap.sapdb.benchmark.tp2.common.Tp2Case;
import com.sap.sapdb.benchmark.tp2.common.Tp2Exception;
import com.sap.sapdb.benchmark.tp2.common.Tp2TestProperties;
import com.sap.sapdb.benchmark.tp2.test.CaseEnv;
import com.sap.sapdb.benchmark.tp2.test.CaseLog;
import com.sap.sapdb.benchmark.tp2.test.CpcExecutableFilter;
import com.sap.sapdb.benchmark.tp2.test.EasyTpBenchmark;
import com.sap.sapdb.benchmark.tp2.test.SingleTest;
import com.sap.sapdb.benchmark.tp2.test.Tp2Env;
import com.sap.sapdb.benchmark.tp2.test.Tp2TestCase;
import com.sap.sapdb.benchmark.tp2.test.TpBenchmark;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.StringTokenizer;

class CaseMonitor
implements CaseEnv {
    private static final File xUserFile = new File(System.getProperty("user.home") + File.separator + ".XUSER.62");
    private static final File tempXUserFile = new File(System.getProperty("user.home") + File.separator + ".XUSER.62.renamedByTp2");
    private static final String DEFAULT_TPBENCHLIB_PACKAGE = "com/sap/sapdb/benchmark/tp2/tpbenchlib/";
    private Tp2Case tp2Case = null;
    private Tp2TestProperties properties = null;
    private CaseLog caseLog = null;
    private TpBenchmark benchmark = null;
    private AccessType currentAccessType;
    private Tp2TestCase testCase = null;
    private Tp2Abort shutdownHook = null;
    static /* synthetic */ Class class$com$sap$sapdb$benchmark$tp2$test$CaseEnv;

    public CaseMonitor(Tp2TestCase testCase) throws Tp2Exception {
        Tp2Env.stdOut("");
        Tp2Env.stdOut("# Starting initialization of the case environment ...");
        this.testCase = testCase;
        this.loadProperties();
        Tp2Env.stdOut("Loaded properties", 10);
        String outputLevelStr = this.getProp("tp2.outputLevel");
        BenchEnv.setOutputLevel(outputLevelStr);
        Tp2Env.stdOut("Output level is set to '" + outputLevelStr + "'");
        if (outputLevelStr.equalsIgnoreCase("debug")) {
            this.setProp("tp2.dataoutputpath", this.getDataOutputPath() + System.getProperty("file.separator"));
            Tp2Env.stdOut("User error protocol is written to :\n" + this.getDataOutputPath() + System.getProperty("file.separator"), 20);
        }
        Tp2Env.stdOut("Set properties :\n" + this.properties.getSetEntriesAsString(), 20);
        String benchmarkSource = this.initBenchmark();
        Tp2Env.stdOut("This case is based on the TP benchmark '" + this.benchmark.getName() + "'");
        this.initResultObjects();
        this.caseLog = new CaseLog(this.tp2Case.getSession().getId(), BenchEnv.getCurrentTimeFormatted(true));
        Tp2Env.stdOut("Case log initialized in file : '" + this.caseLog.getCaseLogFile(), 10);
        this.logCaseHeader(benchmarkSource);
        this.initAccessType();
        Tp2Env.stdOut("SimulatedUser type : " + this.currentAccessType.getCodeStr());
        Tp2Env.stdOut("SimulatedUser type : " + this.currentAccessType.getDescription(), 10);
        this.eventuallySetMaxGlobalDuration();
        if (this.getBooleanProp("tp2.usingTp2Process")) {
            Tp2Env.stdOut("SimulatedUser of type SystemUser will use TP2 specific java.lang.Process", 10);
        }
        if (xUserFile.exists()) {
            xUserFile.renameTo(tempXUserFile);
            Tp2Env.stdOut("Renamed " + xUserFile + " to " + tempXUserFile);
        }
        if (BenchEnv.currentJavaVersionNotUnder("1.3")) {
            if (this.shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            this.shutdownHook = new Tp2Abort();
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            Tp2Env.stdOut("Added shutdown hook Tp2Abort", 10);
        }
        Tp2Env.stdOut("# Finished initialization of the case environment ...\n");
    }

    private void loadProperties() throws PropertyException {
        this.properties = new Tp2TestProperties();
        Iterator allNames = Tp2TestProperties.listAllKeys();
        while (allNames.hasNext()) {
            String key = (String)allNames.next();
            String value = Tp2TestCase.getParameterString((String)key, (String)"DEF_MARK");
            if (value.equals("DEF_MARK")) continue;
            this.properties.setProperty(key, value);
        }
    }

    private String initBenchmark() throws Tp2Exception {
        String benchProp = this.getProp("tp2.benchmark");
        if (benchProp.indexOf(46) >= 0) {
            File confFile = null;
            confFile = benchProp.indexOf(File.separatorChar) >= 0 ? new File(benchProp) : new File(Tp2Env.getTestsHome() + benchProp);
            if (confFile.exists()) {
                this.benchmark = new EasyTpBenchmark((CaseEnv)this, confFile);
                Tp2Env.stdOut("Loaded TpBenchmark from system file " + confFile, 10);
                return confFile.toString() + " [SYSTEM FILE]";
            }
            String ressource = benchProp;
            if (benchProp.indexOf(47) < 0) {
                ressource = DEFAULT_TPBENCHLIB_PACKAGE + benchProp;
            }
            if (ClassLoader.getSystemResource(ressource) != null) {
                this.benchmark = new EasyTpBenchmark((CaseEnv)this, ressource);
                Tp2Env.stdOut("Loaded TpBenchmark from Java classpath file " + ressource, 10);
                return ressource + " [RESSOURCE FILE]";
            }
            throw new Tp2Exception("Could not load " + benchProp + " as EasyBenchmark config file", 3);
        }
        String ressource = benchProp;
        if (benchProp.indexOf("/") < 0) {
            ressource = DEFAULT_TPBENCHLIB_PACKAGE + benchProp;
        }
        try {
            Class<?> clss = Class.forName(ressource);
            Class[] param = new Class[]{class$com$sap$sapdb$benchmark$tp2$test$CaseEnv == null ? (class$com$sap$sapdb$benchmark$tp2$test$CaseEnv = CaseMonitor.class$("com.sap.sapdb.benchmark.tp2.test.CaseEnv")) : class$com$sap$sapdb$benchmark$tp2$test$CaseEnv};
            Constructor<?> constr = clss.getConstructor(param);
            Object[] arg = new Object[]{this};
            this.benchmark = (TpBenchmark)constr.newInstance(arg);
            Tp2Env.stdOut("Loaded (created instance) TpBenchmark as class " + ressource, 10);
            return ressource + " [RESSOURCE CLASS]";
        }
        catch (Exception e) {
            throw new Tp2Exception("Could not load TpBenchmark " + ressource, 3, e);
        }
    }

    private void initResultObjects() throws Tp2Exception {
        try {
            String caseType = null;
            StringTokenizer ST = new StringTokenizer(this.testCase.getClass().getName(), ".");
            while (ST.hasMoreTokens()) {
                caseType = ST.nextToken();
            }
            if (this.getBooleanProp("tp2.results.persistent")) {
                StorableObject.initConnection(this.getProp("tp2.results.dbAddress") + "?user=" + this.getProp("tp2.results.dbUser") + "&password=" + this.getProp("tp2.results.dbPassword"));
            } else {
                StorableObject.setNonPersistent(true);
                NonPersistent.initNonPersistent(Tp2Env.getTp2Home());
                Tp2Env.stdOut("NonPersistent environment initialized", 10);
            }
            this.tp2Case = this.findOrCreateCase(caseType);
            System.out.println("[TP2] Running under Session #" + this.tp2Case.getSession().getId() + " of User " + this.tp2Case.getSession().getUser().getName());
        }
        catch (SQLException e) {
            throw new Tp2Exception("Could not initialize result objects because of " + e, 3, e);
        }
    }

    private Tp2Case findOrCreateCase(String caseType) throws Tp2Exception {
        try {
            User defaultUser = User.findOrCreateUser(this.properties);
            ServerNode serverNode = this.findServerNode();
            Session sess = Session.findOrCreateSession(defaultUser, this.benchmark.getName(), this.properties);
            return Tp2Case.initCase(sess, serverNode, caseType);
        }
        catch (SQLException e) {
            throw new Tp2Exception("Could not find or create a new Tp2Case", 3, e);
        }
        catch (BenchmarkException e) {
            throw new Tp2Exception(e);
        }
    }

    private ServerNode findServerNode() throws Tp2Exception {
        try {
            return ServerNode.getServerNode(this.testCase.getTestDBHostName());
        }
        catch (UnknownHostException e) {
            throw new Tp2Exception("Could not retrieve host name", 4, e);
        }
        catch (SQLException e) {
            throw new Tp2Exception("Could not retrieve host name", 4, e);
        }
    }

    private void logCaseHeader(String benchmarkSource) throws Tp2Exception {
        this.caseLog.log("<Tp2Case sessionId=\"" + this.tp2Case.getSession().getId() + "\"" + " serverNode=\"" + this.tp2Case.getServerNode().getShortHostName() + "\"" + " user=\"" + this.tp2Case.getSession().getUser().getName() + "\"" + " caseType=\"" + this.tp2Case.getCaseType() + "\"" + ">\n");
        this.caseLog.log("<TpBenchmark type=\"" + this.benchmark.getName() + "\" source=\"" + benchmarkSource + "\"/>");
        this.caseLog.log("\t<Tp2Properties>\n");
        Iterator it = this.properties.listSetKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            this.caseLog.log("\t\t<Tp2Property name=\"" + key + "\" value=\"" + this.properties.getProperty(key) + "\"/>\n");
        }
        this.caseLog.log("\t</Tp2Properties>\n");
        this.caseLog.log("</Tp2Case>\n");
    }

    private void initAccessType() throws Tp2Exception {
        if (this.isPropSet("tp2.access.code")) {
            String codeStr = this.getProp("tp2.access.code");
            try {
                int code = Integer.parseInt(codeStr);
                this.currentAccessType = new AccessType(code);
            }
            catch (NumberFormatException e) {
                this.currentAccessType = new AccessType(codeStr);
            }
        } else {
            this.currentAccessType = new AccessType(this.getProp("tp2.access.interface"), this.getProp("tp2.access.transacImpl"), this.getProp("tp2.access.userImpl"));
        }
    }

    private void eventuallySetMaxGlobalDuration() throws Tp2Exception {
        long maxGlobalDuration = -1L;
        if (this.isPropSet("tp2.global.maxDuration")) {
            StringTokenizer ST = new StringTokenizer(this.getProp("tp2.global.maxDuration"), "h");
            long maybeHours = Long.parseLong(ST.nextToken());
            maxGlobalDuration = ST.hasMoreTokens() ? (maybeHours * 60L + Long.parseLong(ST.nextToken())) * 60L * 1000L : maybeHours * 60L * 1000L;
        } else if (this.isPropSet("tp2.global.endTime")) {
            StringTokenizer dayST = new StringTokenizer(this.getProp("tp2.global.endTime"), "d");
            String dayShiftStr = dayST.nextToken();
            int dayShift = 0;
            String timeStr = null;
            try {
                dayShift = Integer.parseInt(dayShiftStr);
                timeStr = dayST.nextToken();
            }
            catch (NumberFormatException e) {
                timeStr = dayShiftStr;
            }
            StringTokenizer hourST = new StringTokenizer(timeStr, "h");
            int hour = Integer.parseInt(hourST.nextToken());
            int minute = Integer.parseInt(hourST.nextToken());
            GregorianCalendar endTime = new GregorianCalendar();
            endTime.add(5, dayShift);
            endTime.set(11, hour);
            endTime.set(12, minute);
            GregorianCalendar now = new GregorianCalendar();
            if (endTime.before(now)) {
                throw new Tp2Exception("Global end time " + BenchEnv.formatTime(endTime.getTime().getTime(), true) + " is before now: " + BenchEnv.formatTime(now.getTime().getTime(), true), 4);
            }
            maxGlobalDuration = endTime.getTime().getTime() - now.getTime().getTime();
        } else {
            return;
        }
        Tp2Env.setMaxGlobalDuration(maxGlobalDuration);
    }

    public ServerNode getServerNode() {
        return this.tp2Case.getServerNode();
    }

    public int getSessionId() {
        return this.tp2Case.getSession().getId();
    }

    public String getCaseTypeWithId() {
        return this.tp2Case.getCaseTypeWithId();
    }

    public AccessType getCurrentAccessType() {
        return this.currentAccessType;
    }

    public TestDatabaseSap getTestDB() {
        CaseMonitor caseMonitor = this;
        return (TestDatabaseSap)caseMonitor.testCase.getDatabase();
    }

    public TpBenchmark getBenchmark() {
        return this.benchmark;
    }

    public String getProp(String key) throws PropertyException {
        return this.properties.getProperty(key);
    }

    public boolean getBooleanProp(String key) throws PropertyException {
        return this.properties.getBooleanProperty(key);
    }

    public boolean isPropSet(String key) throws PropertyException {
        return this.properties.isSet(key);
    }

    public String getNativeLogFilePath(int id) {
        return this.caseLog.getNativeLogFilePath(id);
    }

    public boolean setProp(String key, String value) throws PropertyException {
        this.properties.setProperty(key, value);
        return true;
    }

    public void logError(String cmpnt, String msg, Exception e) {
        this.testCase.addMessage(cmpnt, 'E', msg, e);
        this.caseLog.logError(cmpnt, msg, e);
    }

    public void logWarning(String cmpnt, String msg, Exception e) {
        this.testCase.addMessage(cmpnt, 'W', msg, e);
    }

    public void logWarning(String cmpnt, String msg) {
        this.testCase.addMessage(cmpnt, 'W', msg);
    }

    public void logInfo(String cmpnt, String msg) {
        this.testCase.addMessage(cmpnt, 'I', msg);
    }

    public String executeDBMcmd(String cmd) throws Tp2Exception {
        try {
            return this.getTestDB().executeDBMcmd(cmd);
        }
        catch (TestDatabaseException e) {
            throw new Tp2Exception("DBM Command '" + cmd + "' failed because of " + (Object)((Object)e), 2, (Exception)((Object)e));
        }
    }

    public void checkParams() throws Tp2Exception {
        this.executeDBMcmd("param_startsession");
        this.executeDBMcmd("param_checkall");
        this.executeDBMcmd("param_extgetall");
        this.executeDBMcmd("param_commitsession");
    }

    public String getCompactDBVersion() throws Tp2Exception {
        try {
            String version = this.getTestDB().getKernelVersion();
            String clStr = null;
            StringTokenizer ST = new StringTokenizer(version, ".");
            if (!ST.hasMoreTokens()) {
                throw new TestDatabaseException("Version in bad format: " + version);
            }
            int major = Integer.parseInt(ST.nextToken());
            if (!ST.hasMoreTokens()) {
                throw new TestDatabaseException("Version in bad format: " + version);
            }
            int minor = Integer.parseInt(ST.nextToken());
            if (ST.hasMoreTokens()) {
                int correctionLevel = Integer.parseInt(ST.nextToken());
                clStr = Integer.toString(correctionLevel);
                if (correctionLevel < 10) {
                    clStr = "0" + clStr;
                }
            } else {
                throw new TestDatabaseException("Version in bad format: " + version);
            }
            return major + "" + minor + clStr;
        }
        catch (TestDatabaseException e) {
            throw new Tp2Exception("Problem when extracting database version", 2, (Exception)((Object)e));
        }
    }

    public Connection createTestDBConnection() throws Tp2Exception {
        try {
            return DriverManager.getConnection("jdbc:sapdb://" + this.getServerNode().getHostName() + ":" + this.getTestDB().getPort() + "/" + this.getTestDB().getName(), "bench", "bench");
        }
        catch (SQLException e) {
            throw new Tp2Exception("Could not initialize the connection to test DB because of " + e, 2, e);
        }
    }

    public String getBestCpcExecutable(String cpcExecutablePrefix) throws Tp2Exception {
        String cpcExecutableName = null;
        File tp2Dir = new File(Tp2Env.getTp2Home());
        File[] execList = tp2Dir.listFiles(new CpcExecutableFilter(cpcExecutablePrefix));
        String dbVersion = this.getCompactDBVersion();
        int dbVersionN = new Integer(dbVersion.substring(1));
        int currVersionN = 0;
        for (int i = 0; i < execList.length; ++i) {
            String name = execList[i].getName();
            StringTokenizer ST = new StringTokenizer(name, "_");
            ST.nextToken();
            String version = new StringTokenizer(ST.nextToken(), ".").nextToken().substring(1);
            int versionN = new Integer(version.substring(1));
            if (cpcExecutableName == null) {
                cpcExecutableName = name;
                currVersionN = versionN;
            }
            if (dbVersion.equals(version)) {
                cpcExecutableName = name;
                break;
            }
            if (versionN < dbVersionN && versionN > currVersionN) {
                cpcExecutableName = name;
                currVersionN = versionN;
                continue;
            }
            if (currVersionN <= dbVersionN || versionN >= currVersionN) continue;
            cpcExecutableName = name;
            currVersionN = versionN;
        }
        if (cpcExecutableName == null) {
            throw new Tp2Exception("No CPC executable adapted to the database (version " + dbVersion + " was found)", 3);
        }
        Tp2Env.stdOut("TP2 will use " + cpcExecutableName + " as CPC executable for DB " + dbVersion, 10);
        return cpcExecutableName;
    }

    public String getBestSqldbcExecutable(String sqldbcExecutablePrefix) throws Tp2Exception {
        String sqldbcExecutableName = null;
        File tp2Dir = new File(Tp2Env.getTp2Home());
        File[] execList = tp2Dir.listFiles(new CpcExecutableFilter(sqldbcExecutablePrefix));
        String dbVersion = this.getCompactDBVersion();
        int dbVersionN = new Integer(dbVersion.substring(1));
        int currVersionN = 0;
        for (int i = 0; i < execList.length; ++i) {
            String name = execList[i].getName();
            StringTokenizer ST = new StringTokenizer(name, "_");
            ST.nextToken();
            String version = new StringTokenizer(ST.nextToken(), ".").nextToken().substring(1);
            int versionN = new Integer(version.substring(1));
            if (sqldbcExecutableName == null) {
                sqldbcExecutableName = name;
                currVersionN = versionN;
            }
            if (dbVersion.equals(version)) {
                sqldbcExecutableName = name;
                break;
            }
            if (versionN < dbVersionN && versionN > currVersionN) {
                sqldbcExecutableName = name;
                currVersionN = versionN;
                continue;
            }
            if (currVersionN <= dbVersionN || versionN >= currVersionN) continue;
            sqldbcExecutableName = name;
            currVersionN = versionN;
        }
        if (sqldbcExecutableName == null) {
            throw new Tp2Exception("No SQLDBC executable adapted to the database (version " + dbVersion + " was found)", 3);
        }
        Tp2Env.stdOut("TP2 will use " + sqldbcExecutableName + " as SQLDBC executable for DB " + dbVersion, 10);
        return sqldbcExecutableName;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getDataOutputPath() {
        String jtestRoot = TestDriver.getJTestRoot();
        if (jtestRoot == null) {
            Tp2Env.stdOut("getDataOutputPath:  Can't retrieve $JTEST_ROOT. ", 20);
            return null;
        }
        String myFullName = this.getClass().getName();
        String testDir = null;
        if (myFullName.lastIndexOf(46) != -1) {
            String myClassName = myFullName.substring(myFullName.lastIndexOf(46) + 1);
            String myLastPackageName = myFullName.substring(0, myFullName.length() - (myClassName.length() + 1));
            myLastPackageName = myLastPackageName.substring(myLastPackageName.lastIndexOf(46) + 1);
            testDir = myLastPackageName + File.separator + myClassName;
        } else {
            testDir = myFullName;
        }
        String dataDir = jtestRoot + File.separator + "tests" + File.separator + "output" + File.separator + testDir;
        File fileDataDir = new File(dataDir);
        if (fileDataDir.exists()) {
            if (fileDataDir.isDirectory()) return dataDir;
            Tp2Env.stdErr("getDataOutputPath: Desired data output path <" + dataDir + "> exists, but is a file.");
            return null;
        }
        if (fileDataDir.mkdirs()) {
            Tp2Env.stdOut("getDataOutputPath: Datadir '" + dataDir + "' created.", 20);
            return dataDir;
        }
        Tp2Env.stdErr("getDataOutputPath: Can't create datadir '" + dataDir + "'");
        return null;
    }

    public boolean isUsingTp2Processes() {
        try {
            return this.getBooleanProp("tp2.usingTp2Process");
        }
        catch (PropertyException e) {
            return false;
        }
    }

    public String getCaseLogDir() {
        return Tp2Env.getCaseLogDir(this.tp2Case.getSession().getId());
    }

    public CaseLog getCaseLog() throws Tp2Exception {
        return this.caseLog;
    }

    public void closeCaseRessources() throws Tp2Exception {
        if (tempXUserFile.exists()) {
            if (!xUserFile.exists()) {
                tempXUserFile.renameTo(xUserFile);
                Tp2Env.stdOut("Renamed " + tempXUserFile + " to " + xUserFile);
            } else {
                tempXUserFile.delete();
            }
        }
        this.caseLog.close();
        try {
            StorableObject.closeConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public Tp2Case getTp2Case() {
        return this.tp2Case;
    }

    public void changeCurrentAccessType(AccessType newAccessType) {
        this.currentAccessType = newAccessType;
    }

    public void abortCase(String msg, Exception cause) {
        Tp2Env.stdErr(msg);
        this.logError("Tp2TestCase.abortCase", "ABORT_CASE(" + this.getCaseTypeWithId() + ") " + msg, cause);
        try {
            SingleTest.abort();
        }
        catch (Tp2Exception e) {
            this.logError("CaseMonitor.abortCase", "Problem when aborting", e);
        }
        try {
            if (!this.tp2Case.isFinished()) {
                this.tp2Case.abort();
            }
        }
        catch (Exception e) {
            this.logError("CaseMonitor.abortCase", "Problem when aborting", e);
        }
        this.caseLog.dumpBuffer();
        try {
            this.closeCaseRessources();
        }
        catch (Tp2Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Tp2Abort
    extends Thread {
        public Tp2Abort() {
            super("Tp2Abort");
            this.setPriority(10);
        }

        public void run() {
            if (CaseMonitor.this.tp2Case != null) {
                try {
                    if (!CaseMonitor.this.tp2Case.isFinished()) {
                        Tp2Env.stdErr("\n!!! ABORT !!!");
                        CaseMonitor.this.abortCase("Termination signal was sent - Shutdown hook aborting the test ...", new Tp2Exception("Termination signal was sent. SingleTest aborted by shutdown hook.", 4));
                        Tp2Env.stdOut("Leaving shutdown hook", 20);
                    }
                }
                catch (Tp2Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

