/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.common;

import com.sap.sapdb.benchmark.common.DBDescription;
import com.sap.sapdb.benchmark.common.NonPersistent;
import com.sap.sapdb.benchmark.common.ServerNode;
import com.sap.sapdb.benchmark.common.Session;
import com.sap.sapdb.benchmark.common.StorableObject;
import com.sap.sapdb.benchmark.tp2.common.AccessType;
import com.sap.sapdb.benchmark.tp2.common.Tp2Exception;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import java.util.zip.ZipInputStream;

public class Tp2Result
extends StorableObject {
    private int userCount;
    private int duration;
    private int transactionCount;
    private int errorCount;
    private float tps;
    private float tpsPerUserAverage;
    private float tpsPerUserDeviation;
    private String userType;
    private long ioReads;
    private long ioWrites;
    private ServerNode serverNode = null;
    private DBDescription dbDescription = null;
    private Date testTime = null;
    static /* synthetic */ Class class$com$sap$sapdb$benchmark$tp2$common$Tp2Result;

    public static Tp2Result createTp2Result(ServerNode serverNode, DBDescription dbDescription, int userCount, int duration, String userType, float tps, float tpsPerUserAverage, float tpsPerUserDeviation, int transactionCount, int errorCount, long ioReads, long ioWrites, int sessionId) throws SQLException {
        if (!StorableObject.isNonPersistent()) {
            Statement stmt = Tp2Result.getConnection().createStatement();
            stmt.executeUpdate("INSERT INTO tp2_definitions SET id=tp2_definitions_seq.NEXTVAL,servernode_id=" + serverNode.getId() + "," + "dbdescription_id=" + dbDescription.getId() + "," + "usercount=" + userCount + "," + "duration=" + duration + "," + "user_type='" + userType + "'");
            stmt.executeUpdate("INSERT INTO tp2_results SET def_id=tp2_definitions_seq.CURRVAL,tcount=" + transactionCount + "," + "tps=" + tps + "," + "tpspu_avg=" + tpsPerUserAverage + "," + "tpspu_dev=" + tpsPerUserDeviation + "," + "errors=" + errorCount + "," + "ioreads=" + ioReads + "," + "iowrites=" + ioWrites);
            ResultSet RS = stmt.executeQuery("SELECT id,test_time FROM tp2_definitions WHERE id=tp2_definitions_seq.CURRVAL");
            if (RS.next()) {
                int id = RS.getInt("id");
                Timestamp testTime = RS.getTimestamp("test_time");
                RS.close();
                stmt.executeUpdate("INSERT INTO tp2_sessions_results SET def_id=" + id + "," + "session_id=" + sessionId);
                stmt.close();
                Tp2Result result = new Tp2Result(id, serverNode, dbDescription, userCount, duration, userType, testTime, tps, tpsPerUserAverage, tpsPerUserDeviation, transactionCount, errorCount, ioReads, ioWrites);
                Tp2Result.getConnection().commit();
                return result;
            }
            RS.close();
            stmt.close();
            Tp2Result.getConnection().rollback();
            throw new SQLException("TP2 Result was not properly inserted");
        }
        Tp2Result result = new Tp2Result(NonPersistent.getNextId(class$com$sap$sapdb$benchmark$tp2$common$Tp2Result == null ? (class$com$sap$sapdb$benchmark$tp2$common$Tp2Result = Tp2Result.class$("com.sap.sapdb.benchmark.tp2.common.Tp2Result")) : class$com$sap$sapdb$benchmark$tp2$common$Tp2Result), serverNode, dbDescription, userCount, duration, userType, new Date(), tps, tpsPerUserAverage, tpsPerUserDeviation, transactionCount, errorCount, ioReads, ioWrites);
        NonPersistent.insert(result);
        return result;
    }

    public static Tp2Result loadTp2Result(int id) throws SQLException {
        if (!StorableObject.isNonPersistent()) {
            Statement stmt = Tp2Result.getConnection().createStatement();
            ResultSet RS = stmt.executeQuery("SELECT def.servernode_id,def.dbdescription_id,def.usercount,def.duration,def.user_type,def.test_time,res.tcount,res.tps,res.tpspu_avg,res.tpspu_dev,res.errors,res.ioreads,res.iowrites FROM tp2_definitions def, tp2_results res WHERE def.id=res.def_id AND def.id=" + id);
            if (RS.next()) {
                Tp2Result result = new Tp2Result(id, ServerNode.loadServerNode(RS.getInt("servernode_id")), DBDescription.loadDBDescription(RS.getInt("dbdescription_id")), RS.getInt("usercount"), RS.getInt("duration"), RS.getString("user_type"), RS.getTimestamp("test_time"), RS.getFloat("tps"), RS.getFloat("tpspu_avg"), RS.getFloat("tpspu_dev"), RS.getInt("tcount"), RS.getInt("errors"), RS.getLong("ioreads"), RS.getLong("iowrites"));
                RS.close();
                stmt.close();
                Tp2Result.getConnection().commit();
                return result;
            }
            RS.close();
            stmt.close();
            Tp2Result.getConnection().rollback();
            return null;
        }
        return (Tp2Result)NonPersistent.select(class$com$sap$sapdb$benchmark$tp2$common$Tp2Result == null ? (class$com$sap$sapdb$benchmark$tp2$common$Tp2Result = Tp2Result.class$("com.sap.sapdb.benchmark.tp2.common.Tp2Result")) : class$com$sap$sapdb$benchmark$tp2$common$Tp2Result, id);
    }

    public static void deleteSession(int sessionId) throws SQLException {
        Statement stmt = Tp2Result.getConnection().createStatement();
        Statement stmt2 = Tp2Result.getConnection().createStatement();
        Connection conJavatestinfo = DriverManager.getConnection("jdbc:sapdb://PTS/QADB", "TESTER", "TESTER");
        Statement stmtJavatestinfo = conJavatestinfo.createStatement();
        try {
            Session sess = Session.loadSession(sessionId);
            StringBuffer defIdList = null;
            ResultSet RS = stmt.executeQuery("SELECT name FROM sessions, users WHERE sessions.id=" + sess.getId() + " AND sessions.user_id = users.id");
            String user = null;
            if (RS.next()) {
                user = RS.getString("name");
            }
            int noOfTestIds = 0;
            RS = stmt.executeQuery("SELECT count(*) as cnt FROM tp2_sessions_results WHERE session_id=" + sess.getId());
            if (RS.next()) {
                noOfTestIds = RS.getInt("cnt");
            }
            Vector<Timestamp> javatestinfoIds = new Vector<Timestamp>(noOfTestIds + 1);
            RS = stmt.executeQuery("SELECT def_id FROM tp2_sessions_results WHERE session_id=" + sess.getId());
            while (RS.next()) {
                if (defIdList == null) {
                    defIdList = new StringBuffer("");
                } else {
                    defIdList.append(',');
                }
                defIdList.append(RS.getString("def_id"));
            }
            RS.close();
            if (defIdList != null) {
                ResultSet RS2 = stmt2.executeQuery("SELECT td.id as id, sn.host_name as host, td.test_time as starttime  FROM tp2_definitions td, servernodes sn\t WHERE td.id IN (" + defIdList.toString() + ")" + " AND td.servernode_id = sn.id order by host, starttime");
                boolean i = false;
                while (RS2.next()) {
                    ResultSet RSJTI = stmtJavatestinfo.executeQuery("SELECT driverstarted FROM javatestinfo WHERE driverfqhn like '" + RS2.getString("host") + "%' " + "AND testname like '%cases.CompareMAXCPU%' " + "AND testuser = '" + user + "' " + "AND driverstarted < '" + RS2.getTimestamp("starttime") + "' " + "AND driverfinished > '" + RS2.getTimestamp("starttime") + "' ");
                    if (!RSJTI.next() || javatestinfoIds.contains(RSJTI.getTimestamp("driverstarted"))) continue;
                    javatestinfoIds.add(RSJTI.getTimestamp("driverstarted"));
                }
                for (int j = 0; j < javatestinfoIds.size(); ++j) {
                    stmtJavatestinfo.executeUpdate("INSERT javatestweg set driverstarted = '" + javatestinfoIds.elementAt(j) + "'");
                }
                stmt.executeUpdate("DELETE FROM tp2_xcons_all WHERE def_id IN (" + defIdList.toString() + ")");
                stmt.executeUpdate("DELETE FROM tp2_sessions_results WHERE def_id IN (" + defIdList.toString() + ")");
                stmt.executeUpdate("DELETE FROM tp2_results WHERE def_id IN (" + defIdList.toString() + ")");
                stmt.executeUpdate("DELETE FROM tp2_definitions WHERE id IN (" + defIdList.toString() + ")");
            }
            stmt.executeUpdate("DELETE FROM tp2_sessions_results WHERE session_id=" + sess.getId());
            stmt.executeUpdate("DELETE FROM tp2_sessions_servernodes WHERE session_id=" + sess.getId());
            stmt.executeUpdate("DELETE FROM sessions WHERE id=" + sess.getId());
            stmt.close();
            Tp2Result.getConnection().commit();
        }
        catch (SQLException e) {
            stmt.close();
            Tp2Result.getConnection().rollback();
            throw e;
        }
    }

    public Tp2Result(int id, ServerNode serverNode, DBDescription dbDescription, int userCount, int duration, String userType, Date testTime, float tps, float tpsPerUserAverage, float tpsPerUserDeviation, int transactionCount, int errorCount, long ioReads, long ioWrites) {
        super(id);
        this.serverNode = serverNode;
        this.dbDescription = dbDescription;
        this.userCount = userCount;
        this.duration = duration;
        this.testTime = testTime;
        this.userType = userType;
        this.transactionCount = transactionCount;
        this.tps = tps;
        this.tpsPerUserAverage = tpsPerUserAverage;
        this.tpsPerUserDeviation = tpsPerUserDeviation;
        this.errorCount = errorCount;
        this.ioReads = ioReads;
        this.ioWrites = ioWrites;
    }

    public void delete() throws SQLException {
        Statement stmt = null;
        try {
            stmt = Tp2Result.getConnection().createStatement();
            stmt.executeUpdate("DELETE FROM tp2_xcons_all WHERE def_id=" + this.getId());
            stmt.executeUpdate("DELETE FROM tp2_sessions_results WHERE def_id=" + this.getId());
            stmt.executeUpdate("DELETE FROM tp2_results WHERE def_id=" + this.getId());
            stmt.executeUpdate("DELETE FROM tp2_definitions WHERE id=" + this.getId());
            Tp2Result.getConnection().commit();
            stmt.close();
        }
        catch (SQLException e) {
            Tp2Result.getConnection().rollback();
            stmt.close();
            throw e;
        }
    }

    public String toString() {
        return "Tp2Result[" + this.getId() + "] => " + this.tps + " TPS";
    }

    public String getInfoAsXml() {
        return "<Tp2Result id=\"" + this.getId() + "\" userCount=\"" + this.userCount + "\" MAXCPU=\"" + this.dbDescription.getMAXCPU() + "\" TPS=\"" + this.tps + "\"/>\n";
    }

    public String getFullInfoAsXml() {
        StringBuffer res = new StringBuffer("");
        res.append("<Tp2Result id=\"" + this.getId() + "\" userCount=\"" + this.userCount + "\" MAXCPU=\"" + this.dbDescription.getMAXCPU() + "\" TPS=\"" + this.tps + "\">\n");
        res.append("<Definition>\n");
        res.append("<Id>").append(this.getId()).append("</Id>\n");
        res.append("<UserType>").append(this.userType).append("</UserType>\n");
        res.append("<DBDescription>").append(this.dbDescription).append("</DBDescription>\n");
        res.append("<ServerNode>").append(this.serverNode).append("</ServerNode>\n");
        res.append("<UserCount>").append(this.userCount).append("</UserCount>\n");
        res.append("<Duration>").append(this.duration).append("</Duration>\n");
        res.append("<TestTime>").append(this.testTime).append("</TestTime>\n");
        res.append("</Definition>\n");
        res.append("<Result>\n");
        res.append("<Tps>").append(this.tps).append("</Tps>\n");
        res.append("<TransactionCount>").append(this.transactionCount).append("</TransactionCount>\n");
        res.append("<TpsPerUserAverage>").append(this.tpsPerUserAverage).append("</TpsPerUserAverage>\n");
        res.append("<TpsPerUserDeviation>").append(this.tpsPerUserDeviation).append("</TpsPerUserDeviation>\n");
        res.append("<ErrorCount>").append(this.errorCount).append("</ErrorCount>\n");
        res.append("<IoReads>").append(this.ioReads).append("</IoReads>\n");
        res.append("<IoWrites>").append(this.ioWrites).append("</IoWrites>\n");
        res.append("</Result>\n");
        res.append("</Tp2Result>\n");
        return res.toString();
    }

    public Session getRelatedSession() throws SQLException {
        Statement stmt = Tp2Result.getConnection().createStatement();
        ResultSet RS = stmt.executeQuery("SELECT session_id FROM tp2_sessions_results WHERE def_id=" + this.getId());
        if (RS.next()) {
            int sessionId = RS.getInt("session_id");
            RS.close();
            stmt.close();
            Tp2Result.getConnection().commit();
            return Session.loadSession(sessionId);
        }
        RS.close();
        stmt.close();
        Tp2Result.getConnection().rollback();
        throw new SQLException("Results with id " + this.getId() + " is bound with no session");
    }

    public void getXConsShowAllInStream(Writer out) throws IOException, SQLException {
        Statement stmt = Tp2Result.getConnection().createStatement();
        ResultSet RS = stmt.executeQuery("SELECT xcons_all FROM tp2_xcons_all WHERE def_id=" + this.getId());
        if (RS.next()) {
            Blob blob = RS.getBlob("xcons_all");
            ZipInputStream in = new ZipInputStream(blob.getBinaryStream());
            in.getNextEntry();
            BufferedReader inC = new BufferedReader(new InputStreamReader(in));
            String line = null;
            while ((line = inC.readLine()) != null) {
                out.write(line + "\n");
            }
            inC.close();
        }
        RS.close();
        stmt.close();
        Tp2Result.getConnection().commit();
    }

    public int getUserCount() {
        return this.userCount;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getTps() {
        return Math.round(this.tps);
    }

    public float getTpsAsFloat() {
        return this.tps;
    }

    public ServerNode getServerNode() {
        return this.serverNode;
    }

    public DBDescription getDBDescription() {
        return this.dbDescription;
    }

    public String getUserType() {
        return this.userType;
    }

    public AccessType getAccessType() {
        try {
            return new AccessType(this.userType);
        }
        catch (Tp2Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Date getTestTime() {
        return this.testTime;
    }

    public float getTpsPerUserAverage() {
        return this.tpsPerUserAverage;
    }

    public float getTpsPerUserDeviation() {
        return this.tpsPerUserDeviation;
    }

    public int getTransactionCount() {
        return this.transactionCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public long getIoReads() {
        return this.ioReads;
    }

    public long getIoWrites() {
        return this.ioWrites;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

